/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ConcurrentUpdateDocumentException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.core.storage.ConcurrentUpdateStorageException;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageBlob;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.lock.LockException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentProxy;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class SQLSession
implements org.nuxeo.ecm.core.model.Session {
    protected final Log log = LogFactory.getLog(SQLSession.class);
    public static final String ALLOW_NEGATIVE_ACL_PROPERTY = "nuxeo.security.allowNegativeACL";
    public static final String BLOB_NAME = "name";
    public static final String BLOB_MIME_TYPE = "mime-type";
    public static final String BLOB_ENCODING = "encoding";
    public static final String BLOB_DIGEST = "digest";
    public static final String BLOB_LENGTH = "length";
    public static final String BLOB_DATA = "data";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String DC_ISSUED = "dc:issued";
    public static final String RELATED_TEXT_RESOURCES = "relatedtextresources";
    public static final String RELATED_TEXT_ID = "relatedtextid";
    public static final String RELATED_TEXT = "relatedtext";
    protected static final Set<String> VERSION_WRITABLE_PROPS = new HashSet<String>(Arrays.asList("ecm:fulltextJobId", "ecm:binaryText", "ecm:lifeCycleState", "ecm:lockOwner", "ecm:lockCreated", "dc:issued", "relatedtextresources", "relatedtextid", "relatedtext"));
    private final Repository repository;
    private final Session session;
    private Document root;
    private final String sessionId;
    private final boolean negativeAclAllowed;
    private static final Pattern dotDigitsPattern = Pattern.compile("(.*)\\.[0-9]+$");
    protected static final Pattern ORDER_BY_PATH_ASC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s*$", 34);
    protected static final Pattern ORDER_BY_PATH_DESC = Pattern.compile("(.*)\\s+ORDER\\s+BY\\s+ecm:path\\s+DESC\\s*$", 34);

    public SQLSession(Session session, Repository repository, String sessionId) throws DocumentException {
        Node rootNode;
        this.session = session;
        this.repository = repository;
        try {
            rootNode = session.getRootNode();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        this.sessionId = sessionId;
        this.root = this.newDocument(rootNode);
        this.negativeAclAllowed = Framework.isBooleanPropertyTrue((String)ALLOW_NEGATIVE_ACL_PROPERTY);
    }

    public Document getRootDocument() {
        return this.root;
    }

    public Document getNullDocument() {
        return new SQLDocumentLive(null, null, this, true);
    }

    public void close() {
        this.root = null;
        try {
            this.session.close();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() throws DocumentException {
        try {
            this.session.save();
        }
        catch (ConcurrentUpdateStorageException e) {
            throw new ConcurrentUpdateDocumentException((Throwable)((Object)e));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public boolean isLive() {
        return this.session != null && this.session.isLive();
    }

    public boolean isStateSharedByAllThreadSessions() {
        return this.session.isStateSharedByAllThreadSessions();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    protected String idToString(Serializable id) {
        try {
            return this.session.getModel().idToString(id);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    protected Serializable idFromString(String id) {
        try {
            return this.session.getModel().idFromString(id);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Document getDocumentByUUID(String uuid) throws DocumentException {
        Document doc = this.getDocumentById(this.idFromString(uuid));
        if (doc == null) {
            throw new NoSuchDocumentException(uuid);
        }
        return doc;
    }

    public Document resolvePath(String path) throws DocumentException {
        Node node;
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            node = this.session.getNodeByPath(path, this.session.getRootNode());
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        Document doc = this.newDocument(node);
        if (doc == null) {
            throw new NoSuchDocumentException(path);
        }
        return doc;
    }

    protected void orderBefore(Node node, Node src, Node dest) throws DocumentException {
        try {
            this.session.orderBefore(node, src, dest);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document move(Document source, Document parent, String name) throws DocumentException {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        try {
            if (name == null) {
                name = source.getName();
            }
            Node result = this.session.move(((SQLDocument)source).getNode(), ((SQLDocument)parent).getNode(), name);
            return this.newDocument(result);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected String findFreeName(Node parentNode, String name) throws StorageException {
        if (this.session.hasChildNode(parentNode, name, false)) {
            Matcher m = dotDigitsPattern.matcher(name);
            if (m.matches()) {
                name = m.group(1);
            }
            name = name + "." + System.nanoTime();
        }
        return name;
    }

    public Document copy(Document source, Document parent, String name) throws DocumentException {
        assert (source instanceof SQLDocument);
        assert (parent instanceof SQLDocument);
        try {
            if (name == null) {
                name = source.getName();
            }
            Node parentNode = ((SQLDocument)parent).getNode();
            name = this.findFreeName(parentNode, name);
            Node copy = this.session.copy(((SQLDocument)source).getNode(), parentNode, name);
            return this.newDocument(copy);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document getVersion(String versionableId, VersionModel versionModel) throws DocumentException {
        try {
            Serializable vid = this.idFromString(versionableId);
            Node versionNode = this.session.getVersionByLabel(vid, versionModel.getLabel());
            if (versionNode == null) {
                return null;
            }
            versionModel.setDescription(versionNode.getSimpleProperty("ecm:versionDescription").getString());
            versionModel.setCreated((Calendar)versionNode.getSimpleProperty("ecm:versionCreated").getValue());
            return this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document createProxy(Document doc, Document folder) throws DocumentException {
        try {
            Serializable versionableId;
            Node folderNode = ((SQLDocument)folder).getNode();
            Node targetNode = ((SQLDocument)doc).getNode();
            Serializable targetId = targetNode.getId();
            if (doc.isVersion()) {
                versionableId = targetNode.getSimpleProperty("ecm:versionableId").getValue();
            } else if (doc.isProxy()) {
                targetId = targetNode.getSimpleProperty("ecm:proxyTargetId").getValue();
                versionableId = targetNode.getSimpleProperty("ecm:proxyVersionableId").getValue();
            } else {
                versionableId = targetId;
            }
            String name = this.findFreeName(folderNode, doc.getName());
            Node proxy = this.session.addProxy(targetId, versionableId, folderNode, name, null);
            return this.newDocument(proxy);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Collection<Document> getProxies(Document document, Document parent) throws DocumentException {
        List<Node> proxyNodes;
        try {
            proxyNodes = this.session.getProxies(((SQLDocument)document).getNode(), parent == null ? null : ((SQLDocument)parent).getNode());
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> proxies = new ArrayList<Document>(proxyNodes.size());
        for (Node proxyNode : proxyNodes) {
            proxies.add(this.newDocument(proxyNode));
        }
        return proxies;
    }

    public void setProxyTarget(Document proxy, Document target) throws DocumentException {
        Node proxyNode = ((SQLDocument)proxy).getNode();
        Serializable targetId = this.idFromString(target.getUUID());
        try {
            this.session.setProxyTarget(proxyNode, targetId);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public Document importDocument(String uuid, Document parent, String name, String typeName, Map<String, Serializable> properties) throws DocumentException {
        Node parentNode;
        boolean isProxy = typeName.equals("ecm:proxy");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        Long pos = null;
        if (!isProxy) {
            Serializable importLockCreatedProp;
            Serializable importLockOwnerProp;
            String[] values;
            props.put("ecm:lifeCyclePolicy", properties.get("ecm:lifeCyclePolicy"));
            props.put("ecm:lifeCycleState", properties.get("ecm:lifeCycleState"));
            String key = (String)((Object)properties.get("ecm:lock"));
            if (key != null && (values = key.split(":")).length == 2) {
                String owner = values[0];
                GregorianCalendar created = new GregorianCalendar();
                try {
                    created.setTimeInMillis(DateFormat.getDateInstance(2).parse(values[1]).getTime());
                }
                catch (ParseException e) {
                    // empty catch block
                }
                props.put("ecm:lockOwner", (Serializable)((Object)owner));
                props.put("ecm:lockCreated", created);
            }
            if ((importLockOwnerProp = properties.get("ecm:lockOwner")) != null) {
                props.put("ecm:lockOwner", importLockOwnerProp);
            }
            if ((importLockCreatedProp = properties.get("ecm:lockCreated")) != null) {
                props.put("ecm:lockCreated", importLockCreatedProp);
            }
            props.put("ecm:majorVersion", properties.get("ecm:majorVersion"));
            props.put("ecm:minorVersion", properties.get("ecm:minorVersion"));
            props.put("ecm:isVersion", properties.get("ecm:isVersion"));
        }
        if (parent == null) {
            parentNode = null;
            props.put("ecm:versionableId", this.idFromString((String)((Object)properties.get("ecm:versionableId"))));
            props.put("ecm:versionCreated", properties.get("ecm:versionCreated"));
            props.put("ecm:versionLabel", properties.get("ecm:versionLabel"));
            props.put("ecm:versionDescription", properties.get("ecm:versionDescription"));
            props.put("ecm:isLatestVersion", properties.get("ecm:isLatestVersion"));
            props.put("ecm:isLatestMajorVersion", properties.get("ecm:isLatestMajorVersion"));
        } else {
            parentNode = ((SQLDocument)parent).getNode();
            if (isProxy) {
                props.put("ecm:proxyTargetId", this.idFromString((String)((Object)properties.get("ecm:proxyTargetId"))));
                props.put("ecm:proxyVersionableId", this.idFromString((String)((Object)properties.get("ecm:proxyVersionableId"))));
            } else {
                props.put("ecm:baseVersion", this.idFromString((String)((Object)properties.get("ecm:baseVersionId"))));
                props.put("ecm:isCheckedIn", properties.get("ecm:isCheckedIn"));
            }
        }
        return this.importChild(uuid, parentNode, name, pos, typeName, props);
    }

    public DocumentModelList query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws QueryException {
        try {
            List<Object> docs;
            Matcher matcher = ORDER_BY_PATH_ASC.matcher(query);
            Boolean orderByPath = matcher.matches() ? Boolean.TRUE : ((matcher = ORDER_BY_PATH_DESC.matcher(query)).matches() ? Boolean.FALSE : null);
            long limit = 0L;
            long offset = 0L;
            if (orderByPath != null) {
                query = matcher.group(1);
                limit = queryFilter.getLimit();
                offset = queryFilter.getOffset();
                queryFilter = QueryFilter.withoutLimitOffset((QueryFilter)queryFilter);
            }
            PartialList<Serializable> pl = this.session.query(query, queryType, queryFilter, countUpTo);
            List<Serializable> ids = pl.list;
            try {
                docs = this.getDocumentsById(ids);
            }
            catch (DocumentException e) {
                this.log.error((Object)("Could not fetch documents for ids: " + ids), (Throwable)e);
                docs = Collections.emptyList();
            }
            String[] schemas = new String[]{"common"};
            ArrayList<DocumentModelImpl> list = new ArrayList<DocumentModelImpl>(ids.size());
            for (Document document : docs) {
                try {
                    list.add(DocumentModelFactory.createDocumentModel((Document)document, (String[])schemas));
                }
                catch (DocumentException e) {
                    this.log.error((Object)("Could not create document model for doc: " + document), (Throwable)e);
                }
            }
            if (orderByPath != null) {
                Collections.sort(list, new PathComparator(orderByPath));
            }
            if (limit != 0L) {
                int size = list.size();
                list.subList(0, (int)(offset > (long)size ? (long)size : offset)).clear();
                size = list.size();
                if (limit < (long)size) {
                    list.subList((int)limit, size).clear();
                }
            }
            return new DocumentModelListImpl(list, pl.totalSize);
        }
        catch (QueryParseException | StorageException e) {
            throw new QueryException(((Throwable)e).getMessage() + ": " + query, (Throwable)e);
        }
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object[] params) throws QueryException {
        try {
            return this.session.queryAndFetch(query, queryType, queryFilter, params);
        }
        catch (StorageException e) {
            throw new QueryException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private Document newDocument(Node node) throws DocumentException {
        return this.newDocument(node, true);
    }

    private Document newDocument(Node node, boolean readonly) throws DocumentException {
        SchemaManager schemaManager;
        DocumentType type;
        if (node == null) {
            return null;
        }
        Node targetNode = null;
        String typeName = node.getPrimaryType();
        if (node.isProxy()) {
            try {
                Serializable targetId = node.getSimpleProperty("ecm:proxyTargetId").getValue();
                if (targetId == null) {
                    throw new DocumentException("Proxy has null target");
                }
                targetNode = this.session.getNodeById(targetId);
                typeName = targetNode.getPrimaryType();
            }
            catch (StorageException e) {
                throw new DocumentException((Throwable)((Object)e));
            }
        }
        if ((type = (schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType(typeName)) == null) {
            throw new DocumentException("Unknown document type: " + typeName);
        }
        if (node.isProxy()) {
            SQLDocumentLive proxy = new SQLDocumentLive(node, (ComplexType)type, this, false);
            Document target = this.newDocument(targetNode, readonly);
            return new SQLDocumentProxy(proxy, target);
        }
        if (node.isVersion()) {
            return new SQLDocumentVersion(node, (ComplexType)type, this, readonly);
        }
        return new SQLDocumentLive(node, (ComplexType)type, this, false);
    }

    protected Document getDocumentById(Serializable id) throws DocumentException {
        try {
            Node node = this.session.getNodeById(id);
            return node == null ? null : this.newDocument(node);
        }
        catch (StorageException e) {
            throw new DocumentException("Failed to get document: " + id, (Throwable)((Object)e));
        }
    }

    protected List<Document> getDocumentsById(List<Serializable> ids) throws DocumentException {
        ArrayList<Document> docs = new ArrayList<Document>(ids.size());
        try {
            List<Node> nodes = this.session.getNodesByIds(ids);
            for (int index = 0; index < ids.size(); ++index) {
                Node eachNode = nodes.get(index);
                if (eachNode == null) {
                    Serializable eachId = ids.get(index);
                    this.log.warn((Object)("Cannot fetch document by id " + eachId), new Throwable("debug stack trace"));
                    continue;
                }
                docs.add(this.newDocument(eachNode));
            }
        }
        catch (StorageException e) {
            throw new DocumentException(e.toString(), (Throwable)((Object)e));
        }
        return docs;
    }

    protected Document getParent(Node node) throws DocumentException {
        try {
            return this.newDocument(this.session.getParentNode(node));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected String getPath(Node node) throws DocumentException {
        try {
            return this.session.getPath(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document getChild(Node node, String name) throws DocumentException {
        Node childNode;
        try {
            childNode = this.session.getChildNode(node, name, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        Document doc = this.newDocument(childNode);
        if (doc == null) {
            throw new NoSuchDocumentException(name);
        }
        return doc;
    }

    protected Node getChildProperty(Node node, String name, String typeName) throws StorageException {
        Node childNode = this.session.getChildNode(node, name, true);
        if (childNode == null) {
            childNode = this.session.addChildNode(node, name, null, typeName, true);
        }
        return childNode;
    }

    protected List<Document> getChildren(Node node) throws DocumentException {
        List<Node> nodes;
        try {
            nodes = this.session.getChildren(node, null, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> children = new ArrayList<Document>(nodes.size());
        for (Node n : nodes) {
            try {
                children.add(this.newDocument(n));
            }
            catch (DocumentException e) {}
        }
        return children;
    }

    protected boolean hasChild(Node node, String name) throws DocumentException {
        try {
            return this.session.hasChildNode(node, name, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected boolean hasChildren(Node node) throws DocumentException {
        try {
            return this.session.hasChildren(node, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document addChild(Node parent, String name, Long pos, String typeName) throws DocumentException {
        try {
            return this.newDocument(this.session.addChildNode(parent, name, pos, typeName, false));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document importChild(String uuid, Node parent, String name, Long pos, String typeName, Map<String, Serializable> props) throws DocumentException {
        try {
            Serializable id = this.idFromString(uuid);
            Node node = this.session.addChildNode(id, parent, name, pos, typeName, false);
            for (Map.Entry<String, Serializable> entry : props.entrySet()) {
                node.setSimpleProperty(entry.getKey(), entry.getValue());
            }
            return this.newDocument(node, false);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected boolean addMixinType(Node node, String mixin) throws DocumentException {
        try {
            return this.session.addMixinType(node, mixin);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected boolean removeMixinType(Node node, String mixin) throws DocumentException {
        try {
            return this.session.removeMixinType(node, mixin);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected List<Node> getComplexList(Node node, String name) throws DocumentException {
        List<Node> nodes;
        try {
            nodes = this.session.getChildren(node, name, true);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        return nodes;
    }

    protected void remove(Node node) throws DocumentException {
        try {
            this.session.removeNode(node);
        }
        catch (ConcurrentUpdateStorageException e) {
            throw new ConcurrentUpdateDocumentException((Throwable)((Object)e));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected void removeProperty(Node node) throws DocumentException {
        try {
            this.session.removePropertyNode(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document checkIn(Node node, String label, String checkinComment) throws DocumentException {
        try {
            Node versionNode = this.session.checkIn(node, label, checkinComment);
            return versionNode == null ? null : this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected void checkOut(Node node) throws DocumentException {
        try {
            this.session.checkOut(node);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected void restore(Node node, Node version) throws DocumentException {
        try {
            this.session.restore(node, version);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Document getVersionByLabel(String versionSeriesId, String label) throws DocumentException {
        try {
            Serializable vid = this.idFromString(versionSeriesId);
            Node versionNode = this.session.getVersionByLabel(vid, label);
            return versionNode == null ? null : this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected List<Document> getVersions(String versionSeriesId) throws DocumentException {
        List<Node> versionNodes;
        try {
            Serializable vid = this.idFromString(versionSeriesId);
            versionNodes = this.session.getVersions(vid);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        ArrayList<Document> versions = new ArrayList<Document>(versionNodes.size());
        for (Node versionNode : versionNodes) {
            versions.add(this.newDocument(versionNode));
        }
        return versions;
    }

    public Document getLastVersion(String versionSeriesId) throws DocumentException {
        try {
            Serializable vid = this.idFromString(versionSeriesId);
            Node versionNode = this.session.getLastVersion(vid);
            if (versionNode == null) {
                return null;
            }
            return this.newDocument(versionNode);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Node getNodeById(Serializable id) throws DocumentException {
        try {
            return this.session.getNodeById(id);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    protected Lock getLock(Node node) throws DocumentException {
        try {
            return this.session.getLock(node.getId());
        }
        catch (LockException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    protected Lock setLock(Node node, Lock lock) throws DocumentException {
        try {
            return this.session.setLock(node.getId(), lock);
        }
        catch (LockException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    protected Lock removeLock(Node node, String owner) throws DocumentException {
        try {
            return this.session.removeLock(node.getId(), owner, false);
        }
        catch (LockException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    protected void readComplexProperty(ComplexProperty complexProperty, Node node) throws PropertyException {
        if (complexProperty instanceof BlobProperty) {
            try {
                StorageBlob value = this.readBlob(node);
                complexProperty.init((Serializable)value);
                return;
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + complexProperty.getName(), (Throwable)((Object)e));
            }
        }
        for (Property property : complexProperty) {
            String name = property.getField().getName().getPrefixedName();
            Type type = property.getType();
            try {
                if (type.isSimpleType()) {
                    Serializable value = node.getSimpleProperty(name).getValue();
                    if (value instanceof Delta) {
                        value = ((Delta)value).getFullValue();
                    }
                    property.init(value);
                    continue;
                }
                if (type.isListType()) {
                    List<Node> childNodes;
                    ListType listType = (ListType)type;
                    if (listType.getFieldType().isSimpleType()) {
                        Serializable[] value = node.getCollectionProperty(name).getValue();
                        property.init((Serializable)value);
                        continue;
                    }
                    try {
                        childNodes = this.getComplexList(node, name);
                    }
                    catch (DocumentException e) {
                        throw new PropertyException("Property: " + name, (Throwable)e);
                    }
                    Field listField = listType.getField();
                    ArrayList<Serializable> value = new ArrayList<Serializable>(childNodes.size());
                    for (Node childNode : childNodes) {
                        ComplexProperty p = (ComplexProperty)complexProperty.getRoot().createProperty(property, listField, 0);
                        this.readComplexProperty(p, childNode);
                        value.add(p.getValue());
                    }
                    property.init(value);
                    continue;
                }
                Node childNode = this.getChildProperty(node, name, type.getName());
                this.readComplexProperty((ComplexProperty)property, childNode);
                ((ComplexProperty)property).removePhantomFlag();
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + name, (Throwable)((Object)e));
            }
        }
    }

    public Map<String, Serializable> readPrefetch(Node node, ComplexType complexType, Set<String> xpaths) throws PropertyException {
        HashMap<String, Serializable> prefetch = new HashMap<String, Serializable>();
        this.readPrefetch(node, complexType, xpaths, null, null, prefetch);
        return prefetch;
    }

    protected void readPrefetch(Node node, ComplexType complexType, Set<String> xpaths, String xpathGeneric, String xpath, Map<String, Serializable> prefetch) throws PropertyException {
        if (TypeConstants.isContentType((Type)complexType)) {
            if (!xpaths.contains(xpathGeneric)) {
                return;
            }
            try {
                StorageBlob value = this.readBlob(node);
                prefetch.put(xpath, (Serializable)value);
                return;
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + xpath, (Throwable)((Object)e));
            }
        }
        for (Field field : complexType.getFields()) {
            String name = field.getName().getPrefixedName();
            Type type = field.getType();
            String xpg = xpathGeneric == null ? name : xpathGeneric + '/' + name;
            String xp = xpath == null ? name : xpath + '/' + name;
            try {
                if (type.isSimpleType()) {
                    if (!xpaths.contains(xpg)) continue;
                    Serializable value = node.getSimpleProperty(name).getValue();
                    prefetch.put(xp, value);
                    continue;
                }
                if (type.isListType()) {
                    List<Node> childNodes;
                    ListType listType = (ListType)type;
                    if (listType.getFieldType().isSimpleType()) {
                        if (!xpaths.contains(xpg)) continue;
                        Serializable[] value = node.getCollectionProperty(name).getValue();
                        prefetch.put(xp, (Serializable)value);
                        continue;
                    }
                    try {
                        childNodes = this.getComplexList(node, name);
                    }
                    catch (DocumentException e) {
                        throw new PropertyException("Property: " + name, (Throwable)e);
                    }
                    Field listField = listType.getField();
                    xpg = xpg + "/*";
                    int n = 0;
                    for (Node childNode : childNodes) {
                        this.readPrefetch(childNode, (ComplexType)listField.getType(), xpaths, xpg, xp + "/" + n++, prefetch);
                    }
                    continue;
                }
                Node childNode = this.getChildProperty(node, name, type.getName());
                this.readPrefetch(childNode, (ComplexType)type, xpaths, xpg, xp, prefetch);
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + name, (Throwable)((Object)e));
            }
        }
    }

    protected void writeComplexProperty(ComplexProperty complexProperty, Node node, SQLDocument doc) throws PropertyException {
        if (complexProperty instanceof BlobProperty) {
            try {
                this.writeBlobProperty((BlobProperty)complexProperty, node, doc);
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + complexProperty.getName(), (Throwable)((Object)e));
            }
            return;
        }
        for (Property property : complexProperty) {
            String name = property.getField().getName().getPrefixedName();
            try {
                if (this.checkReadOnlyIgnoredWrite(doc, property, node)) continue;
                Type type = property.getType();
                if (type.isSimpleType()) {
                    Serializable value = property.getValueForWrite();
                    node.getSimpleProperty(name).setValue(value);
                    if (!(value instanceof Delta)) continue;
                    value = ((Delta)value).getFullValue();
                    ((ScalarProperty)property).internalSetValue(value);
                    continue;
                }
                if (type.isListType()) {
                    int i;
                    List<Node> childNodes;
                    ListType listType = (ListType)type;
                    if (listType.getFieldType().isSimpleType()) {
                        Object[] value = property.getValueForWrite();
                        if (value instanceof List) {
                            value = ((List)value).toArray(new Object[0]);
                        }
                        node.getCollectionProperty(name).setValue(value);
                        continue;
                    }
                    Collection childProperties = property.getChildren();
                    try {
                        childNodes = this.getComplexList(node, name);
                    }
                    catch (DocumentException e) {
                        throw new PropertyException("Property: " + name, (Throwable)e);
                    }
                    int oldSize = childNodes.size();
                    int newSize = childProperties.size();
                    if (oldSize > newSize) {
                        for (i = oldSize - 1; i >= newSize; --i) {
                            try {
                                this.removeProperty(childNodes.remove(i));
                                continue;
                            }
                            catch (DocumentException e) {
                                throw new PropertyException("Property: " + name + '[' + i + ']', (Throwable)e);
                            }
                        }
                    }
                    if (oldSize < newSize) {
                        for (i = oldSize; i < newSize; ++i) {
                            Node childNode = this.session.addChildNode(node, name, Long.valueOf(i), listType.getFieldType().getName(), true);
                            childNodes.add(childNode);
                        }
                    }
                    i = 0;
                    for (Property childProperty : childProperties) {
                        Node childNode = childNodes.get(i++);
                        this.writeComplexProperty((ComplexProperty)childProperty, childNode, doc);
                    }
                    continue;
                }
                Node childNode = this.getChildProperty(node, name, type.getName());
                this.writeComplexProperty((ComplexProperty)property, childNode, doc);
            }
            catch (StorageException e) {
                throw new PropertyException("Property: " + name, (Throwable)((Object)e));
            }
        }
    }

    protected StorageBlob readBlob(Node node) throws StorageException {
        Binary binary = (Binary)node.getSimpleProperty(BLOB_DATA).getValue();
        if (binary == null) {
            return null;
        }
        String name = node.getSimpleProperty(BLOB_NAME).getString();
        String mimeType = node.getSimpleProperty(BLOB_MIME_TYPE).getString();
        String encoding = node.getSimpleProperty(BLOB_ENCODING).getString();
        String digest = node.getSimpleProperty(BLOB_DIGEST).getString();
        Long length = node.getSimpleProperty(BLOB_LENGTH).getLong();
        return new StorageBlob(binary, name, mimeType, encoding, digest, length.longValue());
    }

    protected void writeBlobProperty(BlobProperty blobProperty, Node node, SQLDocument doc) throws StorageException, PropertyException {
        Long length;
        String digest;
        String encoding;
        String mimeType;
        String name;
        Binary binary;
        Serializable value = blobProperty.getValueForWrite();
        if (value == null) {
            binary = null;
            name = null;
            mimeType = null;
            encoding = null;
            digest = null;
            length = null;
        } else {
            if (!(value instanceof Blob)) {
                throw new PropertyException("Setting a non-Blob value: " + value);
            }
            Blob blob = (Blob)value;
            try {
                binary = this.getBinary(blob);
            }
            catch (DocumentException e) {
                throw new PropertyException("Cannot get binary", (Throwable)e);
            }
            name = blob.getFilename();
            mimeType = blob.getMimeType();
            if (mimeType == null) {
                mimeType = APPLICATION_OCTET_STREAM;
            }
            encoding = blob.getEncoding();
            digest = blob.getDigest();
            length = binary.getLength();
        }
        node.getSimpleProperty(BLOB_DATA).setValue((Serializable)binary);
        node.getSimpleProperty(BLOB_NAME).setValue((Serializable)((Object)name));
        node.getSimpleProperty(BLOB_MIME_TYPE).setValue((Serializable)((Object)mimeType));
        node.getSimpleProperty(BLOB_ENCODING).setValue((Serializable)((Object)encoding));
        node.getSimpleProperty(BLOB_DIGEST).setValue((Serializable)((Object)digest));
        node.getSimpleProperty(BLOB_LENGTH).setValue(length);
    }

    protected static boolean isVersionWritableProperty(String name) {
        return VERSION_WRITABLE_PROPS.contains(name) || name.startsWith("ecm:binaryText") || name.startsWith("ecm:simpleText");
    }

    protected boolean checkReadOnlyIgnoredWrite(SQLDocument doc, Property property, Node node) throws PropertyException, StorageException {
        Serializable[] oldValue;
        String name = property.getField().getName().getPrefixedName();
        if (!doc.isReadOnly() || SQLSession.isVersionWritableProperty(name)) {
            return false;
        }
        if (!doc.isVersion()) {
            throw new PropertyException("Cannot write readonly property: " + name);
        }
        if (!name.startsWith("dc:")) {
            throw new SQLDocumentVersion.VersionNotModifiableException("Cannot set property on a version: " + name);
        }
        Serializable value = property.getValueForWrite();
        return ArrayUtils.isEquals((Object)value, (Object)(oldValue = property.getType().isSimpleType() ? node.getSimpleProperty(name).getValue() : node.getCollectionProperty(name).getValue()));
    }

    public Binary getBinary(Blob blob) throws DocumentException {
        if (blob instanceof StorageBlob) {
            return ((StorageBlob)blob).getBinary();
        }
        try {
            InputStream stream;
            StreamingBlob sb;
            StreamSource source;
            if (blob instanceof StreamingBlob && (source = (sb = (StreamingBlob)blob).getStreamSource()) instanceof FileSource && sb.isTemporary()) {
                return this.session.getBinary((FileSource)source);
            }
            try {
                stream = blob.getStream();
            }
            catch (IOException e) {
                throw new DocumentException((Throwable)e);
            }
            return this.session.getBinary(stream);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public boolean isNegativeAclAllowed() {
        return this.negativeAclAllowed;
    }

    public void setACP(Document doc, ACP acp, boolean overwrite) throws SecurityException {
        if (!overwrite && acp == null) {
            return;
        }
        this.checkNegativeAcl(acp);
        try {
            Object[] aclrows;
            Node node = ((SQLDocument)doc).getNode();
            if (overwrite) {
                aclrows = acp == null ? null : SQLSession.acpToAclRows(acp);
            } else {
                aclrows = (ACLRow[])node.getCollectionProperty("ecm:acl").getValue();
                aclrows = SQLSession.updateAclRows((ACLRow[])aclrows, acp);
            }
            node.getCollectionProperty("ecm:acl").setValue(aclrows);
            this.session.requireReadAclsUpdate();
        }
        catch (StorageException e) {
            throw new SecurityException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected void checkNegativeAcl(ACP acp) {
        if (this.negativeAclAllowed) {
            return;
        }
        if (acp == null) {
            return;
        }
        for (ACL acl : acp.getACLs()) {
            if (acl.getName().equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                String permission;
                if (ace.isGranted() || (permission = ace.getPermission()).equals("Everything") && ace.getUsername().equals("Everyone") || permission.equals("Write")) continue;
                throw new IllegalArgumentException("Negative ACL not allowed: " + ace);
            }
        }
    }

    public ACP getMergedACP(Document doc) throws SecurityException {
        try {
            Document base;
            Document document = base = doc.isVersion() ? doc.getSourceDocument() : doc;
            if (base == null) {
                return null;
            }
            ACP acp = this.getACP(base);
            if (doc.getParent() == null) {
                return acp;
            }
            ACL acl = null;
            if (acp == null || acp.getAccess("Everyone", "Everything") != Access.DENY) {
                acl = this.getInheritedACLs(doc);
            }
            if (acp == null) {
                if (acl == null) {
                    return null;
                }
                acp = new ACPImpl();
            }
            if (acl != null) {
                acp.addACL(acl);
            }
            return acp;
        }
        catch (DocumentException e) {
            throw new SecurityException("Failed to get merged acp", (Throwable)e);
        }
    }

    protected ACP getACP(Document doc) throws SecurityException {
        try {
            Node node = ((SQLDocument)doc).getNode();
            ACLRow[] aclrows = (ACLRow[])node.getCollectionProperty("ecm:acl").getValue();
            return SQLSession.aclRowsToACP(aclrows);
        }
        catch (StorageException e) {
            throw new SecurityException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected static ACP aclRowsToACP(ACLRow[] acls) {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = null;
        String name = null;
        for (ACLRow aclrow : acls) {
            String user;
            if (!aclrow.name.equals(name)) {
                if (acl != null) {
                    acp.addACL(acl);
                }
                name = aclrow.name;
                acl = new ACLImpl(name);
            }
            if ((user = aclrow.user) == null) {
                user = aclrow.group;
            }
            acl.add((Object)new ACE(user, aclrow.permission, aclrow.grant));
        }
        if (acl != null) {
            acp.addACL(acl);
        }
        return acp;
    }

    protected static ACLRow[] acpToAclRows(ACP acp) {
        LinkedList<ACLRow> aclrows = new LinkedList<ACLRow>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if (name.equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                SQLSession.addACLRow(aclrows, name, ace);
            }
        }
        ACLRow[] array = new ACLRow[aclrows.size()];
        return aclrows.toArray(array);
    }

    protected static ACLRow[] updateAclRows(ACLRow[] aclrows, ACP acp) {
        LinkedList<ACLRow> newaclrows = new LinkedList<ACLRow>();
        HashMap<String, ACL> aclmap = new HashMap<String, ACL>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if ("inherited".equals(name)) continue;
            aclmap.put(name, acl);
        }
        LinkedList<ACE> aces = Collections.emptyList();
        HashSet<String> aceKeys = null;
        String name = null;
        for (ACLRow aclrow : aclrows) {
            if (!aclrow.name.equals(name)) {
                for (ACE ace : aces) {
                    SQLSession.addACLRow(newaclrows, name, ace);
                }
                name = aclrow.name;
                ACL acl = (ACL)aclmap.remove(name);
                aces = acl == null ? Collections.emptyList() : new LinkedList<ACE>(Arrays.asList(acl.getACEs()));
                aceKeys = new HashSet<String>();
                for (ACE ace : aces) {
                    aceKeys.add(SQLSession.getACEkey(ace));
                }
            }
            if (aceKeys.contains(SQLSession.getACLrowKey(aclrow))) continue;
            newaclrows.add(new ACLRow(newaclrows.size(), name, aclrow.grant, aclrow.permission, aclrow.user, aclrow.group));
        }
        for (ACE ace : aces) {
            SQLSession.addACLRow(newaclrows, name, ace);
        }
        for (ACL acl : aclmap.values()) {
            name = acl.getName();
            for (ACE ace : acl.getACEs()) {
                SQLSession.addACLRow(newaclrows, name, ace);
            }
        }
        ACLRow[] array = new ACLRow[newaclrows.size()];
        return newaclrows.toArray(array);
    }

    protected static String getACEkey(ACE ace) {
        return ace.getUsername() + '|' + ace.getPermission();
    }

    protected static String getACLrowKey(ACLRow aclrow) {
        String user = aclrow.user;
        if (user == null) {
            user = aclrow.group;
        }
        return user + '|' + aclrow.permission;
    }

    protected static void addACLRow(List<ACLRow> aclrows, String name, ACE ace) {
        String user = ace.getUsername();
        if (user == null) {
            return;
        }
        String group = null;
        aclrows.add(new ACLRow(aclrows.size(), name, ace.isGranted(), ace.getPermission(), user, group));
    }

    protected ACL getInheritedACLs(Document doc) throws DocumentException {
        ACL merged = null;
        for (doc = doc.getParent(); doc != null; doc = doc.getParent()) {
            ACP acp = this.getACP(doc);
            if (acp == null) continue;
            ACL acl = acp.getMergedACLs("inherited");
            if (merged == null) {
                merged = acl;
            } else {
                merged.addAll((Collection)acl);
            }
            if (acp.getAccess("Everyone", "Everything") == Access.DENY) break;
        }
        return merged;
    }

    public Map<String, String> getBinaryFulltext(String id) throws DocumentException {
        try {
            return this.session.getBinaryFulltext(this.idFromString(id));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public static class PathComparator
    implements Comparator<DocumentModel> {
        private final int sign;

        public PathComparator(boolean asc) {
            this.sign = asc ? 1 : -1;
        }

        @Override
        public int compare(DocumentModel doc1, DocumentModel doc2) {
            String p1 = doc1.getPathAsString();
            String p2 = doc2.getPathAsString();
            if (p1 == null && p2 == null) {
                return this.sign * doc1.getId().compareTo(doc2.getId());
            }
            if (p1 == null) {
                return this.sign;
            }
            if (p2 == null) {
                return -1 * this.sign;
            }
            return this.sign * p1.compareTo(p2);
        }
    }
}

