/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import javax.resource.ResourceException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.ecm.core.storage.ConcurrentUpdateStorageException;
import org.nuxeo.ecm.core.storage.ConnectionResetException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.XAResourceConnectionAdapter;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.datasource.ConnectionHelper;

public class JDBCConnection {
    protected final Model model;
    protected final SQLInfo sqlInfo;
    protected final Dialect dialect;
    protected final XADataSource xadatasource;
    private XAConnection xaconnection;
    public Connection connection;
    protected boolean supportsBatchUpdates;
    protected XAResource xaresource = new XAResourceConnectionAdapter(this);
    protected final JDBCConnectionPropagator connectionPropagator;
    protected final boolean noSharing;
    protected volatile boolean checkConnectionValid;
    public boolean countExecutes;
    public int executeCount;
    private static final AtomicLong instanceCounter = new AtomicLong(0L);
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final JDBCLogger logger = new JDBCLogger(String.valueOf(this.instanceNumber));

    public JDBCConnection(Model model, SQLInfo sqlInfo, XADataSource xadatasource, JDBCConnectionPropagator connectionPropagator, boolean noSharing) throws StorageException {
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.xadatasource = xadatasource;
        this.connectionPropagator = connectionPropagator;
        this.noSharing = noSharing;
        this.dialect = sqlInfo.dialect;
        connectionPropagator.addConnection(this);
    }

    public JDBCConnection() {
        this.xadatasource = null;
        this.sqlInfo = null;
        this.noSharing = false;
        this.model = null;
        this.dialect = null;
        this.connectionPropagator = null;
    }

    public Mapper.Identification getIdentification() {
        return new Mapper.Identification(null, "" + this.instanceNumber);
    }

    protected void countExecute() {
        if (this.countExecutes) {
            ++this.executeCount;
        }
    }

    protected void openConnections() throws StorageException {
        try {
            this.openBaseConnection();
            this.supportsBatchUpdates = this.connection.getMetaData().supportsBatchUpdates();
            this.dialect.performPostOpenStatements(this.connection);
        }
        catch (SQLException | ResourceException cause) {
            throw new StorageException("Cannot connect to database", cause);
        }
    }

    protected void openBaseConnection() throws SQLException, ResourceException {
        String repositoryName = this.model.getRepositoryDescriptor().name;
        String dataSourceName = ConnectionHelper.getPseudoDataSourceNameForRepository((String)repositoryName);
        this.connection = ConnectionHelper.getConnection((String)dataSourceName, (boolean)this.noSharing);
        if (this.connection == null) {
            this.xaconnection = JDBCUtils.getXAConnection((XADataSource)this.xadatasource);
            this.connection = this.xaconnection.getConnection();
            this.xaresource = this.xaconnection.getXAResource();
        } else {
            this.xaconnection = null;
        }
    }

    public void close() {
        this.connectionPropagator.removeConnection(this);
        this.closeConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnections() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.checkConnectionValid = true;
            }
            finally {
                this.connection = null;
            }
        }
        if (this.xaconnection != null) {
            try {
                this.xaconnection.close();
            }
            catch (SQLException e) {
                this.checkConnectionValid = true;
            }
            finally {
                this.xaconnection = null;
            }
        }
    }

    protected void resetConnection() throws StorageException {
        this.logger.error("Resetting connection");
        this.closeConnections();
        this.openConnections();
        this.connectionPropagator.connectionWasReset(this);
    }

    protected void connectionWasReset() {
        this.checkConnectionValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionValid() throws StorageException {
        if (this.checkConnectionValid) {
            block15: {
                if (this.connection == null) {
                    this.resetConnection();
                }
                Statement st = null;
                try {
                    st = this.connection.createStatement();
                    st.execute(this.dialect.getValidationQuery());
                }
                catch (Exception e) {
                    if (this.dialect.isConnectionClosedException(e)) {
                        this.resetConnection();
                        break block15;
                    }
                    throw new StorageException(e);
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.checkConnectionValid = false;
        }
    }

    protected void checkConnectionReset(Throwable t) throws StorageException {
        this.checkConnectionReset(t, false);
    }

    protected void checkConnectionReset(Throwable t, boolean throwIfReset) throws StorageException, ConnectionResetException {
        if (this.connection == null || this.dialect.isConnectionClosedException(t)) {
            this.resetConnection();
            if (throwIfReset) {
                throw new ConnectionResetException(t);
            }
        }
    }

    protected void checkConnectionReset(XAException e) {
        if (this.connection == null || this.dialect.isConnectionClosedException(e)) {
            try {
                this.resetConnection();
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
    }

    protected void checkConcurrentUpdate(Throwable t) throws ConcurrentUpdateStorageException {
        if (this.dialect.isConcurrentUpdateException(t)) {
            throw new ConcurrentUpdateStorageException(t);
        }
    }

    protected void closeStatement(Statement s) throws SQLException {
        try {
            s.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

