/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mustache;

import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.common.mustache.Code;
import org.elasticsearch.common.mustache.DefaultMustacheFactory;
import org.elasticsearch.common.mustache.Mustache;
import org.elasticsearch.common.mustache.MustacheVisitor;
import org.elasticsearch.common.mustache.PragmaHandler;
import org.elasticsearch.common.mustache.TemplateContext;
import org.elasticsearch.common.mustache.codes.DefaultCode;
import org.elasticsearch.common.mustache.codes.DefaultMustache;
import org.elasticsearch.common.mustache.codes.ExtendCode;
import org.elasticsearch.common.mustache.codes.ExtendNameCode;
import org.elasticsearch.common.mustache.codes.IterableCode;
import org.elasticsearch.common.mustache.codes.NotIterableCode;
import org.elasticsearch.common.mustache.codes.PartialCode;
import org.elasticsearch.common.mustache.codes.ValueCode;
import org.elasticsearch.common.mustache.codes.WriteCode;

public class DefaultMustacheVisitor
implements MustacheVisitor {
    protected static Logger logger = Logger.getLogger(DefaultMustacheVisitor.class.getSimpleName());
    private static final Code EOF = new DefaultCode();
    protected final List<Code> list = new LinkedList<Code>();
    private final Map<String, PragmaHandler> handlers = new HashMap<String, PragmaHandler>(){
        {
            this.put("implicit-iterator", new PragmaHandler(){

                @Override
                public Code handle(String pragma, String args) {
                    return new DefaultCode(){

                        @Override
                        public Writer execute(Writer writer, Object[] scopes) {
                            return super.execute(writer, scopes);
                        }
                    };
                }
            });
        }
    };
    protected DefaultMustacheFactory df;

    public DefaultMustacheVisitor(DefaultMustacheFactory df) {
        this.df = df;
    }

    public void addPragmaHandler(String pragma, PragmaHandler handler) {
        this.handlers.put(pragma.toLowerCase(), handler);
    }

    @Override
    public Mustache mustache(TemplateContext templateContext) {
        return new DefaultMustache(templateContext, this.df, this.list.toArray(new Code[this.list.size()]), templateContext.file());
    }

    @Override
    public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void notIterable(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new NotIterableCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void name(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendNameCode(templateContext, this.df, mustache, variable));
    }

    @Override
    public void partial(TemplateContext tc, String variable) {
        TemplateContext partialTC = new TemplateContext("{{", "}}", tc.file(), tc.line(), tc.startOfLine());
        this.list.add(new PartialCode(partialTC, this.df, variable));
    }

    @Override
    public void value(TemplateContext tc, String variable, boolean encoded) {
        this.list.add(new ValueCode(tc, this.df, variable, encoded));
    }

    @Override
    public void write(TemplateContext tc, String text) {
        if (text.length() > 0) {
            int size = this.list.size();
            if (size > 0) {
                Code code = this.list.get(size - 1);
                code.append(text);
            } else {
                this.list.add(new WriteCode(tc, this.df, text));
            }
        }
    }

    @Override
    public void pragma(TemplateContext tc, String pragma, String args) {
        PragmaHandler pragmaHandler = this.handlers.get(pragma.toLowerCase());
        if (pragmaHandler == null) {
            logger.warning("Unimplemented pragma: " + pragma);
        } else {
            Code code = pragmaHandler.handle(pragma, args);
            if (code != null) {
                this.list.add(code);
            }
        }
    }

    @Override
    public void eof(TemplateContext templateContext) {
        this.list.add(EOF);
    }

    @Override
    public void extend(TemplateContext templateContext, String variable, Mustache mustache) {
        this.list.add(new ExtendCode(templateContext, this.df, mustache, variable));
    }
}

