/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestNodesStatsAction
extends BaseRestHandler {
    @Inject
    public RestNodesStatsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats/{metric}/{indexMetric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats/{metric}/{indexMetric}/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}/{indexMetric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}/{indexMetric}/{fields}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metrics = Strings.splitStringByCommaToSet(request.param("metric", "_all"));
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodesIds);
        nodesStatsRequest.listenerThreaded(false);
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesStatsRequest.all();
            nodesStatsRequest.indices(CommonStatsFlags.ALL);
        } else {
            nodesStatsRequest.clear();
            nodesStatsRequest.os(metrics.contains("os"));
            nodesStatsRequest.jvm(metrics.contains("jvm"));
            nodesStatsRequest.threadPool(metrics.contains("thread_pool"));
            nodesStatsRequest.network(metrics.contains("network"));
            nodesStatsRequest.fs(metrics.contains("fs"));
            nodesStatsRequest.transport(metrics.contains("transport"));
            nodesStatsRequest.http(metrics.contains("http"));
            nodesStatsRequest.indices(metrics.contains("indices"));
            nodesStatsRequest.process(metrics.contains("process"));
            nodesStatsRequest.breaker(metrics.contains("breaker"));
            if (metrics.contains("indices")) {
                Set<String> indexMetrics = Strings.splitStringByCommaToSet(request.param("indexMetric", "_all"));
                if (indexMetrics.size() == 1 && indexMetrics.contains("_all")) {
                    nodesStatsRequest.indices(CommonStatsFlags.ALL);
                } else {
                    CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
                    for (CommonStatsFlags.Flag flag : CommonStatsFlags.Flag.values()) {
                        flags.set(flag, indexMetrics.contains(flag.getRestName()));
                    }
                    nodesStatsRequest.indices(flags);
                }
            }
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.FieldData) && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            nodesStatsRequest.indices().fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Completion) && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            nodesStatsRequest.indices().completionDataFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Search) && request.hasParam("groups")) {
            nodesStatsRequest.indices().groups(request.paramAsStringArray("groups", null));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Indexing) && request.hasParam("types")) {
            nodesStatsRequest.indices().types(request.paramAsStringArray("types", null));
        }
        this.client.admin().cluster().nodesStats(nodesStatsRequest, new ActionListener<NodesStatsResponse>(){

            @Override
            public void onResponse(NodesStatsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestNodesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

