/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterableServer;
import com.mongodb.ClusterableServerFactory;
import com.mongodb.ConnectionPoolSettings;
import com.mongodb.DBPortFactory;
import com.mongodb.DefaultServer;
import com.mongodb.JMXConnectionPoolListener;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.PooledConnectionProvider;
import com.mongodb.ServerAddress;
import com.mongodb.ServerSettings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final String clusterId;
    private ServerSettings settings;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Mongo mongo;

    public DefaultClusterableServerFactory(String clusterId, ServerSettings settings, ScheduledExecutorService scheduledExecutorService, Mongo mongo) {
        this.clusterId = clusterId;
        this.settings = settings;
        this.scheduledExecutorService = scheduledExecutorService;
        this.mongo = mongo;
    }

    public ClusterableServer create(ServerAddress serverAddress) {
        MongoOptions options = this.mongo.getMongoOptions();
        ConnectionPoolSettings connectionPoolSettings = ConnectionPoolSettings.builder().minSize(options.minConnectionsPerHost).maxSize(options.getConnectionsPerHost()).maxConnectionIdleTime(options.maxConnectionIdleTime, TimeUnit.MILLISECONDS).maxConnectionLifeTime(options.maxConnectionLifeTime, TimeUnit.MILLISECONDS).maxWaitQueueSize(options.getConnectionsPerHost() * options.getThreadsAllowedToBlockForConnectionMultiplier()).maxWaitTime(options.getMaxWaitTime(), TimeUnit.MILLISECONDS).build();
        return new DefaultServer(serverAddress, this.settings, new PooledConnectionProvider(this.clusterId, serverAddress, new DBPortFactory(options), connectionPoolSettings, new JMXConnectionPoolListener(this.mongo.getMongoOptions().getDescription())), this.scheduledExecutorService, this.mongo);
    }

    public void close() {
        this.scheduledExecutorService.shutdownNow();
    }
}

