/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PagedMutable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;

public abstract class GeoPointCompressedAtomicFieldData
extends AtomicGeoPointFieldData<ScriptDocValues> {
    private final int numDocs;
    protected long size = -1L;

    public GeoPointCompressedAtomicFieldData(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.GeoPoints(this.getGeoPointValues());
    }

    public static class Single
    extends GeoPointCompressedAtomicFieldData {
        private final GeoPointFieldMapper.Encoding encoding;
        private final PagedMutable lon;
        private final PagedMutable lat;
        private final long numOrds;

        public Single(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, int numDocs, long numOrds) {
            super(numDocs);
            this.encoding = encoding;
            this.lon = lon;
            this.lat = lat;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + (this.lon.ramBytesUsed() + this.lat.ramBytesUsed());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingle(this.encoding, this.lon, this.lat);
        }

        static class GeoPointValuesSingle
        extends GeoPointValues {
            private final GeoPointFieldMapper.Encoding encoding;
            private final PagedMutable lon;
            private final PagedMutable lat;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingle(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat) {
                super(false);
                this.encoding = encoding;
                this.lon = lon;
                this.lat = lat;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public GeoPoint nextValue() {
                return this.encoding.decode(this.lat.get(this.docId), this.lon.get(this.docId), this.scratch);
            }
        }
    }

    public static class SingleFixedSet
    extends GeoPointCompressedAtomicFieldData {
        private final GeoPointFieldMapper.Encoding encoding;
        private final PagedMutable lon;
        private final PagedMutable lat;
        private final FixedBitSet set;
        private final long numOrds;

        public SingleFixedSet(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, int numDocs, FixedBitSet set, long numOrds) {
            super(numDocs);
            this.encoding = encoding;
            this.lon = lon;
            this.lat = lat;
            this.set = set;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed() + RamUsageEstimator.sizeOf((long[])this.set.getBits());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingleFixedSet(this.encoding, this.lon, this.lat, this.set);
        }

        static class GeoPointValuesSingleFixedSet
        extends GeoPointValues {
            private final GeoPointFieldMapper.Encoding encoding;
            private final PagedMutable lat;
            private final PagedMutable lon;
            private final FixedBitSet set;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingleFixedSet(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, FixedBitSet set) {
                super(false);
                this.encoding = encoding;
                this.lon = lon;
                this.lat = lat;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public GeoPoint nextValue() {
                return this.encoding.decode(this.lat.get(this.docId), this.lon.get(this.docId), this.scratch);
            }
        }
    }

    static class WithOrdinals
    extends GeoPointCompressedAtomicFieldData {
        private final GeoPointFieldMapper.Encoding encoding;
        private final PagedMutable lon;
        private final PagedMutable lat;
        private final Ordinals ordinals;

        public WithOrdinals(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, int numDocs, Ordinals ordinals) {
            super(numDocs);
            this.encoding = encoding;
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesWithOrdinals(this.encoding, this.lon, this.lat, this.ordinals.ordinals());
        }

        public static class GeoPointValuesWithOrdinals
        extends GeoPointValues {
            private final GeoPointFieldMapper.Encoding encoding;
            private final PagedMutable lon;
            private final PagedMutable lat;
            private final Ordinals.Docs ordinals;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesWithOrdinals(GeoPointFieldMapper.Encoding encoding, PagedMutable lon, PagedMutable lat, Ordinals.Docs ordinals) {
                super(ordinals.isMultiValued());
                this.encoding = encoding;
                this.lon = lon;
                this.lat = lat;
                this.ordinals = ordinals;
            }

            @Override
            public GeoPoint nextValue() {
                long ord = this.ordinals.nextOrd();
                assert (ord > 0L);
                return this.encoding.decode(this.lat.get(ord), this.lon.get(ord), this.scratch);
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.ordinals.setDocument(docId);
            }
        }
    }
}

