/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.facet.Facets;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.transport.TransportResponse;

public class QuerySearchResult
extends TransportResponse
implements QuerySearchResultProvider {
    private long id;
    private SearchShardTarget shardTarget;
    private int from;
    private int size;
    private TopDocs topDocs;
    private InternalFacets facets;
    private InternalAggregations aggregations;
    private Suggest suggest;
    private boolean searchTimedOut;

    public QuerySearchResult() {
    }

    public QuerySearchResult(long id, SearchShardTarget shardTarget) {
        this.id = id;
        this.shardTarget = shardTarget;
    }

    @Override
    public boolean includeFetch() {
        return false;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public TopDocs topDocs() {
        return this.topDocs;
    }

    public void topDocs(TopDocs topDocs) {
        this.topDocs = topDocs;
    }

    public Facets facets() {
        return this.facets;
    }

    public void facets(InternalFacets facets) {
        this.facets = facets;
    }

    public Aggregations aggregations() {
        return this.aggregations;
    }

    public void aggregations(InternalAggregations aggregations) {
        this.aggregations = aggregations;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public static QuerySearchResult readQuerySearchResult(StreamInput in) throws IOException {
        QuerySearchResult result = new QuerySearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        if (in.readBoolean()) {
            this.facets = InternalFacets.readFacets(in);
        }
        if (in.readBoolean()) {
            this.aggregations = InternalAggregations.readAggregations(in);
        }
        if (in.readBoolean()) {
            this.suggest = Suggest.readSuggest(Suggest.Fields.SUGGEST, in);
        }
        this.searchTimedOut = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs, 0);
        if (this.facets == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.facets.writeTo(out);
        }
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
    }
}

