/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.vh;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

public class VirtualHostHelper {
    private static final int HTTP_PORT_NUMBER = 80;
    private static final int HTTPS_PORT_NUMBER = 443;
    private static final Log log = LogFactory.getLog(VirtualHostHelper.class);
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_PORT = "x-forwarded-port";
    private static final String VH_HEADER = "nuxeo-virtual-host";

    private VirtualHostHelper() {
    }

    private static HttpServletRequest getHttpServletRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        return null;
    }

    public static String getWebAppName(ServletRequest request) {
        return VirtualHostHelper.getContextPath(request).replace("/", "");
    }

    public static String getServerURL(ServletRequest request) {
        return VirtualHostHelper.getServerURL(request, false);
    }

    private static String getServerUrl(String scheme, String serverName, int serverPort) {
        StringBuilder sbaseURL = new StringBuilder();
        sbaseURL.append(scheme);
        sbaseURL.append("://");
        sbaseURL.append(serverName);
        if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
            sbaseURL.append(':');
            sbaseURL.append(serverPort);
        }
        sbaseURL.append('/');
        return sbaseURL.toString();
    }

    public static String getServerURL(ServletRequest request, boolean local) {
        String baseURL = null;
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        if (httpRequest != null) {
            String nuxeoVH = httpRequest.getHeader(VH_HEADER);
            if (!local && nuxeoVH != null && nuxeoVH.contains("http")) {
                baseURL = nuxeoVH;
            } else {
                String serverName = httpRequest.getServerName();
                int serverPort = httpRequest.getServerPort();
                String scheme = httpRequest.getScheme();
                if (!local) {
                    String forwardedHost;
                    String forwardedProto;
                    String forwardedPort = httpRequest.getHeader(X_FORWARDED_PORT);
                    if (forwardedPort != null) {
                        try {
                            serverPort = Integer.parseInt(forwardedPort);
                        }
                        catch (NumberFormatException e) {
                            log.error((Object)"Unable to get forwarded port from header", (Throwable)e);
                        }
                    }
                    if ((forwardedProto = httpRequest.getHeader(X_FORWARDED_PROTO)) != null) {
                        scheme = forwardedProto;
                    }
                    if ((forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST)) != null) {
                        if (forwardedHost.contains(":")) {
                            serverName = forwardedHost.split(":")[0];
                            serverPort = Integer.valueOf(forwardedHost.split(":")[1]);
                        } else {
                            serverName = forwardedHost;
                            serverPort = "https".equals(scheme) ? 443 : 80;
                        }
                    }
                }
                baseURL = VirtualHostHelper.getServerUrl(scheme, serverName, serverPort);
            }
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
            log.debug((Object)"Could not retrieve base url correctly", new Throwable());
        }
        return baseURL;
    }

    public static String getBaseURL(ServletRequest request) {
        String baseURL = null;
        String serverUrl = VirtualHostHelper.getServerURL(request, false);
        if (serverUrl != null) {
            String webAppName = VirtualHostHelper.getWebAppName(request);
            baseURL = StringUtils.isNotBlank((String)webAppName) ? serverUrl + webAppName + '/' : serverUrl;
        }
        return baseURL;
    }

    public static String getContextPath(ServletRequest request) {
        HttpServletRequest httpRequest = VirtualHostHelper.getHttpServletRequest(request);
        String contextPath = null;
        if (httpRequest != null) {
            contextPath = httpRequest.getContextPath();
        }
        return contextPath != null ? contextPath : VirtualHostHelper.getContextPathProperty();
    }

    public static String getContextPathProperty() {
        return Framework.getProperty((String)"org.nuxeo.ecm.contextPath", (String)"/nuxeo");
    }
}

