/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheEntry;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheHolder;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;

public class ConversionCacheGCManager {
    public static final String MAX_DISK_SPACE_USAGE_KEY = "MaxDiskSpaceUsageForCache";
    public static final long MAX_DISK_SPACE_USAGE_KB = 1000L;
    private static final Log log = LogFactory.getLog(ConversionCacheGCManager.class);
    private static int gcRuns = 0;
    private static int gcCalls = 0;

    private ConversionCacheGCManager() {
    }

    protected static int getMaxDiskSpaceUsageKB() {
        return ConversionServiceImpl.getMaxCacheSizeInKB();
    }

    public static int getGCRuns() {
        return gcRuns;
    }

    public static int getGCCalls() {
        return gcCalls;
    }

    public static long getCacheSizeInKB() {
        long totalSize = 0L;
        Set<String> cacheKeys = ConversionCacheHolder.getCacheKeys();
        for (String key : cacheKeys) {
            ConversionCacheEntry cacheEntry = ConversionCacheHolder.getCacheEntry(key);
            if (cacheEntry == null) continue;
            totalSize += cacheEntry.getDiskSpaceUsageInKB();
        }
        return totalSize;
    }

    public static boolean gcIfNeeded() {
        log.debug((Object)"GC Thread awake, see if there is some work to be done");
        long totalSize = ConversionCacheGCManager.getCacheSizeInKB();
        long limit = ConversionCacheGCManager.getMaxDiskSpaceUsageKB();
        if (totalSize < limit) {
            ++gcCalls;
            log.debug((Object)"No GC needed, go back to sleep for now");
            return false;
        }
        long deltaInKB = totalSize - limit;
        if (limit < 0L) {
            deltaInKB = totalSize;
        }
        log.debug((Object)("GC needed to free " + deltaInKB + " KB of data"));
        ConversionCacheGCManager.doGC(deltaInKB);
        log.debug((Object)"GC terminated");
        ++gcCalls;
        return true;
    }

    public static void doGC(long deltaInKB) {
        Set<String> cacheKeys = ConversionCacheHolder.getCacheKeys();
        HashMap<Date, String> sortingMap = new HashMap<Date, String>();
        for (String key : cacheKeys) {
            ConversionCacheEntry cacheEntry = ConversionCacheHolder.getCacheEntry(key);
            if (key == null) continue;
            sortingMap.put(cacheEntry.getLastAccessedTime(), key);
        }
        ArrayList accessTimeList = new ArrayList();
        accessTimeList.addAll(sortingMap.keySet());
        Collections.sort(accessTimeList);
        long deletedVolume = 0L;
        for (Date accessDate : accessTimeList) {
            ConversionCacheEntry cacheEntry = ConversionCacheHolder.getCacheEntry((String)sortingMap.get(accessDate));
            long deletePotential = cacheEntry.getDiskSpaceUsageInKB();
            ConversionCacheHolder.removeFromCache((String)sortingMap.get(accessDate));
            if ((deletedVolume += deletePotential) <= deltaInKB) continue;
            break;
        }
        ++gcRuns;
    }
}

