/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resolver;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamResolver;
import com.phloc.commons.io.IOutputStreamResolver;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileSystemStreamResolver
implements IInputStreamResolver,
IOutputStreamResolver {
    private final File m_aBasePath;

    public FileSystemStreamResolver(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemStreamResolver(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("basePath");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Base path does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Only directories are allowed as base path: " + file);
        }
        this.m_aBasePath = file;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String string) {
        return FileUtils.getInputStream(new File(this.m_aBasePath, string));
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileUtils.getOutputStream(new File(this.m_aBasePath, string), eAppend);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FileSystemStreamResolver)) {
            return false;
        }
        FileSystemStreamResolver fileSystemStreamResolver = (FileSystemStreamResolver)object;
        return this.m_aBasePath.equals(fileSystemStreamResolver.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).toString();
    }
}

