/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.QueryOptimizer;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.dbs.DBSDocument;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSTransactionState;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DBSSession
implements Session {
    private static final Log log = LogFactory.getLog(DBSSession.class);
    protected final DBSRepository repository;
    protected final String sessionId;
    protected final DBSTransactionState transaction;
    protected boolean closed;
    protected static final Pattern dotDigitsPattern = Pattern.compile("(.*)\\.[0-9]+$");
    private static final Comparator<DBSDocumentState> VERSION_CREATED_COMPARATOR = new Comparator<DBSDocumentState>(){

        @Override
        public int compare(DBSDocumentState s1, DBSDocumentState s2) {
            Calendar c1 = (Calendar)s1.get("ecm:versionCreated");
            Calendar c2 = (Calendar)s2.get("ecm:versionCreated");
            if (c1 == null && c2 == null) {
                return s1.hashCode() - s2.hashCode();
            }
            if (c1 == null) {
                return 1;
            }
            if (c2 == null) {
                return -1;
            }
            return c1.compareTo(c2);
        }
    };
    private static final Comparator<DBSDocumentState> POS_COMPARATOR = new Comparator<DBSDocumentState>(){

        @Override
        public int compare(DBSDocumentState s1, DBSDocumentState s2) {
            Long p1 = (Long)s1.get("ecm:pos");
            Long p2 = (Long)s2.get("ecm:pos");
            if (p1 == null && p2 == null) {
                return s1.hashCode() - s2.hashCode();
            }
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            return p1.compareTo(p2);
        }
    };

    public DBSSession(DBSRepository repository, String sessionId) {
        this.repository = repository;
        this.sessionId = sessionId;
        this.transaction = new DBSTransactionState(repository, this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    public void close() {
        this.closed = true;
    }

    public boolean isLive() {
        return !this.closed;
    }

    public void save() throws DocumentException {
        this.transaction.save();
        if (!TransactionHelper.isTransactionActive()) {
            this.transaction.commit();
        }
    }

    public void commit() throws DocumentException {
        this.transaction.commit();
    }

    public boolean isStateSharedByAllThreadSessions() {
        return false;
    }

    protected BinaryManager getBinaryManager() {
        return this.repository.getBinaryManager();
    }

    protected String getRootId() {
        return this.repository.getRootId();
    }

    protected String normalize(String path) {
        return Normalizer.normalize(path, Normalizer.Form.NFC);
    }

    public Document resolvePath(String path) throws DocumentException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        int len = path.length();
        if (len == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Relative path: " + path);
        }
        if (len > 1 && path.charAt(len - 1) == '/') {
            path = path.substring(0, len - 1);
            --len;
        }
        path = this.normalize(path);
        if (len == 1) {
            return this.getRootDocument();
        }
        DBSDocumentState docState = null;
        String parentId = this.getRootId();
        String[] names = path.split("/", -1);
        for (int i = 1; i < names.length; ++i) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Path with empty component: " + path);
            }
            docState = this.transaction.getChildState(parentId, name);
            if (docState == null) {
                throw new NoSuchDocumentException(path);
            }
            parentId = docState.getId();
        }
        return this.getDocument(docState);
    }

    protected String getDocumentIdByPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        int len = path.length();
        if (len == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Relative path: " + path);
        }
        if (len > 1 && path.charAt(len - 1) == '/') {
            path = path.substring(0, len - 1);
            --len;
        }
        path = this.normalize(path);
        if (len == 1) {
            return this.getRootId();
        }
        DBSDocumentState docState = null;
        String parentId = this.getRootId();
        String[] names = path.split("/", -1);
        for (int i = 1; i < names.length; ++i) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Path with empty component: " + path);
            }
            docState = this.transaction.getChildState(parentId, name);
            if (docState == null) {
                return null;
            }
            parentId = docState.getId();
        }
        return docState.getId();
    }

    protected Document getChild(String parentId, String name) throws DocumentException {
        DBSDocumentState docState = this.transaction.getChildState(parentId, name);
        return this.getDocument(docState);
    }

    protected Iterator<Document> getChildren(String parentId) throws DocumentException {
        List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId);
        if (this.isOrderable(parentId)) {
            Collections.sort(docStates, POS_COMPARATOR);
        }
        ArrayList<Document> children = new ArrayList<Document>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            try {
                children.add(this.getDocument(docState));
            }
            catch (DocumentException e) {}
        }
        return new DBSDocumentListIterator(children);
    }

    protected List<String> getChildrenIds(String parentId) {
        if (this.isOrderable(parentId)) {
            List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId);
            Collections.sort(docStates, POS_COMPARATOR);
            ArrayList<String> children = new ArrayList<String>(docStates.size());
            for (DBSDocumentState docState : docStates) {
                children.add(docState.getId());
            }
            return children;
        }
        return this.transaction.getChildrenIds(parentId);
    }

    protected boolean hasChildren(String parentId) {
        return this.transaction.hasChildren(parentId);
    }

    public Document getDocumentByUUID(String id) throws DocumentException {
        Document doc = this.getDocument(id);
        if (doc != null) {
            return doc;
        }
        throw new NoSuchDocumentException(id);
    }

    public Document getRootDocument() throws DocumentException {
        return this.getDocument(this.getRootId());
    }

    public Document getNullDocument() throws DocumentException {
        return new DBSDocument(null, null, this, true);
    }

    protected Document getDocument(String id) throws DocumentException {
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        return this.getDocument(docState);
    }

    protected List<Document> getDocuments(List<String> ids) throws DocumentException {
        List<DBSDocumentState> docStates = this.transaction.getStatesForUpdate(ids);
        ArrayList<Document> docs = new ArrayList<Document>(ids.size());
        for (DBSDocumentState docState : docStates) {
            docs.add(this.getDocument(docState));
        }
        return docs;
    }

    protected Document getDocument(DBSDocumentState docState) throws DocumentException {
        return this.getDocument(docState, true);
    }

    protected Document getDocument(DBSDocumentState docState, boolean readonly) throws DocumentException {
        if (docState == null) {
            return null;
        }
        boolean isVersion = Boolean.TRUE.equals(docState.get("ecm:isVersion"));
        String typeName = docState.getPrimaryType();
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DocumentType type = schemaManager.getDocumentType(typeName);
        if (type == null) {
            throw new DocumentException("Unknown document type: " + typeName);
        }
        if (isVersion) {
            return new DBSDocument(docState, type, this, readonly);
        }
        return new DBSDocument(docState, type, this, false);
    }

    protected boolean hasChild(String parentId, String name) {
        return this.transaction.hasChild(parentId, this.normalize(name));
    }

    public Document createChild(String id, String parentId, String name, Long pos, String typeName) throws DocumentException {
        DBSDocumentState docState = this.createChildState(id, parentId, name, pos, typeName);
        return this.getDocument(docState);
    }

    protected DBSDocumentState createChildState(String id, String parentId, String name, Long pos, String typeName) throws DocumentException {
        if (pos == null && parentId != null) {
            pos = this.getNextPos(parentId);
        }
        return this.transaction.createChild(id, parentId, name, pos, typeName);
    }

    protected boolean isOrderable(String id) {
        State state = this.transaction.getStateForRead(id);
        String typeName = (String)((Object)state.get((Object)"ecm:primaryType"));
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        return schemaManager.getDocumentType(typeName).getFacets().contains("Orderable");
    }

    protected Long getNextPos(String parentId) {
        if (!this.isOrderable(parentId)) {
            return null;
        }
        long max = -1L;
        for (DBSDocumentState docState : this.transaction.getChildrenStates(parentId)) {
            Long pos = (Long)docState.get("ecm:pos");
            if (pos == null || pos <= max) continue;
            max = pos;
        }
        return max + 1L;
    }

    protected void orderBefore(String parentId, String sourceId, String destId) throws DocumentException {
        Long setPos;
        if (!this.isOrderable(parentId)) {
            return;
        }
        if (sourceId.equals(destId)) {
            return;
        }
        List<DBSDocumentState> docStates = this.transaction.getChildrenStates(parentId);
        Collections.sort(docStates, POS_COMPARATOR);
        int i = 0;
        DBSDocumentState source = null;
        Long destPos = null;
        for (DBSDocumentState docState : docStates) {
            Long setPos2;
            String id = docState.getId();
            if (id.equals(destId)) {
                destPos = i;
                ++i;
                if (source != null) {
                    source.put("ecm:pos", destPos);
                }
            }
            if (id.equals(sourceId)) {
                --i;
                source = docState;
                setPos2 = destPos;
            } else {
                setPos2 = i;
            }
            if (setPos2 != null && !setPos2.equals(docState.get("ecm:pos"))) {
                docState.put("ecm:pos", setPos2);
            }
            ++i;
        }
        if (destId == null && !(setPos = Long.valueOf(i)).equals(source.get("ecm:pos"))) {
            source.put("ecm:pos", setPos);
        }
    }

    protected void checkOut(String id) throws DocumentException {
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        if (!Boolean.TRUE.equals(docState.get("ecm:isCheckedIn"))) {
            throw new DocumentException("Already checked out");
        }
        docState.put("ecm:isCheckedIn", null);
    }

    protected Document checkIn(String id, String label, String checkinComment) throws DocumentException {
        this.transaction.save();
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        if (Boolean.TRUE.equals(docState.get("ecm:isCheckedIn"))) {
            throw new DocumentException("Already checked in");
        }
        if (label == null) {
            Long major = (Long)docState.get("ecm:majorVersion");
            Long minor = (Long)docState.get("ecm:minorVersion");
            label = major == null || minor == null ? "" : major + "." + minor;
        }
        DBSDocumentState verState = this.transaction.copy(id);
        String verId = verState.getId();
        verState.put("ecm:parentId", null);
        verState.put("ecm:ancestorIds", null);
        verState.put("ecm:isVersion", Boolean.TRUE);
        verState.put("ecm:versionSeriesId", (Serializable)((Object)id));
        verState.put("ecm:versionCreated", new GregorianCalendar());
        verState.put("ecm:versionLabel", (Serializable)((Object)label));
        verState.put("ecm:versionDescription", (Serializable)((Object)checkinComment));
        verState.put("ecm:isLatestVersion", Boolean.TRUE);
        verState.put("ecm:isCheckedIn", null);
        verState.put("ecm:baseVersionId", null);
        boolean isMajor = Long.valueOf(0L).equals(verState.get("ecm:minorVersion"));
        verState.put("ecm:isLatestMajorVersion", isMajor ? Boolean.TRUE : null);
        docState.put("ecm:isCheckedIn", Boolean.TRUE);
        docState.put("ecm:baseVersionId", (Serializable)((Object)verId));
        this.recomputeVersionSeries(id);
        this.transaction.save();
        return this.getDocument(verId);
    }

    protected void recomputeVersionSeries(String versionSeriesId) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId);
        Collections.sort(docStates, VERSION_CREATED_COMPARATOR);
        Collections.reverse(docStates);
        boolean isLatest = true;
        boolean isLatestMajor = true;
        for (DBSDocumentState docState : docStates) {
            docState.put("ecm:isLatestVersion", isLatest ? Boolean.TRUE : null);
            isLatest = false;
            boolean isMajor = Long.valueOf(0L).equals(docState.get("ecm:minorVersion"));
            docState.put("ecm:isLatestMajorVersion", isMajor && isLatestMajor ? Boolean.TRUE : null);
            if (!isMajor) continue;
            isLatestMajor = false;
        }
    }

    protected void restoreVersion(Document doc, Document version) {
        String docId = doc.getUUID();
        String versionId = version.getUUID();
        DBSDocumentState docState = this.transaction.getStateForUpdate(docId);
        State versionState = this.transaction.getStateForRead(versionId);
        for (Map.Entry en : versionState.entrySet()) {
            String key = (String)en.getKey();
            if (this.keepWhenRestore(key)) continue;
            docState.put(key, StateHelper.deepCopy(en.getValue()));
        }
        docState.put("ecm:isVersion", null);
        docState.put("ecm:isCheckedIn", Boolean.TRUE);
        docState.put("ecm:baseVersionId", (Serializable)((Object)versionId));
    }

    protected boolean keepWhenRestore(String key) {
        switch (key) {
            case "ecm:id": 
            case "ecm:parentId": 
            case "ecm:ancestorIds": 
            case "ecm:name": 
            case "ecm:pos": 
            case "ecm:primaryType": 
            case "ecm:acp": 
            case "ecm:racl": 
            case "ecm:versionCreated": 
            case "ecm:versionDescription": 
            case "ecm:versionLabel": 
            case "ecm:versionSeriesId": 
            case "ecm:isLatestVersion": 
            case "ecm:isLatestMajorVersion": 
            case "ecm:isVersion": 
            case "ecm:isCheckedIn": 
            case "ecm:baseVersionId": {
                return true;
            }
        }
        return false;
    }

    public Document copy(Document source, Document parent, String name) throws DocumentException {
        this.transaction.save();
        if (name == null) {
            name = source.getName();
        }
        name = this.findFreeName(parent, name);
        String sourceId = source.getUUID();
        String parentId = parent.getUUID();
        State sourceState = this.transaction.getStateForRead(sourceId);
        State parentState = this.transaction.getStateForRead(parentId);
        String oldParentId = (String)((Object)sourceState.get((Object)"ecm:parentId"));
        Object[] parentAncestorIds = (Object[])parentState.get((Object)"ecm:ancestorIds");
        LinkedList<String> ancestorIds = new LinkedList<String>();
        if (parentAncestorIds != null) {
            for (Object id : parentAncestorIds) {
                ancestorIds.add((String)id);
            }
        }
        ancestorIds.add(parentId);
        if (oldParentId != null && !oldParentId.equals(parentId) && ancestorIds.contains(sourceId)) {
            throw new DocumentException("Cannot copy a node under itself: " + parentId + " is under " + sourceId);
        }
        Long pos = this.getNextPos(parentId);
        String copyId = this.copyRecurse(sourceId, parentId, ancestorIds, name);
        DBSDocumentState copyState = this.transaction.getStateForUpdate(copyId);
        if (source.isVersion()) {
            copyState.put("ecm:isVersion", null);
        }
        copyState.put("ecm:pos", pos);
        this.transaction.updateReadAcls(copyId);
        return this.getDocument(copyState);
    }

    protected String copyRecurse(String sourceId, String parentId, LinkedList<String> ancestorIds, String name) {
        String copyId = this.copy(sourceId, parentId, ancestorIds, name);
        ancestorIds.addLast(copyId);
        for (String childId : this.getChildrenIds(sourceId)) {
            this.copyRecurse(childId, copyId, ancestorIds, null);
        }
        ancestorIds.removeLast();
        return copyId;
    }

    protected String copy(String sourceId, String parentId, List<String> ancestorIds, String name) {
        DBSDocumentState copy = this.transaction.copy(sourceId);
        copy.put("ecm:parentId", (Serializable)((Object)parentId));
        copy.put("ecm:ancestorIds", (Serializable)ancestorIds.toArray(new Object[ancestorIds.size()]));
        if (name != null) {
            copy.put("ecm:name", (Serializable)((Object)name));
        }
        copy.put("ecm:baseVersionId", null);
        copy.put("ecm:isCheckedIn", null);
        return copy.getId();
    }

    protected String findFreeName(Document parent, String name) {
        if (this.hasChild(parent.getUUID(), name)) {
            Matcher m = dotDigitsPattern.matcher(name);
            if (m.matches()) {
                name = m.group(1);
            }
            name = name + "." + System.currentTimeMillis();
        }
        return name;
    }

    protected void checkNotUnder(String parentId, String id, String op) throws DocumentException {
        State state;
        String pid = parentId;
        do {
            if (pid.equals(id)) {
                throw new DocumentException("Cannot " + op + " a node under itself: " + parentId + " is under " + id);
            }
            state = this.transaction.getStateForRead(pid);
            if (state != null) continue;
            throw new DocumentException("No parent: " + pid);
        } while ((pid = (String)((Object)state.get((Object)"ecm:parentId"))) != null);
    }

    public Document move(Document source, Document parent, String name) throws DocumentException {
        String oldName = source.getName();
        if (name == null) {
            name = oldName;
        }
        String sourceId = source.getUUID();
        String parentId = parent.getUUID();
        DBSDocumentState sourceState = this.transaction.getStateForUpdate(sourceId);
        String oldParentId = (String)((Object)sourceState.get("ecm:parentId"));
        if (ObjectUtils.equals((Object)oldParentId, (Object)parentId)) {
            if (!oldName.equals(name)) {
                if (this.hasChild(parentId, name)) {
                    throw new DocumentException("Destination name already exists: " + name);
                }
                sourceState.put("ecm:name", (Serializable)((Object)name));
            }
            return source;
        }
        this.transaction.save();
        if (this.hasChild(parentId, name)) {
            throw new DocumentException("Destination name already exists: " + name);
        }
        State parentState = this.transaction.getStateForRead(parentId);
        Object[] parentAncestorIds = (Object[])parentState.get((Object)"ecm:ancestorIds");
        ArrayList<String> ancestorIdsList = new ArrayList<String>();
        if (parentAncestorIds != null) {
            for (Object id : parentAncestorIds) {
                ancestorIdsList.add((String)id);
            }
        }
        ancestorIdsList.add(parentId);
        Object[] ancestorIds = ancestorIdsList.toArray(new Object[ancestorIdsList.size()]);
        if (ancestorIdsList.contains(sourceId)) {
            throw new DocumentException("Cannot move a node under itself: " + parentId + " is under " + sourceId);
        }
        sourceState.put("ecm:name", (Serializable)((Object)name));
        sourceState.put("ecm:parentId", (Serializable)((Object)parentId));
        Object[] oldAncestorIds = (Object[])sourceState.get("ecm:ancestorIds");
        int ndel = oldAncestorIds == null ? 0 : oldAncestorIds.length;
        this.transaction.updateAncestors(sourceId, ndel, ancestorIds);
        this.transaction.updateReadAcls(sourceId);
        return source;
    }

    protected void remove(String id) throws DocumentException {
        Object[] proxyIds;
        this.transaction.save();
        State state = this.transaction.getStateForRead(id);
        String versionSeriesId = Boolean.TRUE.equals(state.get((Object)"ecm:isVersion")) ? (String)((Object)state.get((Object)"ecm:versionSeriesId")) : null;
        HashMap<String, String> proxyTargets = new HashMap<String, String>();
        HashMap<String, Object[]> targetProxies = new HashMap<String, Object[]>();
        Set<String> removedIds = this.transaction.getSubTree(id, proxyTargets, targetProxies);
        removedIds.add(id);
        if (Boolean.TRUE.equals(state.get((Object)"ecm:isProxy"))) {
            String targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
            proxyTargets.put(id, targetId);
        }
        if ((proxyIds = (Object[])state.get((Object)"ecm:proxyIds")) != null) {
            targetProxies.put(id, proxyIds);
        }
        for (Map.Entry en : targetProxies.entrySet()) {
            String targetId = (String)en.getKey();
            if (!removedIds.contains(targetId)) continue;
            for (Object proxyId : (Object[])en.getValue()) {
                if (removedIds.contains(proxyId)) continue;
                throw new DocumentException("Cannot remove " + id + ", subdocument " + targetId + " is the target of proxy " + proxyId);
            }
        }
        this.transaction.removeStates(removedIds);
        HashSet targetIds = new HashSet(proxyTargets.values());
        for (String targetId : targetIds) {
            if (removedIds.contains(targetId)) continue;
            DBSDocumentState target = this.transaction.getStateForUpdate(targetId);
            this.removeBackProxyIds(target, removedIds);
        }
        if (versionSeriesId != null) {
            this.recomputeVersionSeries(versionSeriesId);
        }
    }

    public Document createProxy(Document doc, Document folder) throws DocumentException {
        String versionSeriesId;
        String targetId;
        if (doc == null) {
            throw new NullPointerException();
        }
        String id = doc.getUUID();
        if (doc.isVersion()) {
            targetId = id;
            versionSeriesId = doc.getVersionSeriesId();
        } else if (doc.isProxy()) {
            State state = this.transaction.getStateForRead(id);
            targetId = (String)((Object)state.get((Object)"ecm:proxyTargetId"));
            versionSeriesId = (String)((Object)state.get((Object)"ecm:proxyVersionSeriesId"));
        } else {
            versionSeriesId = targetId = id;
        }
        String parentId = folder.getUUID();
        String name = this.findFreeName(folder, doc.getName());
        Long pos = parentId == null ? null : this.getNextPos(parentId);
        DBSDocumentState docState = this.addProxyState(null, parentId, name, pos, targetId, versionSeriesId);
        return this.getDocument(docState);
    }

    protected DBSDocumentState addProxyState(String id, String parentId, String name, Long pos, String targetId, String versionSeriesId) throws DocumentException {
        DBSDocumentState target = this.transaction.getStateForUpdate(targetId);
        String typeName = (String)((Object)target.get("ecm:primaryType"));
        DBSDocumentState proxy = this.transaction.createChild(id, parentId, name, pos, typeName);
        String proxyId = proxy.getId();
        proxy.put("ecm:isProxy", Boolean.TRUE);
        proxy.put("ecm:proxyTargetId", (Serializable)((Object)targetId));
        proxy.put("ecm:proxyVersionSeriesId", (Serializable)((Object)versionSeriesId));
        proxy.put("ecm:isVersion", null);
        proxy.put("ecm:baseVersionId", null);
        proxy.put("ecm:isVersion", null);
        proxy.put("ecm:isLatestVersion", null);
        proxy.put("ecm:isLatestMajorVersion", null);
        proxy.put("ecm:versionCreated", null);
        proxy.put("ecm:versionLabel", null);
        proxy.put("ecm:versionDescription", null);
        proxy.put("ecm:versionSeriesId", null);
        this.transaction.updateProxy(target, proxyId);
        this.addBackProxyId(target, proxyId);
        return this.transaction.getStateForUpdate(proxyId);
    }

    protected void addBackProxyId(DBSDocumentState docState, String id) {
        Object[] newProxyIds;
        Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
        if (proxyIds == null) {
            newProxyIds = new Object[]{id};
        } else {
            newProxyIds = new Object[proxyIds.length + 1];
            System.arraycopy(proxyIds, 0, newProxyIds, 0, proxyIds.length);
            newProxyIds[proxyIds.length] = id;
        }
        docState.put("ecm:proxyIds", (Serializable)newProxyIds);
    }

    protected void removeBackProxyId(DBSDocumentState docState, String id) {
        this.removeBackProxyIds(docState, Collections.singleton(id));
    }

    protected void removeBackProxyIds(DBSDocumentState docState, Set<String> ids) {
        Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
        if (proxyIds == null) {
            return;
        }
        ArrayList<Object> keepIds = new ArrayList<Object>(proxyIds.length);
        for (Object pid : proxyIds) {
            if (ids.contains(pid)) continue;
            keepIds.add(pid);
        }
        Object[] newProxyIds = keepIds.isEmpty() ? null : keepIds.toArray(new Object[keepIds.size()]);
        docState.put("ecm:proxyIds", (Serializable)newProxyIds);
    }

    public Collection<Document> getProxies(Document doc, Document folder) throws DocumentException {
        List<DBSDocumentState> docStates;
        String docId = doc.getUUID();
        if (doc.isVersion()) {
            docStates = this.transaction.getKeyValuedStates("ecm:proxyTargetId", docId);
        } else {
            String versionSeriesId;
            if (doc.isProxy()) {
                State state = this.transaction.getStateForRead(docId);
                versionSeriesId = (String)((Object)state.get((Object)"ecm:proxyVersionSeriesId"));
            } else {
                versionSeriesId = docId;
            }
            docStates = this.transaction.getKeyValuedStates("ecm:proxyVersionSeriesId", versionSeriesId);
        }
        String parentId = folder == null ? null : folder.getUUID();
        ArrayList<Document> documents = new ArrayList<Document>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            if (parentId != null && !parentId.equals(docState.getParentId())) continue;
            documents.add(this.getDocument(docState));
        }
        return documents;
    }

    public void setProxyTarget(Document proxy, Document target) throws DocumentException {
        String proxyId = proxy.getUUID();
        String targetId = target.getUUID();
        DBSDocumentState proxyState = this.transaction.getStateForUpdate(proxyId);
        String oldTargetId = (String)((Object)proxyState.get("ecm:proxyTargetId"));
        DBSDocumentState oldTargetState = this.transaction.getStateForUpdate(oldTargetId);
        this.removeBackProxyId(oldTargetState, proxyId);
        DBSDocumentState targetState = this.transaction.getStateForUpdate(targetId);
        this.addBackProxyId(targetState, proxyId);
        proxyState.put("ecm:proxyTargetId", (Serializable)((Object)targetId));
    }

    public Document importDocument(String id, Document parent, String name, String typeName, Map<String, Serializable> properties) throws DocumentException {
        DBSDocumentState docState;
        String parentId = parent == null ? null : parent.getUUID();
        boolean isProxy = typeName.equals("ecm:proxy");
        HashMap<String, Object> props = new HashMap<String, Object>();
        Long pos = null;
        if (isProxy) {
            String targetId = (String)((Object)properties.get("ecm:proxyTargetId"));
            if (targetId == null) {
                throw new DocumentException("Cannot import proxy " + id + " with null target");
            }
            State targetState = this.transaction.getStateForRead(targetId);
            if (targetState == null) {
                throw new DocumentException("Cannot import proxy " + id + " with missing target " + targetId);
            }
            String versionSeriesId = (String)((Object)properties.get("ecm:proxyVersionableId"));
            docState = this.addProxyState(id, parentId, name, pos, targetId, versionSeriesId);
        } else {
            Serializable importLockCreatedProp;
            Serializable importLockOwnerProp;
            String[] values;
            props.put("ecm:lifeCyclePolicy", properties.get("ecm:lifeCyclePolicy"));
            props.put("ecm:lifeCycleState", properties.get("ecm:lifeCycleState"));
            String key = (String)((Object)properties.get("ecm:lock"));
            if (key != null && (values = key.split(":")).length == 2) {
                String owner = values[0];
                GregorianCalendar created = new GregorianCalendar();
                try {
                    created.setTimeInMillis(DateFormat.getDateInstance(2).parse(values[1]).getTime());
                }
                catch (ParseException e) {
                    // empty catch block
                }
                props.put("ecm:lockOwner", owner);
                props.put("ecm:lockCreated", created);
            }
            if ((importLockOwnerProp = properties.get("ecm:lockOwner")) != null) {
                props.put("ecm:lockOwner", importLockOwnerProp);
            }
            if ((importLockCreatedProp = properties.get("ecm:lockCreated")) != null) {
                props.put("ecm:lockCreated", importLockCreatedProp);
            }
            props.put("ecm:majorVersion", properties.get("ecm:majorVersion"));
            props.put("ecm:minorVersion", properties.get("ecm:minorVersion"));
            Boolean isVersion = DBSSession.trueOrNull(properties.get("ecm:isVersion"));
            props.put("ecm:isVersion", isVersion);
            if (Boolean.TRUE.equals(isVersion)) {
                props.put("ecm:versionSeriesId", properties.get("ecm:versionableId"));
                props.put("ecm:versionCreated", properties.get("ecm:versionCreated"));
                props.put("ecm:versionLabel", properties.get("ecm:versionLabel"));
                props.put("ecm:versionDescription", properties.get("ecm:versionDescription"));
                props.put("ecm:isLatestVersion", DBSSession.trueOrNull(properties.get("ecm:isLatestVersion")));
                props.put("ecm:isLatestMajorVersion", DBSSession.trueOrNull(properties.get("ecm:isLatestMajorVersion")));
            } else {
                props.put("ecm:baseVersionId", properties.get("ecm:baseVersionId"));
                props.put("ecm:isCheckedIn", DBSSession.trueOrNull(properties.get("ecm:isCheckedIn")));
            }
            docState = this.createChildState(id, parentId, name, pos, typeName);
        }
        for (Map.Entry entry : props.entrySet()) {
            docState.put((String)entry.getKey(), (Serializable)entry.getValue());
        }
        return this.getDocument(docState, false);
    }

    protected static Boolean trueOrNull(Object value) {
        return Boolean.TRUE.equals(value) ? Boolean.TRUE : null;
    }

    public Document getVersion(String versionSeriesId, VersionModel versionModel) throws DocumentException {
        DBSDocumentState docState = this.getVersionByLabel(versionSeriesId, versionModel.getLabel());
        if (docState == null) {
            return null;
        }
        versionModel.setDescription((String)((Object)docState.get("ecm:versionDescription")));
        versionModel.setCreated((Calendar)docState.get("ecm:versionCreated"));
        return this.getDocument(docState);
    }

    protected DBSDocumentState getVersionByLabel(String versionSeriesId, String label) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId);
        for (DBSDocumentState docState : docStates) {
            if (!label.equals(docState.get("ecm:versionLabel"))) continue;
            return docState;
        }
        return null;
    }

    protected List<String> getVersionsIds(String versionSeriesId) {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId);
        Collections.sort(docStates, VERSION_CREATED_COMPARATOR);
        ArrayList<String> ids = new ArrayList<String>(docStates.size());
        for (DBSDocumentState docState : docStates) {
            ids.add(docState.getId());
        }
        return ids;
    }

    protected Document getLastVersion(String versionSeriesId) throws DocumentException {
        List<DBSDocumentState> docStates = this.transaction.getKeyValuedStates("ecm:versionSeriesId", versionSeriesId);
        if (docStates.isEmpty()) {
            return null;
        }
        Calendar latest = null;
        DBSDocumentState latestState = null;
        for (DBSDocumentState docState : docStates) {
            Calendar created = (Calendar)docState.get("ecm:versionCreated");
            if (latest != null && created.compareTo(latest) <= 0) continue;
            latest = created;
            latestState = docState;
        }
        return this.getDocument(latestState);
    }

    public boolean isNegativeAclAllowed() {
        return false;
    }

    public ACP getMergedACP(Document doc) throws SecurityException {
        try {
            Document base;
            Document document = base = doc.isVersion() ? doc.getSourceDocument() : doc;
            if (base == null) {
                return null;
            }
            ACP acp = this.getACP(base);
            if (doc.getParent() == null) {
                return acp;
            }
            ACL acl = null;
            if (acp == null || acp.getAccess("Everyone", "Everything") != Access.DENY) {
                acl = this.getInheritedACLs(doc);
            }
            if (acp == null) {
                if (acl == null) {
                    return null;
                }
                acp = new ACPImpl();
            }
            if (acl != null) {
                acp.addACL(acl);
            }
            return acp;
        }
        catch (DocumentException e) {
            throw new SecurityException("Failed to get merged acp", (Throwable)e);
        }
    }

    protected ACL getInheritedACLs(Document doc) throws DocumentException {
        ACL merged = null;
        for (doc = doc.getParent(); doc != null; doc = doc.getParent()) {
            ACP acp = this.getACP(doc);
            if (acp == null) continue;
            ACL acl = acp.getMergedACLs("inherited");
            if (merged == null) {
                merged = acl;
            } else {
                merged.addAll((Collection)acl);
            }
            if (acp.getAccess("Everyone", "Everything") == Access.DENY) break;
        }
        return merged;
    }

    protected ACP getACP(Document doc) throws SecurityException {
        State state = this.transaction.getStateForRead(doc.getUUID());
        return DBSSession.memToAcp(state.get((Object)"ecm:acp"));
    }

    public void setACP(Document doc, ACP acp, boolean overwrite) throws DocumentException {
        this.checkNegativeAcl(acp);
        if (!overwrite) {
            if (acp == null) {
                return;
            }
            acp = DBSSession.updateACP(this.getACP(doc), acp);
        }
        String id = doc.getUUID();
        DBSDocumentState docState = this.transaction.getStateForUpdate(id);
        docState.put("ecm:acp", DBSSession.acpToMem(acp));
        this.transaction.save();
        this.transaction.updateReadAcls(id);
    }

    protected void checkNegativeAcl(ACP acp) {
        if (acp == null) {
            return;
        }
        for (ACL acl : acp.getACLs()) {
            if (acl.getName().equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                String permission;
                if (ace.isGranted() || (permission = ace.getPermission()).equals("Everything") && ace.getUsername().equals("Everyone") || permission.equals("Write")) continue;
                throw new IllegalArgumentException("Negative ACL not allowed: " + ace);
            }
        }
    }

    protected static ACP updateACP(ACP curAcp, ACP addAcp) {
        String name;
        if (curAcp == null) {
            return addAcp;
        }
        ACP newAcp = curAcp.clone();
        HashMap<String, ACL> acls = new HashMap<String, ACL>();
        for (ACL acl : newAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) {
                throw new IllegalStateException(curAcp.toString());
            }
            acls.put(name, acl);
        }
        for (ACL acl : addAcp.getACLs()) {
            name = acl.getName();
            if ("inherited".equals(name)) continue;
            ACL curAcl = (ACL)acls.get(name);
            if (curAcl != null) {
                curAcl.addAll((Collection)acl);
                continue;
            }
            newAcp.addACL(acl);
        }
        return newAcp;
    }

    protected static Serializable acpToMem(ACP acp) {
        if (acp == null) {
            return null;
        }
        ACL[] acls = acp.getACLs();
        if (acls.length == 0) {
            return null;
        }
        ArrayList<State> aclList = new ArrayList<State>(acls.length);
        for (ACL acl : acls) {
            String name = acl.getName();
            if (name.equals("inherited")) continue;
            ACE[] aces = acl.getACEs();
            ArrayList<State> aceList = new ArrayList<State>(aces.length);
            for (ACE ace : aces) {
                State aceMap = new State(3);
                aceMap.put("user", (Serializable)((Object)ace.getUsername()));
                aceMap.put("perm", (Serializable)((Object)ace.getPermission()));
                aceMap.put("grant", (Serializable)Boolean.valueOf(ace.isGranted()));
                aceList.add(aceMap);
            }
            State aclMap = new State(2);
            aclMap.put("name", (Serializable)((Object)name));
            aclMap.put("acl", (Serializable)aceList);
            aclList.add(aclMap);
        }
        return aclList;
    }

    protected static ACP memToAcp(Serializable acpSer) {
        if (acpSer == null) {
            return null;
        }
        List aclList = (List)((Object)acpSer);
        ACPImpl acp = new ACPImpl();
        for (Serializable aclSer : aclList) {
            State aclMap = (State)aclSer;
            String name = (String)((Object)aclMap.get((Object)"name"));
            List aceList = (List)((Object)aclMap.get((Object)"acl"));
            ACLImpl acl = new ACLImpl(name);
            for (Serializable aceSer : aceList) {
                State aceMap = (State)aceSer;
                String username = (String)((Object)aceMap.get((Object)"user"));
                String permission = (String)((Object)aceMap.get((Object)"perm"));
                Boolean granted = (Boolean)aceMap.get((Object)"grant");
                ACE ace = new ACE(username, permission, granted.booleanValue());
                acl.add((Object)ace);
            }
            acp.addACL((ACL)acl);
        }
        return acp;
    }

    public Map<String, String> getBinaryFulltext(String id) throws DocumentException {
        State state = this.transaction.getStateForRead(id);
        String fulltext = (String)((Object)state.get((Object)"ecm:fulltextBinary"));
        return Collections.singletonMap("binarytext", fulltext);
    }

    public DocumentModelList query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws QueryException {
        List<Document> docs;
        PartialList<String> pl = this.doQuery(query, queryType, queryFilter, (int)countUpTo);
        try {
            docs = this.getDocuments(pl.list);
        }
        catch (DocumentException e) {
            throw new QueryException((Throwable)e);
        }
        String[] schemas = new String[]{"common"};
        ArrayList<DocumentModelImpl> list = new ArrayList<DocumentModelImpl>(docs.size());
        for (Document doc : docs) {
            try {
                list.add(DocumentModelFactory.createDocumentModel((Document)doc, (String[])schemas));
            }
            catch (DocumentException e) {
                log.error((Object)("Could not create document model for doc: " + doc), (Throwable)e);
            }
        }
        return new DocumentModelListImpl(list, pl.totalSize);
    }

    protected PartialList<String> doQuery(String query, String queryType, QueryFilter queryFilter, int countUpTo) throws QueryException {
        PartialList<Map<String, Serializable>> pl = this.doQueryAndFetch(query, queryType, queryFilter, countUpTo, true);
        ArrayList<String> ids = new ArrayList<String>(pl.list.size());
        for (Map map : pl.list) {
            String id = (String)map.get("ecm:uuid");
            ids.add(id);
        }
        return new PartialList(ids, pl.totalSize);
    }

    protected PartialList<Map<String, Serializable>> doQueryAndFetch(String query, String queryType, QueryFilter queryFilter, int countUpTo) throws QueryException {
        return this.doQueryAndFetch(query, queryType, queryFilter, countUpTo, false);
    }

    protected PartialList<Map<String, Serializable>> doQueryAndFetch(String query, String queryType, QueryFilter queryFilter, int countUpTo, boolean onlyId) throws QueryException {
        List<Map<String, Serializable>> flatList;
        OrderByClause repoOrderByClause;
        int repoOffset;
        int repoLimit;
        boolean postFilter;
        if ("NXTAG".equals(queryType)) {
            return new PartialList(Collections.emptyList(), 0L);
        }
        if (!"NXQL".equals(queryType)) {
            throw new QueryException("No QueryMaker accepts query type: " + queryType);
        }
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        OrderByClause orderByClause = sqlQuery.orderBy;
        QueryOptimizer optimizer = new QueryOptimizer();
        boolean fulltextScore = optimizer.hasSelectFulltextScore(sqlQuery);
        MultiExpression expression = optimizer.getOptimizedQuery(sqlQuery, queryFilter.getFacetFilter());
        DBSExpressionEvaluator evaluator = new DBSExpressionEvaluator(this, (Expression)expression, queryFilter.getPrincipals());
        int limit = (int)queryFilter.getLimit();
        int offset = (int)queryFilter.getOffset();
        if (offset < 0) {
            offset = 0;
        }
        if (limit < 0) {
            limit = 0;
        }
        if (postFilter = this.isOrderByPath(orderByClause)) {
            repoLimit = 0;
            repoOffset = 0;
            repoOrderByClause = null;
        } else {
            repoLimit = limit;
            repoOffset = offset;
            repoOrderByClause = orderByClause;
        }
        boolean deepCopy = !onlyId;
        PartialList<State> pl = this.repository.queryAndFetch((Expression)expression, evaluator, repoOrderByClause, repoLimit, repoOffset, countUpTo, deepCopy, fulltextScore);
        List states = pl.list;
        long totalSize = pl.totalSize;
        if (totalSize >= 0L && countUpTo != -1) {
            if (countUpTo == 0) {
                totalSize = -1L;
            } else if (totalSize > (long)countUpTo) {
                totalSize = -2L;
            }
        }
        if (postFilter) {
            if (orderByClause != null) {
                this.doOrderBy(states, orderByClause, evaluator);
            }
            if (limit != 0) {
                int size = states.size();
                states.subList(0, offset > size ? size : offset).clear();
                size = states.size();
                if (limit < size) {
                    states.subList(limit, size).clear();
                }
            }
        }
        if (onlyId) {
            flatList = new ArrayList<Map<String, Serializable>>(states.size());
            for (State state : states) {
                flatList.add(Collections.singletonMap("ecm:uuid", state.get((Object)"ecm:id")));
            }
        } else {
            flatList = this.flatten(states);
        }
        return new PartialList(flatList, totalSize);
    }

    protected boolean isOrderByPath(OrderByClause orderByClause) {
        if (orderByClause == null) {
            return false;
        }
        for (OrderByExpr ob : orderByClause.elements) {
            if (!ob.reference.name.equals("ecm:path")) continue;
            return true;
        }
        return false;
    }

    protected String getPath(State state) {
        LinkedList<String> list = new LinkedList<String>();
        boolean first = true;
        while (true) {
            String name = (String)((Object)state.get((Object)"ecm:name"));
            String parentId = (String)((Object)state.get((Object)"ecm:parentId"));
            list.addFirst(name);
            if (parentId == null || (state = this.transaction.getStateForRead(parentId)) == null) {
                if (first) {
                    if ("".equals(name)) {
                        return "/";
                    }
                    return name;
                }
                return StringUtils.join(list, (char)'/');
            }
            first = false;
        }
    }

    protected void doOrderBy(List<State> states, OrderByClause orderByClause, DBSExpressionEvaluator evaluator) {
        if (this.isOrderByPath(orderByClause)) {
            for (State state : states) {
                state.put("ecm:__path", (Serializable)((Object)this.getPath(state)));
            }
        }
        Collections.sort(states, new DBSExpressionEvaluator.OrderByComparator(orderByClause, evaluator));
    }

    protected List<Map<String, Serializable>> flatten(List<State> states) {
        ArrayList<Map<String, Serializable>> flatList = new ArrayList<Map<String, Serializable>>(states.size());
        for (State state : states) {
            flatList.add(this.flatten(state));
        }
        return flatList;
    }

    protected Map<String, Serializable> flatten(State state) {
        HashMap<String, Serializable> flat = new HashMap<String, Serializable>();
        for (Map.Entry en : state.entrySet()) {
            String name;
            String key = (String)en.getKey();
            Serializable value = (Serializable)en.getValue();
            if (key.startsWith("ecm:")) {
                name = DBSSession.convToNXQL(key);
                if (name == null) {
                    continue;
                }
            } else {
                name = key;
            }
            flat.put(name, value);
        }
        return flat;
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object[] params) throws QueryException {
        int countUpTo = -1;
        PartialList<Map<String, Serializable>> pl = this.doQueryAndFetch(query, queryType, queryFilter, countUpTo);
        return new DBSQueryResult(pl);
    }

    public static String convToInternal(String name) {
        switch (name) {
            case "ecm:uuid": {
                return "ecm:id";
            }
            case "ecm:name": {
                return "ecm:name";
            }
            case "ecm:pos": {
                return "ecm:pos";
            }
            case "ecm:parentId": {
                return "ecm:parentId";
            }
            case "ecm:mixinType": {
                return "ecm:mixinTypes";
            }
            case "ecm:primaryType": {
                return "ecm:primaryType";
            }
            case "ecm:isProxy": {
                return "ecm:isProxy";
            }
            case "ecm:isVersion": 
            case "ecm:isCheckedInVersion": {
                return "ecm:isVersion";
            }
            case "ecm:currentLifeCycleState": {
                return "ecm:lifeCycleState";
            }
            case "ecm:lockOwner": {
                return "ecm:lockOwner";
            }
            case "ecm:lockCreated": {
                return "ecm:lockCreated";
            }
            case "ecm:proxyTargetId": {
                return "ecm:proxyTargetId";
            }
            case "ecm:proxyVersionableId": {
                return "ecm:proxyVersionSeriesId";
            }
            case "ecm:isCheckedIn": {
                return "ecm:isCheckedIn";
            }
            case "ecm:isLatestVersion": {
                return "ecm:isLatestVersion";
            }
            case "ecm:isLatestMajorVersion": {
                return "ecm:isLatestMajorVersion";
            }
            case "ecm:versionLabel": {
                return "ecm:versionLabel";
            }
            case "ecm:versionCreated": {
                return "ecm:versionCreated";
            }
            case "ecm:versionDescription": {
                return "ecm:versionDescription";
            }
            case "ecm:versionVersionableId": {
                return "ecm:versionSeriesId";
            }
            case "ecm:__ancestorIds": {
                return "ecm:ancestorIds";
            }
            case "ecm:__path": {
                return "ecm:__path";
            }
            case "ecm:__read_acl": {
                return "ecm:racl";
            }
            case "ecm:fulltextJobId": {
                return "ecm:fulltextJobId";
            }
            case "ecm:fulltextScore": {
                return "ecm:fulltextScore";
            }
            case "ecm:fulltext": 
            case "ecm:tag": {
                throw new UnsupportedOperationException(name);
            }
        }
        throw new RuntimeException("Unknown property: " + name);
    }

    public static String convToNXQL(String name) {
        switch (name) {
            case "ecm:id": {
                return "ecm:uuid";
            }
            case "ecm:name": {
                return "ecm:name";
            }
            case "ecm:pos": {
                return "ecm:pos";
            }
            case "ecm:parentId": {
                return "ecm:parentId";
            }
            case "ecm:mixinTypes": {
                return "ecm:mixinType";
            }
            case "ecm:primaryType": {
                return "ecm:primaryType";
            }
            case "ecm:isProxy": {
                return "ecm:isProxy";
            }
            case "ecm:isVersion": {
                return "ecm:isVersion";
            }
            case "ecm:lifeCycleState": {
                return "ecm:currentLifeCycleState";
            }
            case "ecm:lockOwner": {
                return "ecm:lockOwner";
            }
            case "ecm:lockCreated": {
                return "ecm:lockCreated";
            }
            case "ecm:proxyTargetId": {
                return "ecm:proxyTargetId";
            }
            case "ecm:proxyVersionSeriesId": {
                return "ecm:proxyVersionableId";
            }
            case "ecm:isCheckedIn": {
                return "ecm:isCheckedIn";
            }
            case "ecm:isLatestVersion": {
                return "ecm:isLatestVersion";
            }
            case "ecm:isLatestMajorVersion": {
                return "ecm:isLatestMajorVersion";
            }
            case "ecm:versionLabel": {
                return "ecm:versionLabel";
            }
            case "ecm:versionCreated": {
                return "ecm:versionCreated";
            }
            case "ecm:versionDescription": {
                return "ecm:versionDescription";
            }
            case "ecm:versionSeriesId": {
                return "ecm:versionVersionableId";
            }
            case "ecm:majorVersion": {
                return "major_version";
            }
            case "ecm:minorVersion": {
                return "minor_version";
            }
            case "ecm:fulltextScore": {
                return "ecm:fulltextScore";
            }
            case "ecm:lifeCyclePolicy": 
            case "ecm:acp": 
            case "ecm:ancestorIds": 
            case "ecm:baseVersionId": 
            case "ecm:racl": 
            case "ecm:fulltextSimple": 
            case "ecm:fulltextBinary": 
            case "ecm:fulltextJobId": {
                return null;
            }
        }
        throw new RuntimeException("Unknown property: " + name);
    }

    public static boolean isArray(String name) {
        switch (name) {
            case "ecm:mixinTypes": 
            case "ecm:ancestorIds": 
            case "ecm:proxyIds": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBoolean(String name) {
        switch (name) {
            case "ecm:isVersion": 
            case "ecm:isCheckedIn": 
            case "ecm:isLatestVersion": 
            case "ecm:isLatestMajorVersion": 
            case "ecm:isProxy": {
                return true;
            }
        }
        return false;
    }

    protected static class DBSQueryResult
    implements IterableQueryResult,
    Iterator<Map<String, Serializable>> {
        boolean closed;
        protected List<Map<String, Serializable>> maps;
        protected long totalSize;
        protected long pos;

        protected DBSQueryResult(PartialList<Map<String, Serializable>> pl) {
            this.maps = pl.list;
            this.totalSize = pl.totalSize;
        }

        public Iterator<Map<String, Serializable>> iterator() {
            return this;
        }

        public void close() {
            this.closed = true;
            this.pos = -1L;
        }

        public boolean isLife() {
            return !this.closed;
        }

        public long size() {
            return this.totalSize;
        }

        public long pos() {
            return this.pos;
        }

        public void skipTo(long pos) {
            if (pos < 0L) {
                pos = 0L;
            } else if (pos > this.totalSize) {
                pos = this.totalSize;
            }
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.totalSize;
        }

        @Override
        public Map<String, Serializable> next() {
            if (this.closed || this.pos == this.totalSize) {
                throw new NoSuchElementException();
            }
            Map<String, Serializable> map = this.maps.get((int)this.pos);
            ++this.pos;
            return map;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DBSDocumentListIterator
    implements DocumentIterator {
        private final int size;
        private final Iterator<Document> iterator;

        public DBSDocumentListIterator(List<Document> list) {
            this.size = list.size();
            this.iterator = list.iterator();
        }

        public long getSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Document next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

