/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class BucketIndexingWorker
extends BaseIndexingWorker
implements Work {
    private static final Log log = LogFactory.getLog(BucketIndexingWorker.class);
    private static final long serialVersionUID = -4665673026513796882L;
    private static final String DEFAULT_BUCKET_SIZE = "50";
    private final boolean warnAtEnd;
    private final int documentCount;

    public BucketIndexingWorker(String repositoryName, List<String> docIds, boolean warnAtEnd) {
        this.setDocuments(repositoryName, docIds);
        this.documentCount = docIds.size();
        this.warnAtEnd = warnAtEnd;
    }

    public String getTitle() {
        String title = " ElasticSearch bucket indexer size " + this.documentCount;
        return title;
    }

    @Override
    protected void doWork() throws Exception {
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        CoreSession session = this.initSession(this.repositoryName);
        int bucketSize = Math.min(this.documentCount, this.getBucketSize());
        ArrayList<String> ids = new ArrayList<String>(bucketSize);
        for (DocumentLocation doc : this.getDocuments()) {
            ids.add(doc.getIdRef().value);
            if (ids.size() % bucketSize != 0) continue;
            esi.indexNonRecursive(this.getIndexingCommands(session, ids));
            ids.clear();
        }
        if (!ids.isEmpty()) {
            esi.indexNonRecursive(this.getIndexingCommands(session, ids));
            ids.clear();
        }
        if (this.warnAtEnd) {
            log.warn((Object)String.format("Re-indexing job: %s completed.", this.getSchedulePath().getParentPath()));
        }
    }

    private List<IndexingCommand> getIndexingCommands(CoreSession session, List<String> ids) {
        ArrayList<IndexingCommand> ret = new ArrayList<IndexingCommand>(ids.size());
        for (DocumentModel doc : this.fetchDocuments(session, ids)) {
            IndexingCommand cmd = new IndexingCommand(doc, IndexingCommand.Type.INSERT, false, false);
            ret.add(cmd);
        }
        return ret;
    }

    private List<DocumentModel> fetchDocuments(CoreSession session, List<String> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document, Relation WHERE ecm:uuid IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= ids.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        session.save();
        return session.query(sb.toString());
    }

    protected int getBucketSize() {
        String value = Framework.getProperty((String)"elasticsearch.reindex.bucketWriteSize", (String)DEFAULT_BUCKET_SIZE);
        return Integer.parseInt(value);
    }
}

