/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.elements.CellElement;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.SectionElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;

public final class ThemeRepairer {
    private static final Log log = LogFactory.getLog(ThemeRepairer.class);
    private static final String[] LAYOUT_PROPERTIES = new String[]{"width", "height", "text-align", "padding", "margin", "margin-left", "margin-right", "margin-top", "margin-bottom", "padding-left", "padding-right", "padding-bottom", "padding-top"};
    private static final String[] PAGE_LAYOUT_PROPERTIES = new String[]{"margin", "padding"};
    private static final String[] SECTION_LAYOUT_PROPERTIES = new String[]{"width", "height", "margin-right", "margin-left"};
    private static final String[] CELL_LAYOUT_PROPERTIES = new String[]{"width", "padding", "text-align"};
    private static final String[] PAGE_STYLE_PROPERTIES = new String[]{"border-top", "border-left", "border-bottom", "border-right", "background"};
    private static final String[] SECTION_STYLE_PROPERTIES = new String[]{"border-top", "border-left", "border-bottom", "border-right", "background"};
    private static final String[] CELL_STYLE_PROPERTIES = new String[]{"border-top", "border-left", "border-bottom", "border-right", "background"};

    public static void repair(ThemeElement theme) throws ThemeException {
        Element element;
        ThemeRepairer.checkSharedFormats(theme);
        List<Node> allElements = theme.getDescendants();
        allElements.add(theme);
        for (Node node : allElements) {
            element = (Element)node;
            if (!(element instanceof PageElement) && !(element instanceof SectionElement) && !(element instanceof CellElement)) continue;
            ThemeRepairer.moveLayoutProperties(element);
        }
        for (Node node : allElements) {
            element = (Element)node;
            if (!(element instanceof PageElement) && !(element instanceof SectionElement) && !(element instanceof CellElement)) continue;
            ThemeRepairer.cleanupStyles(element);
            ThemeRepairer.cleanupLayouts(element);
        }
    }

    public static void checkSharedFormats(ThemeElement theme) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        for (Format format : Manager.getThemeManager().listFormats()) {
            Collection<Element> elements = ElementFormatter.getElementsFor(format);
            if (elements.size() < 2) continue;
            HashMap<ElementType, Format> formatsByElementTypes = new HashMap<ElementType, Format>();
            for (Element element : elements) {
                if (!element.isChildOf(theme)) continue;
                ElementType elementType = element.getElementType();
                if (formatsByElementTypes.isEmpty()) {
                    formatsByElementTypes.put(elementType, format);
                    continue;
                }
                if (formatsByElementTypes.containsKey(elementType)) continue;
                log.debug((Object)("Created format of type '" + format.getFormatType().getTypeName() + "' for element: '" + element.computeXPath() + "' "));
                formatsByElementTypes.put(elementType, themeManager.duplicateFormat(format));
            }
            for (Map.Entry entry : formatsByElementTypes.entrySet()) {
                Format f = (Format)entry.getValue();
                ElementType elementType = (ElementType)entry.getKey();
                for (Element element : elements) {
                    if (!element.getElementType().equals(elementType)) continue;
                    ElementFormatter.setFormat(element, f);
                }
            }
        }
    }

    private static void moveLayoutProperties(Element element) throws ThemeException {
        Properties styleProperties;
        String viewName;
        Widget widget = (Widget)ElementFormatter.getFormatFor(element, "widget");
        Style style = (Style)ElementFormatter.getFormatFor(element, "style");
        Layout layout = (Layout)ElementFormatter.getFormatFor(element, "layout");
        String xpath = element.computeXPath();
        if (layout == null) {
            layout = (Layout)FormatFactory.create("layout");
            Manager.getThemeManager().registerFormat(layout);
            ElementFormatter.setFormat(element, layout);
            log.debug((Object)("Added layout to element: " + xpath));
        }
        if (ElementFormatter.getFormatFor(element, "widget") == null) {
            log.error((Object)("Element " + xpath + " has no widget."));
        }
        if (style != null && widget != null && (viewName = widget.getName()) != null && (styleProperties = style.getPropertiesFor(viewName, "")) != null) {
            ArrayList<String> propertiesToMove = new ArrayList<String>();
            for (String key : LAYOUT_PROPERTIES) {
                String value = (String)styleProperties.get(key);
                if (value == null) continue;
                propertiesToMove.add(key);
            }
            if (!propertiesToMove.isEmpty()) {
                for (String key : propertiesToMove) {
                    layout.setProperty(key, styleProperties.getProperty(key));
                    log.debug((Object)("Moved property '" + key + "' from <style> to <layout> for element " + xpath));
                }
            }
        }
    }

    private static void cleanupStyles(Element element) {
        Widget widget = (Widget)ElementFormatter.getFormatFor(element, "widget");
        Style style = (Style)ElementFormatter.getFormatFor(element, "style");
        String xpath = element.computeXPath();
        if (style != null && widget != null) {
            String viewName = widget.getName();
            ArrayList<String> pathsToClear = new ArrayList<String>();
            for (String path : style.getPathsForView(viewName)) {
                Properties styleProperties = style.getPropertiesFor(viewName, path);
                if (styleProperties == null) continue;
                for (String key : LAYOUT_PROPERTIES) {
                    if (!styleProperties.containsKey(key)) continue;
                    styleProperties.remove(key);
                    log.debug((Object)("Removed property: '" + key + "' from <style> for element " + xpath));
                }
                if (styleProperties.isEmpty()) {
                    pathsToClear.add(path);
                    continue;
                }
                ArrayList<String> stylePropertiesToRemove = new ArrayList<String>();
                for (Object key : styleProperties.keySet()) {
                    String propertyName = (String)key;
                    if (!(widget instanceof PageElement && !Utils.contains(PAGE_STYLE_PROPERTIES, propertyName) || widget instanceof SectionElement && !Utils.contains(SECTION_STYLE_PROPERTIES, propertyName)) && (!(widget instanceof CellElement) || Utils.contains(CELL_STYLE_PROPERTIES, propertyName))) continue;
                    stylePropertiesToRemove.add(propertyName);
                }
                for (String propertyName : stylePropertiesToRemove) {
                    styleProperties.remove(propertyName);
                    log.debug((Object)("Removed style property: '" + propertyName + " in path: " + path + "' for element " + xpath));
                }
            }
            for (String path : pathsToClear) {
                style.clearPropertiesFor(viewName, path);
                log.debug((Object)("Removed empty style path: '" + path + "' for element " + xpath));
            }
        }
    }

    private static void cleanupLayouts(Element element) {
        Layout layout = (Layout)ElementFormatter.getFormatFor(element, "layout");
        String xpath = element.computeXPath();
        Properties layoutProperties = layout.getProperties();
        ArrayList<String> layoutPropertiesToRemove = new ArrayList<String>();
        for (Object key : layoutProperties.keySet()) {
            String propertyName = (String)key;
            if (!(element instanceof PageElement && !Utils.contains(PAGE_LAYOUT_PROPERTIES, propertyName) || element instanceof SectionElement && !Utils.contains(SECTION_LAYOUT_PROPERTIES, propertyName)) && (!(element instanceof CellElement) || Utils.contains(CELL_LAYOUT_PROPERTIES, propertyName))) continue;
            layoutPropertiesToRemove.add(propertyName);
        }
        for (String propertyName : layoutPropertiesToRemove) {
            layoutProperties.remove(propertyName);
            log.debug((Object)("Removed property '" + propertyName + "' from <layout> for element " + xpath));
        }
    }
}

