/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.fn;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.core.Manager;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public final class DocumentModelFunctions
implements LiveEditConstants {
    private static final Log log = LogFactory.getLog(DocumentModelFunctions.class);
    private static final String JSESSIONID = "JSESSIONID";
    private static final String i18n_prefix = "%i18n";
    private static final String NXEDIT_URL_VIEW_ID = "nxliveedit.faces";
    private static final String NXEDIT_URL_SCHEME = "nxedit";
    private static MimetypeRegistry mimetypeService;
    private static TypeManager typeManagerService;
    private static DirectoryService dirService;
    private static LifeCycleService lifeCycleService;
    private static final Map<String, String> defaultViewCache;

    private DocumentModelFunctions() {
    }

    private static DirectoryService getDirectoryService() {
        if (dirService == null) {
            dirService = DirectoryHelper.getDirectoryService();
        }
        return dirService;
    }

    private static MimetypeRegistry getMimetypeService() {
        if (mimetypeService == null) {
            try {
                mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            }
            catch (Exception e) {
                log.error((Object)("Unable to get mimetype service : " + e.getMessage()));
            }
        }
        return mimetypeService;
    }

    private static TypeManager getTypeManager() {
        if (typeManagerService == null) {
            try {
                typeManagerService = (TypeManager)Framework.getService(TypeManager.class);
            }
            catch (Exception e) {
                log.error((Object)("Unable to get typeManager service : " + e.getMessage()));
            }
        }
        return typeManagerService;
    }

    private static String getDefaultView(DocumentModel doc) {
        String docType = doc.getType();
        if (defaultViewCache.containsKey(docType)) {
            return defaultViewCache.get(docType);
        }
        org.nuxeo.ecm.platform.types.Type type = DocumentModelFunctions.getTypeManager().getType(docType);
        if (type == null) {
            return null;
        }
        String defaultView = type.getDefaultView();
        defaultViewCache.put(docType, defaultView);
        return defaultView;
    }

    private static LifeCycleService geLifeCycleService() {
        if (lifeCycleService == null && (lifeCycleService = NXCore.getLifeCycleService()) == null) {
            log.error((Object)"No Life Cycle service registered");
        }
        return lifeCycleService;
    }

    public static TypeInfo typeInfo(DocumentModel document) {
        if (document != null) {
            return (TypeInfo)document.getAdapter(TypeInfo.class);
        }
        return null;
    }

    public static String typeLabel(DocumentModel document) {
        TypeInfo typeInfo;
        String label = "";
        if (document != null && (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) != null) {
            label = typeInfo.getLabel();
        }
        return label;
    }

    public static String typeView(DocumentModel document, String viewId) {
        TypeInfo typeInfo;
        String viewValue = "";
        if (document != null && (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) != null) {
            viewValue = typeInfo.getView(viewId);
        }
        return viewValue;
    }

    public static String iconPath(DocumentModel document) {
        String iconPath = "";
        if (document != null) {
            TypeInfo typeInfo;
            try {
                iconPath = (String)document.getProperty("common", "icon");
            }
            catch (ClientException e) {
                iconPath = null;
            }
            if ((iconPath == null || iconPath.length() == 0 || document.getType().equals("Workspace")) && (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) != null) {
                iconPath = typeInfo.getIcon();
            }
        }
        return iconPath;
    }

    public static String iconExpandedPath(DocumentModel document) {
        String iconPath = "";
        if (document != null) {
            TypeInfo typeInfo;
            try {
                iconPath = (String)document.getProperty("common", "icon-expanded");
            }
            catch (ClientException e) {
                iconPath = null;
            }
            if (!(iconPath != null && iconPath.length() != 0 || (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) == null || (iconPath = typeInfo.getIconExpanded()) != null && !iconPath.equals(""))) {
                iconPath = DocumentModelFunctions.iconPath(document);
            }
        }
        return iconPath;
    }

    public static String bigIconPath(DocumentModel document) {
        TypeInfo typeInfo;
        String iconPath = "";
        if (document != null && (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) != null) {
            iconPath = typeInfo.getBigIcon();
        }
        return iconPath;
    }

    public static String bigIconExpandedPath(DocumentModel document) {
        TypeInfo typeInfo;
        String iconPath = "";
        if (document != null && (typeInfo = (TypeInfo)document.getAdapter(TypeInfo.class)) != null && ((iconPath = typeInfo.getIconExpanded()) == null || iconPath.equals(""))) {
            iconPath = DocumentModelFunctions.bigIconPath(document);
        }
        return iconPath;
    }

    public static String fileIconPath(Blob blob) {
        String iconPath = "";
        if (blob != null) {
            try {
                MimetypeEntry mimeEntry = DocumentModelFunctions.getMimetypeService().getMimetypeEntryByMimeType(blob.getMimeType());
                if (mimeEntry != null && mimeEntry.getIconPath() != null) {
                    iconPath = "/icons/" + mimeEntry.getIconPath();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iconPath;
    }

    public static String titleOrId(DocumentModel document) {
        String title = null;
        if (document != null) {
            try {
                title = (String)document.getProperty("dublincore", "title");
            }
            catch (ClientException e) {
                title = null;
            }
            if (title == null || title.length() == 0) {
                title = "/".equals(document.getPathAsString()) ? "/" : document.getId();
            }
        }
        if (title == null) {
            title = "<Unknown>";
        }
        if (title.startsWith(i18n_prefix)) {
            String i18nTitle = title.substring(i18n_prefix.length());
            FacesContext context = FacesContext.getCurrentInstance();
            title = ComponentUtils.translate(context, i18nTitle);
        }
        return title;
    }

    public static String titleFromId(String documentId) throws ClientException {
        CoreSession coreSession = (CoreSession)Component.getInstance((String)"documentManager");
        if (StringUtils.isNotBlank((String)documentId)) {
            try {
                return coreSession.getDocument((DocumentRef)new IdRef(documentId)).getTitle();
            }
            catch (ClientException e) {
                log.info((Object)String.format("Could not find document with id %s", documentId));
                return documentId;
            }
        }
        return null;
    }

    public static boolean isDocumentModel(Object value) {
        return value instanceof DocumentModel;
    }

    public static boolean isDirty(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return false;
        }
        for (DocumentPart part : doc.getParts()) {
            Iterator props;
            if (!part.isDirty() || (props = part.getDirtyChildren()) == null) continue;
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                Serializable value = prop.getValue();
                if (value == null || !DocumentModelFunctions.isPropertyValueDirty(value)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isPropertyValueDirty(Object value) {
        if (value instanceof String) {
            if (!StringUtils.isBlank((String)((String)value))) {
                return true;
            }
        } else if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                return true;
            }
        } else if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (!col.isEmpty()) {
                return true;
            }
        } else if (value instanceof Object[]) {
            Object[] col = (Object[])value;
            if (col.length > 0) {
                return true;
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return true;
            }
            for (Object mapItem : map.values()) {
                if (!DocumentModelFunctions.isPropertyValueDirty(mapItem)) continue;
                return true;
            }
        } else if (value != null) {
            return true;
        }
        return false;
    }

    public static boolean hasPermission(DocumentModel document, String permission) throws ClientException {
        if (document == null) {
            return false;
        }
        CoreSession session = document.getCoreSession();
        if (session == null) {
            session = (CoreSession)Component.getInstance((String)"documentManager", (ScopeType)ScopeType.CONVERSATION);
        }
        if (session == null) {
            log.error((Object)("Cannot retrieve CoreSession for " + document));
            return false;
        }
        boolean granted = session.hasPermission(document.getRef(), permission);
        return granted;
    }

    public static boolean canModify(DocumentModel document) throws ClientException {
        if (document == null) {
            return false;
        }
        return DocumentModelFunctions.hasPermission(document, "Write") && !document.hasFacet("Immutable");
    }

    @Deprecated
    public static Object defaultValue(String schemaName, String fieldName) throws Exception {
        Object value = null;
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = tm.getSchema(schemaName);
        Field field = schema.getField(fieldName);
        Type type = field.getType();
        if (type.isListType()) {
            Type itemType = ((ListType)type).getFieldType();
            value = itemType.newInstance();
        }
        return value;
    }

    protected static Field getField(Field parent, String subFieldName) {
        if (parent != null) {
            Type type = parent.getType();
            if (type.isListType()) {
                Type itemType = ((ListType)type).getFieldType();
                if (itemType.isComplexType()) {
                    ComplexType complexType = (ComplexType)itemType;
                    Field subField = complexType.getField(subFieldName);
                    return subField;
                }
            } else if (type.isComplexType()) {
                return ((ComplexType)type).getField(subFieldName);
            }
        }
        return null;
    }

    public static Object defaultValue(String propertyName) throws Exception {
        Type type;
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        Field field = null;
        if (propertyName != null && propertyName.contains("/")) {
            String[] properties = propertyName.split("/");
            Field resolvedField = tm.getField(properties[0]);
            for (int x = 1; x < properties.length && resolvedField != null; ++x) {
                resolvedField = DocumentModelFunctions.getField(resolvedField, properties[x]);
            }
            if (resolvedField != null) {
                field = resolvedField;
            }
        } else {
            field = tm.getField(propertyName);
        }
        Object value = null;
        if (field != null && (type = field.getType()).isListType()) {
            Type itemType = ((ListType)type).getFieldType();
            value = itemType.newInstance();
        }
        return value;
    }

    public static String fileUrl(String baseURL, String patternName, DocumentModel doc, String blobPropertyName, String filename) {
        if (doc == null) {
            return null;
        }
        try {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("FILE_PROPERTY_PATH", blobPropertyName);
            params.put("FILENAME", filename);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, null, params);
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            if (patternName == null) {
                patternName = service.getDefaultPatternName();
            }
            return service.getUrlFromDocumentView(patternName, (DocumentView)docView, baseURL);
        }
        catch (Exception e) {
            log.error((Object)"Could not generate url for document file", (Throwable)e);
            return null;
        }
    }

    public static String fileUrl(String patternName, DocumentModel doc, String blobPropertyName, String filename) {
        return DocumentModelFunctions.fileUrl(BaseURL.getBaseURL(), patternName, doc, blobPropertyName, filename);
    }

    public static String bigFileUrl(DocumentModel doc, String blobPropertyName, String filename) {
        if (doc == null) {
            return null;
        }
        String bigDownloadURL = BaseURL.getBaseURL();
        bigDownloadURL = bigDownloadURL + "nxbigfile/";
        bigDownloadURL = bigDownloadURL + doc.getRepositoryName() + "/";
        bigDownloadURL = bigDownloadURL + doc.getRef().toString() + "/";
        bigDownloadURL = bigDownloadURL + blobPropertyName + "/";
        bigDownloadURL = bigDownloadURL + filename;
        return bigDownloadURL;
    }

    public static String fileDescription(DocumentModel document, String blobPropertyName, String filePropertyName, String filename) {
        String fileInfo = "";
        if (document != null) {
            Long blobLength = null;
            try {
                Blob blob = (Blob)document.getPropertyValue(blobPropertyName);
                if (blob != null) {
                    blobLength = blob.getLength();
                }
            }
            catch (ClientException e) {
                // empty catch block
            }
            if (filename != null && filePropertyName != null) {
                try {
                    filename = (String)((Object)document.getPropertyValue(filePropertyName));
                }
                catch (ClientException e) {
                    // empty catch block
                }
            }
            if (blobLength != null && filename != null) {
                fileInfo = String.format("%s [%s]", filename, Functions.printFileSize(String.valueOf(blobLength)));
            } else if (blobLength != null) {
                fileInfo = String.format("[%s]", Functions.printFileSize(String.valueOf(blobLength)));
            } else if (filename != null) {
                fileInfo = filename;
            }
        }
        return fileInfo;
    }

    public static String complexFileUrl(String patternName, DocumentModel doc, int index, String filename) {
        return DocumentModelFunctions.complexFileUrl(patternName, doc, "files:files", index, "file", filename);
    }

    public static String complexFileUrl(String patternName, DocumentModel doc, String listElement, int index, String blobPropertyName, String filename) {
        try {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
            HashMap<String, String> params = new HashMap<String, String>();
            String fileProperty = DocumentModelFunctions.getPropertyPath(listElement, index, blobPropertyName);
            params.put("FILE_PROPERTY_PATH", fileProperty);
            params.put("FILENAME", filename);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, null, params);
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            if (patternName == null) {
                patternName = service.getDefaultPatternName();
            }
            return service.getUrlFromDocumentView(patternName, (DocumentView)docView, BaseURL.getBaseURL());
        }
        catch (Exception e) {
            log.error((Object)"Could not generate url for document file", (Throwable)e);
            return null;
        }
    }

    public static String documentUrl(DocumentModel doc, HttpServletRequest req) {
        return DocumentModelFunctions.documentUrl(null, doc, null, null, false);
    }

    public static String documentUrl(DocumentModel doc) {
        return DocumentModelFunctions.documentUrl(null, doc, null, null, false);
    }

    public static String documentUrl(String patternName, DocumentModel doc, String viewId, Map<String, String> parameters, boolean newConversation) {
        return DocumentModelFunctions.documentUrl(patternName, doc, viewId, parameters, newConversation, (HttpServletRequest)null);
    }

    public static String documentUrl(String patternName, DocumentModel doc, String viewId, Map<String, String> parameters, boolean newConversation, HttpServletRequest req) {
        String baseURL = null;
        baseURL = req == null ? BaseURL.getBaseURL() : BaseURL.getBaseURL((ServletRequest)req);
        return DocumentModelFunctions.documentUrl(patternName, doc, viewId, parameters, newConversation, baseURL);
    }

    public static String documentUrl(String patternName, DocumentModel doc, String viewId, Map<String, String> parameters, boolean newConversation, String baseURL) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
        if (viewId == null || viewId.length() == 0) {
            viewId = DocumentModelFunctions.getDefaultView(doc);
        }
        HashMap<String, String> hashMap = parameters = parameters == null ? new HashMap<String, String>() : parameters;
        if (doc.isVersion()) {
            parameters.put("version", "true");
        }
        return DocumentModelFunctions.documentUrl(patternName, (DocumentLocation)docLoc, viewId, parameters, newConversation, baseURL);
    }

    public static String documentUrl(String patternName, DocumentLocation docLoc, String viewId, Map<String, String> parameters, boolean newConversation, HttpServletRequest req) {
        String baseURL = null;
        baseURL = req == null ? BaseURL.getBaseURL() : BaseURL.getBaseURL((ServletRequest)req);
        return DocumentModelFunctions.documentUrl(patternName, docLoc, viewId, parameters, newConversation, baseURL);
    }

    public static String documentUrl(String patternName, DocumentLocation docLoc, String viewId, Map<String, String> parameters, boolean newConversation, String baseURL) {
        DocumentViewImpl docView = new DocumentViewImpl(docLoc, viewId, parameters);
        URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
        if (patternName == null || patternName.length() == 0) {
            patternName = service.getDefaultPatternName();
        }
        String url = service.getUrlFromDocumentView(patternName, (DocumentView)docView, baseURL);
        if (!newConversation && url != null) {
            url = RestHelper.addCurrentConversationParameters(url);
        }
        return url;
    }

    public static String repositoryUrl(String patternName, String repositoryName, String viewId, Map<String, String> parameters, boolean newConversation) {
        return DocumentModelFunctions.repositoryUrl(patternName, repositoryName, viewId, parameters, newConversation, (HttpServletRequest)null);
    }

    public static String repositoryUrl(String patternName, String repositoryName, String viewId, Map<String, String> parameters, boolean newConversation, HttpServletRequest req) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(repositoryName, null);
        parameters = parameters == null ? new HashMap<String, String>() : parameters;
        return DocumentModelFunctions.documentUrl(patternName, (DocumentLocation)docLoc, viewId, parameters, newConversation, req);
    }

    public static String repositoryUrl(String patternName, String repositoryName, String viewId, Map<String, String> parameters, boolean newConversation, String baseURL) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(repositoryName, null);
        parameters = parameters == null ? new HashMap<String, String>() : parameters;
        return DocumentModelFunctions.documentUrl(patternName, (DocumentLocation)docLoc, viewId, parameters, newConversation, baseURL);
    }

    protected static void addQueryParameter(StringBuilder sb, String name, String value, boolean isFirst) throws ClientException {
        if (isFirst) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        if (value == null) {
            return;
        }
        sb.append(name);
        sb.append("=");
        try {
            sb.append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(String.format("could not encode URL parameter: %s=%s", name, value), (Throwable)e);
        }
    }

    public static String liveEditUrl(DocumentModel doc) throws ClientException {
        return DocumentModelFunctions.liveEditUrl(doc, "file", "content", "filename");
    }

    public static String liveEditUrl(DocumentModel doc, String schemaName, String blobFieldName, String filenameFieldName) throws ClientException {
        if (doc == null) {
            return "";
        }
        StringBuilder queryParamBuilder = new StringBuilder();
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "action", "edit", true);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "repoID", doc.getRepositoryName(), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "docRef", doc.getRef().toString(), false);
        if (schemaName == null || "".equals(schemaName)) {
            schemaName = DocumentModelUtils.getSchemaName((String)blobFieldName);
            blobFieldName = DocumentModelUtils.getFieldName((String)blobFieldName);
            filenameFieldName = DocumentModelUtils.getFieldName((String)filenameFieldName);
        }
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "schema", schemaName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "blobField", blobFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "filenameField", filenameFieldName, false);
        return DocumentModelFunctions.buildNxEditUrl(queryParamBuilder.toString());
    }

    public static String complexLiveEditUrl(DocumentModel doc, String listPropertyName, int index, String blobPropertyName, String filenamePropertyName) throws ClientException {
        StringBuilder queryParamBuilder = new StringBuilder();
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "action", "edit", true);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "repoID", doc.getRepositoryName(), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "docRef", doc.getRef().toString(), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "blobPropertyName", DocumentModelFunctions.getPropertyPath(listPropertyName, index, blobPropertyName), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "filenamePropertyName", DocumentModelFunctions.getPropertyPath(listPropertyName, index, filenamePropertyName), false);
        return DocumentModelFunctions.buildNxEditUrl(queryParamBuilder.toString());
    }

    public static String liveCreateUrl(String mimetype) throws ClientException {
        return DocumentModelFunctions.liveCreateUrl(mimetype, "File", "file", "content", "filename");
    }

    public static String liveCreateUrl(String mimetype, String docType, String schemaName, String blobFieldName, String filenameFieldName) throws ClientException {
        StringBuilder queryParamBuilder = new StringBuilder();
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "action", "create", true);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "mimetype", mimetype, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "schema", schemaName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "blobField", blobFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "filenameField", filenameFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "docType", docType, false);
        return DocumentModelFunctions.buildNxEditUrl(queryParamBuilder.toString());
    }

    public static String liveCreateFromTemplateUrl(DocumentModel template) throws ClientException {
        return DocumentModelFunctions.liveCreateFromTemplateUrl(template, "file", "content", "File", "file", "content", "filename");
    }

    public static String liveCreateFromTemplateUrl(DocumentModel template, String templateSchemaName, String templateBlobFieldName, String docType, String schemaName, String blobFieldName, String filenameFieldName) throws ClientException {
        StringBuilder queryParamBuilder = new StringBuilder();
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "action", "createFromTemplate", true);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "templateRepoID", template.getRepositoryName(), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "templateDocRef", template.getRef().toString(), false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "templateSchema", templateSchemaName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "templateBlobField", templateBlobFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "schema", schemaName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "blobField", blobFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "filenameField", filenameFieldName, false);
        DocumentModelFunctions.addQueryParameter(queryParamBuilder, "docType", docType, false);
        return DocumentModelFunctions.buildNxEditUrl(queryParamBuilder.toString());
    }

    private static String buildNxEditUrl(String queryParameters) throws ClientException {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        StringBuilder nxeditUrlBuilder = new StringBuilder(NXEDIT_URL_SCHEME);
        nxeditUrlBuilder.append(":");
        nxeditUrlBuilder.append(BaseURL.getBaseURL((ServletRequest)request));
        nxeditUrlBuilder.append(NXEDIT_URL_VIEW_ID);
        nxeditUrlBuilder.append(queryParameters);
        DocumentModelFunctions.addQueryParameter(nxeditUrlBuilder, Manager.instance().getConversationIdParameter(), Manager.instance().getCurrentConversationId(), false);
        DocumentModelFunctions.addQueryParameter(nxeditUrlBuilder, JSESSIONID, DocumentModelFunctions.extractJSessionId(request), false);
        return nxeditUrlBuilder.toString();
    }

    public static String extractJSessionId(HttpServletRequest request) {
        if (request.getSession() != null) {
            return request.getSession().getId();
        }
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equalsIgnoreCase("jsessionid")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getLabelFromId(String directoryName, String id) throws DirectoryException {
        if (id == null) {
            return "";
        }
        try (Session directory = null;){
            directory = DocumentModelFunctions.getDirectoryService().open(directoryName);
            DocumentModel documentModel = directory.getEntry(id);
            String schemaName = documentModel.getSchemas()[0];
            String string = (String)documentModel.getProperty(schemaName, "label");
            return string;
        }
    }

    public static String getPropertyPath(String listPropertyName, int index, String subPropertyName) {
        return String.format("%s/%s/%s", listPropertyName, index, subPropertyName);
    }

    public static Collection<String> getAvailableLifeCycleTransitions(String lifeCycleName, String currentState) throws LifeCycleException {
        LifeCycle lf = DocumentModelFunctions.geLifeCycleService().getLifeCycleByName(lifeCycleName);
        return lf.getAllowedStateTransitionsFrom(currentState);
    }

    public static void resetDefaultViewCache() {
        defaultViewCache.clear();
    }

    static {
        defaultViewCache = Collections.synchronizedMap(new HashMap());
    }
}

