/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;

public class BlobWrapper
extends AbstractBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Blob blob;
    protected String filename;

    public BlobWrapper(Blob blob) {
        this.blob = blob;
    }

    public BlobWrapper(Blob blob, String filename) {
        this.blob = blob;
        this.filename = filename;
    }

    @Override
    public long getLength() {
        return this.blob.getLength();
    }

    @Override
    public String getEncoding() {
        return this.blob.getEncoding();
    }

    @Override
    public String getMimeType() {
        return this.blob.getMimeType();
    }

    @Override
    public String getFilename() {
        return this.filename != null ? this.filename : this.blob.getFilename();
    }

    @Override
    public String getDigestAlgorithm() {
        return this.blob.getDigestAlgorithm();
    }

    @Override
    public String getDigest() {
        return this.blob.getDigest();
    }

    @Override
    public void setDigest(String digest) {
        this.blob.setDigest(digest);
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.blob.setMimeType(mimeType);
    }

    @Override
    public void setEncoding(String encoding) {
        this.blob.setEncoding(encoding);
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.blob.getStream();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.blob.getReader();
    }

    @Override
    public byte[] getByteArray() throws IOException {
        return this.blob.getByteArray();
    }

    @Override
    public String getString() throws IOException {
        return this.blob.getString();
    }

    @Override
    public Blob persist() throws IOException {
        return this.blob.persist();
    }

    @Override
    public boolean isPersistent() {
        return this.blob.isPersistent();
    }
}

