/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.ConnectionResetException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.InvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;

public class ClusterNodeHandler {
    private static final Log log = LogFactory.getLog(ClusterNodeHandler.class);
    protected static final Random RANDOM = new Random();
    private final Mapper clusterNodeMapper;
    private final long clusteringDelay;
    private long clusterNodeLastInvalidationTimeMillis;
    private final InvalidationsPropagator propagator;
    private Serializable nodeId;

    public ClusterNodeHandler(Mapper clusterNodeMapper, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        int type;
        this.clusterNodeMapper = clusterNodeMapper;
        String nodeIdString = repositoryDescriptor.getClusterNodeId();
        if (StringUtils.isBlank((String)nodeIdString)) {
            nodeIdString = String.valueOf(RANDOM.nextInt(32768));
            log.warn((Object)("Missing cluster node id configuration, please define it explicitly (usually through repository.clustering.id). Using random cluster node id instead: " + nodeIdString));
        }
        this.nodeId = (type = clusterNodeMapper.getClusterNodeIdType()) == 12 ? nodeIdString.trim() : Long.valueOf(nodeIdString);
        log.info((Object)("Initializing cluster node: " + this.nodeId));
        clusterNodeMapper.createClusterNode(this.nodeId);
        this.clusteringDelay = repositoryDescriptor.getClusteringDelay();
        this.processClusterInvalidationsNext();
        this.propagator = new InvalidationsPropagator("cluster-" + this);
    }

    public JDBCConnection getConnection() {
        return (JDBCConnection)((Object)this.clusterNodeMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws StorageException {
        Mapper mapper = this.clusterNodeMapper;
        synchronized (mapper) {
            try {
                this.clusterNodeMapper.removeClusterNode(this.nodeId);
            }
            catch (StorageException e) {
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            this.clusterNodeMapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionWasReset() throws StorageException {
        Mapper mapper = this.clusterNodeMapper;
        synchronized (mapper) {
            this.propagator.propagateInvalidations(new Invalidations(true), null);
        }
    }

    public void processClusterInvalidationsNext() {
        this.clusterNodeLastInvalidationTimeMillis = System.currentTimeMillis() - this.clusteringDelay - 1L;
    }

    public void addQueue(InvalidationsQueue queue) {
        this.propagator.addQueue(queue);
    }

    public void removeQueue(InvalidationsQueue queue) {
        this.propagator.removeQueue(queue);
    }

    public void propagateInvalidations(Invalidations invalidations, InvalidationsQueue skipQueue) {
        this.propagator.propagateInvalidations(invalidations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invalidations receiveClusterInvalidations() throws StorageException {
        Mapper mapper = this.clusterNodeMapper;
        synchronized (mapper) {
            Invalidations invalidations;
            long remaining = this.clusterNodeLastInvalidationTimeMillis + this.clusteringDelay - System.currentTimeMillis();
            if (remaining > 0L) {
                log.trace((Object)("Not fetching invalidations, remaining time: " + remaining + "ms"));
                return null;
            }
            try {
                invalidations = this.clusterNodeMapper.getClusterInvalidations(this.nodeId);
            }
            catch (ConnectionResetException e) {
                invalidations = this.clusterNodeMapper.getClusterInvalidations(this.nodeId);
            }
            this.clusterNodeLastInvalidationTimeMillis = System.currentTimeMillis();
            return invalidations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClusterInvalidations(Invalidations invalidations) throws StorageException {
        if (invalidations == null || invalidations.isEmpty()) {
            return;
        }
        Mapper mapper = this.clusterNodeMapper;
        synchronized (mapper) {
            this.clusterNodeMapper.insertClusterInvalidations(this.nodeId, invalidations);
        }
    }
}

