/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class DiscoveryService {

    public static class GetContentChanges
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String changeLogToken = this.getStringParameter(request, "changeLogToken");
            Boolean includeProperties = this.getBooleanParameter(request, "includeProperties");
            String filter = this.getStringParameter(request, "filter");
            Boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds");
            Boolean includeAcl = this.getBooleanParameter(request, "includeACL");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
            ObjectList changes = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, null);
            if (this.stopAfterService(service)) {
                return;
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonChanges = JSONConverter.convert((ObjectList)changes, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.CHANGE, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            jsonChanges.put("changeLogToken", changeLogTokenHolder.getValue());
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonChanges, request, response);
        }
    }

    public static class Query
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String statement = this.getStringParameter(request, "statement");
            if (statement == null || statement.length() == 0) {
                statement = this.getStringParameter(request, "q");
            }
            Boolean searchAllVersions = this.getBooleanParameter(request, "searchAllVersions");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectList results = service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (results == null) {
                throw new CmisRuntimeException("Results are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonResults = JSONConverter.convert((ObjectList)results, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.QUERY, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonResults, request, response);
        }
    }
}

