/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class YamlAutomationRepresenter
extends Representer {
    public YamlAutomationRepresenter() {
        this.addClassTag(OperationDocumentation.class, Tag.MAP);
        this.representers.put(OperationDocumentation.class, new ChainRepr());
        this.addClassTag(OperationChainContribution.Operation.class, Tag.MAP);
        this.representers.put(OperationChainContribution.Operation.class, new OpRepr());
        this.addClassTag(OperationDocumentation.Param.class, Tag.MAP);
        this.representers.put(OperationDocumentation.Param.class, new ParamRepr());
    }

    public class ParamRepr
    implements Represent {
        public Node representData(Object data) {
            OperationDocumentation.Param p = (OperationDocumentation.Param)data;
            Tag tag = YamlAutomationRepresenter.this.getTag(OperationDocumentation.Param.class, null);
            HashMap mapping = new HashMap();
            LinkedHashMap<String, Object> subs = new LinkedHashMap<String, Object>();
            subs.put("type", p.getType());
            if (p.getDescription() != null) {
                subs.put("description", p.getDescription());
            }
            if (p.getValues() != null && p.getValues().length != 0) {
                subs.put("values", p.getValues());
            }
            mapping.put(p.getName(), subs);
            return YamlAutomationRepresenter.this.representMapping(tag, mapping, null);
        }
    }

    public class OpRepr
    implements Represent {
        public Node representData(Object data) {
            OperationChainContribution.Operation op = (OperationChainContribution.Operation)data;
            Tag tag = YamlAutomationRepresenter.this.getTag(OperationChainContribution.Operation.class, null);
            ArrayList params = op.getParams();
            if (params != null && !params.isEmpty()) {
                HashMap mapping = new HashMap();
                LinkedHashMap<String, Object> subs = new LinkedHashMap<String, Object>();
                for (OperationChainContribution.Param param : params) {
                    if ("properties".equals(param.getType())) {
                        Properties props;
                        if (param.getMap() != null && !param.getMap().isEmpty()) {
                            props = new Properties(param.getMap());
                            subs.put(param.getName(), props);
                            continue;
                        }
                        try {
                            props = new Properties(param.getValue());
                            subs.put(param.getName(), props);
                        }
                        catch (Exception e) {
                            subs.put(param.getName(), param.getValue());
                        }
                        continue;
                    }
                    subs.put(param.getName(), param.getValue());
                }
                mapping.put(op.getId(), subs);
                return YamlAutomationRepresenter.this.representMapping(tag, mapping, null);
            }
            return YamlAutomationRepresenter.this.representData(op.getId());
        }
    }

    public class ChainRepr
    implements Represent {
        public Node representData(Object data) {
            OperationChainContribution.Operation[] ops;
            OperationDocumentation c = (OperationDocumentation)data;
            Tag tag = YamlAutomationRepresenter.this.getTag(OperationDocumentation.class, null);
            LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
            if (c.getDescription() != null) {
                mapping.put("description", c.getDescription());
            }
            if (c.getParams() != null && c.getParams().length != 0) {
                mapping.put("params", c.getParams());
            }
            if ((ops = c.getOperations()) != null && ops.length != 0) {
                if (mapping.isEmpty()) {
                    return YamlAutomationRepresenter.this.representData(ops);
                }
                mapping.put("operations", ops);
            }
            return YamlAutomationRepresenter.this.representMapping(tag, mapping, null);
        }
    }
}

