/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter {
    protected PDDocument pdfDocument;
    protected PDDocument currentDocument = null;
    private int splitAtPage = 1;
    private int startPage = Integer.MIN_VALUE;
    private int endPage = Integer.MAX_VALUE;
    private List<PDDocument> newDocuments = null;
    protected int pageNumber = 0;

    public List<PDDocument> split(PDDocument document) throws IOException {
        this.newDocuments = new ArrayList<PDDocument>();
        this.pdfDocument = document;
        List pages = this.pdfDocument.getDocumentCatalog().getAllPages();
        this.processPages(pages);
        return this.newDocuments;
    }

    public void setSplitAtPage(int split) {
        if (split <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.splitAtPage = split;
    }

    public int getSplitAtPage() {
        return this.splitAtPage;
    }

    public void setStartPage(int start) {
        if (start <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.startPage = start;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setEndPage(int end) {
        if (end <= 0) {
            throw new RuntimeException("Error split must be at least one page.");
        }
        this.endPage = end;
    }

    public int getEndPage() {
        return this.endPage;
    }

    protected void processPages(List pages) throws IOException {
        for (PDPage page : pages) {
            if (this.pageNumber + 1 >= this.startPage && this.pageNumber + 1 <= this.endPage) {
                this.processNextPage(page);
                continue;
            }
            if (this.pageNumber > this.endPage) break;
            ++this.pageNumber;
        }
    }

    protected void createNewDocumentIfNecessary() throws IOException {
        if (this.isNewDocNecessary()) {
            this.createNewDocument();
        }
    }

    protected boolean isNewDocNecessary() {
        return this.pageNumber % this.splitAtPage == 0 || this.currentDocument == null;
    }

    protected void createNewDocument() throws IOException {
        this.currentDocument = new PDDocument();
        this.currentDocument.setDocumentInformation(this.pdfDocument.getDocumentInformation());
        this.currentDocument.getDocumentCatalog().setViewerPreferences(this.pdfDocument.getDocumentCatalog().getViewerPreferences());
        this.newDocuments.add(this.currentDocument);
    }

    protected void processNextPage(PDPage page) throws IOException {
        this.createNewDocumentIfNecessary();
        PDPage imported = this.currentDocument.importPage(page);
        imported.setCropBox(page.findCropBox());
        imported.setMediaBox(page.findMediaBox());
        imported.setResources(page.getResources());
        imported.setRotation(page.findRotation());
        this.processAnnotations(imported);
        ++this.pageNumber;
    }

    private void processAnnotations(PDPage imported) throws IOException {
        List<PDAnnotation> annotations = imported.getAnnotations();
        for (PDAnnotation annotation : annotations) {
            if (annotation instanceof PDAnnotationLink) {
                PDAction action;
                PDAnnotationLink link = (PDAnnotationLink)annotation;
                PDDestination destination = link.getDestination();
                if (destination == null && link.getAction() != null && (action = link.getAction()) instanceof PDActionGoTo) {
                    destination = ((PDActionGoTo)action).getDestination();
                }
                if (!(destination instanceof PDPageDestination)) continue;
                ((PDPageDestination)destination).setPage(null);
                continue;
            }
            annotation.setPage(null);
        }
    }
}

