/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.commons.text;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextTemplate {
    private static final Log log = LogFactory.getLog(TextTemplate.class);
    private static final Pattern PATTERN = Pattern.compile("(?<!\\$)\\$\\{([a-zA-Z_0-9\\-\\.]+)\\}");
    private static final int MAX_RECURSION_LEVEL = 10;
    private final Properties vars;
    private Properties processedVars;
    private boolean trim = false;
    private List<String> plainTextExtensions;
    private List<String> freemarkerExtensions = new ArrayList<String>();
    private Configuration freemarkerConfiguration = null;
    private Map<String, Object> freemarkerVars = null;
    private boolean extensionsContainsDot = false;

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public TextTemplate() {
        this.vars = new Properties();
        this.processedVars = new Properties();
    }

    @Deprecated
    public TextTemplate(Map<String, String> vars) {
        this.vars = new Properties();
        this.vars.putAll(vars);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public TextTemplate(Properties vars) {
        this.vars = vars;
        this.processedVars = this.preprocessVars(this.vars);
    }

    @Deprecated
    public void setVariables(Map<String, String> vars) {
        this.vars.putAll(vars);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public void setVariable(String name, String value) {
        this.vars.setProperty(name, value);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public String getVariable(String name) {
        return this.vars.getProperty(name);
    }

    public Properties getVariables() {
        return this.vars;
    }

    public Properties preprocessVars(Properties unprocessedVars) {
        Properties newVars = new Properties(unprocessedVars);
        boolean doneProcessing = false;
        int recursionLevel = 0;
        while (!doneProcessing) {
            doneProcessing = true;
            Enumeration<?> newVarsEnum = newVars.propertyNames();
            while (newVarsEnum.hasMoreElements()) {
                String newVarsKey = (String)newVarsEnum.nextElement();
                String newVarsValue = newVars.getProperty(newVarsKey);
                Matcher m = PATTERN.matcher(newVarsValue);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String embeddedVar = m.group(1);
                    String value = newVars.getProperty(embeddedVar);
                    if (value == null) continue;
                    if (this.trim) {
                        value = value.trim();
                    }
                    String escapedValue = Matcher.quoteReplacement(value);
                    m.appendReplacement(sb, escapedValue);
                }
                m.appendTail(sb);
                String replacementValue = sb.toString();
                if (replacementValue.equals(newVarsValue)) continue;
                doneProcessing = false;
                newVars.put(newVarsKey, replacementValue);
            }
            if (doneProcessing || ++recursionLevel <= 10) continue;
            break;
        }
        return this.unescape(newVars);
    }

    protected Properties unescape(Properties props) {
        for (Object key : props.keySet()) {
            props.put(key, this.unescape((String)props.get(key)));
        }
        return props;
    }

    protected String unescape(String value) {
        return value.replaceAll("\\$\\$", "\\$");
    }

    public String processText(CharSequence text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = this.getVariable(var);
            if (value == null) continue;
            if (this.trim) {
                value = value.trim();
            }
            String oldValue = value;
            int recursionLevel = 0;
            while (!(value = this.processText(oldValue)).equals(oldValue)) {
                oldValue = value;
                if (++recursionLevel <= 10) continue;
            }
            String valueL = Matcher.quoteReplacement(value);
            m.appendReplacement(sb, valueL);
        }
        m.appendTail(sb);
        return this.unescape(sb.toString());
    }

    public String processText(InputStream in) throws IOException {
        String text = IOUtils.toString((InputStream)in, (String)"UTF-8");
        return this.processText(text);
    }

    public void processText(InputStream is, OutputStream os) throws IOException {
        String text = IOUtils.toString((InputStream)is, (String)"UTF-8");
        text = this.processText(text);
        os.write(text.getBytes("UTF-8"));
    }

    public void initFreeMarker() {
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.freemarkerVars = new HashMap<String, Object>();
        Enumeration<?> processedEnum = this.processedVars.propertyNames();
        while (processedEnum.hasMoreElements()) {
            String key = (String)processedEnum.nextElement();
            String value = this.processedVars.getProperty(key);
            String[] keyparts = key.split("\\.");
            Map currentMap = this.freemarkerVars;
            String currentString = "";
            boolean setKeyVal = true;
            for (int i = 0; i < keyparts.length - 1; ++i) {
                currentString = currentString + (currentString.equals("") ? "" : ".") + keyparts[i];
                if (!currentMap.containsKey(keyparts[i])) {
                    HashMap<String, Object> nextMap = new HashMap<String, Object>();
                    currentMap.put((String)keyparts[i], nextMap);
                    currentMap = nextMap;
                    continue;
                }
                if (currentMap.get(keyparts[i]) instanceof Map) {
                    currentMap = (Map)currentMap.get(keyparts[i]);
                    continue;
                }
                if (!key.startsWith("java.vendor")) {
                    log.warn((Object)("FreeMarker templates: " + currentString + " is already defined - " + key + " will not be available in the data model."));
                }
                setKeyVal = false;
                break;
            }
            if (!setKeyVal) continue;
            currentMap.put((String)keyparts[keyparts.length - 1], (Object)value);
        }
    }

    public void processFreemarker(File in, File out) throws IOException, TemplateException {
        if (this.freemarkerConfiguration == null) {
            this.initFreeMarker();
        }
        this.freemarkerConfiguration.setDirectoryForTemplateLoading(in.getParentFile());
        Template nxtpl = this.freemarkerConfiguration.getTemplate(in.getName());
        try (EscapeVariableFilter writer = new EscapeVariableFilter(new FileWriter(out));){
            nxtpl.process(this.freemarkerVars, (Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> processDirectory(File in, File out) throws FileNotFoundException, IOException, TemplateException {
        ArrayList<String> newFiles;
        block19: {
            block15: {
                block20: {
                    boolean processAsText;
                    block18: {
                        String freemarkerExtension;
                        boolean processAsFreemarker;
                        block17: {
                            block16: {
                                newFiles = new ArrayList<String>();
                                if (!in.isFile()) break block15;
                                if (out.isDirectory()) {
                                    out = new File(out, in.getName());
                                }
                                if (!out.getParentFile().exists()) {
                                    out.getParentFile().mkdirs();
                                }
                                processAsText = false;
                                processAsFreemarker = false;
                                freemarkerExtension = null;
                                if (this.extensionsContainsDot) break block16;
                                int extIndex = in.getName().lastIndexOf(46);
                                String extension = extIndex == -1 ? "" : in.getName().substring(extIndex + 1).toLowerCase();
                                boolean bl = processAsText = this.plainTextExtensions == null || this.plainTextExtensions.contains(extension);
                                if (!this.freemarkerExtensions.contains(extension)) break block17;
                                processAsFreemarker = true;
                                freemarkerExtension = extension;
                                break block17;
                            }
                            String filename = in.getName().toLowerCase();
                            for (String ext : this.plainTextExtensions) {
                                if (!filename.endsWith(ext)) continue;
                                processAsText = true;
                                processAsFreemarker = false;
                                freemarkerExtension = ext;
                                break;
                            }
                            for (String ext : this.freemarkerExtensions) {
                                if (!filename.endsWith(ext)) continue;
                                processAsText = false;
                                processAsFreemarker = true;
                                break;
                            }
                        }
                        if (processAsFreemarker) {
                            out = new File(out.getCanonicalPath().replaceAll("\\.*" + Pattern.quote(freemarkerExtension) + "$", ""));
                        }
                        if (out.exists()) {
                            File backup = new File(out.getPath() + ".bak");
                            if (!backup.exists()) {
                                log.debug((Object)("Backup " + out));
                                FileUtils.copyFile((File)out, (File)backup);
                                newFiles.add(backup.getPath());
                            }
                        } else {
                            newFiles.add(out.getPath());
                        }
                        if (!processAsFreemarker) break block18;
                        log.debug((Object)("Process as FreeMarker " + in.getPath()));
                        this.processFreemarker(in, out);
                        break block19;
                    }
                    if (!processAsText) break block20;
                    log.debug((Object)("Process as Text " + in.getPath()));
                    FileInputStream is = null;
                    FileOutputStream os = null;
                    try {
                        is = new FileInputStream(in);
                        os = new FileOutputStream(out);
                        this.processText(is, os);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(os);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)os);
                    break block19;
                }
                log.debug((Object)("Process as copy " + in.getPath()));
                FileUtils.copyFile((File)in, (File)out);
                break block19;
            }
            if (in.isDirectory()) {
                if (!out.exists()) {
                    out.mkdirs();
                } else if (!out.getName().equals(in.getName())) {
                    out = new File(out, in.getName());
                    out.mkdir();
                }
                for (File file : in.listFiles()) {
                    newFiles.addAll(this.processDirectory(file, out));
                }
            }
        }
        return newFiles;
    }

    public void setTextParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.plainTextExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            this.plainTextExtensions.add(extension);
            if (this.extensionsContainsDot || !extension.contains(".")) continue;
            this.extensionsContainsDot = true;
        }
    }

    public void setFreemarkerParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.freemarkerExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            this.freemarkerExtensions.add(extension);
            if (this.extensionsContainsDot || !extension.contains(".")) continue;
            this.extensionsContainsDot = true;
        }
    }

    protected static class EscapeVariableFilter
    extends FilterWriter {
        protected static final int DOLLAR_SIGN = "$".codePointAt(0);
        protected int last;

        public EscapeVariableFilter(Writer out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (b == DOLLAR_SIGN && this.last == DOLLAR_SIGN) {
                return;
            }
            this.out.write(b);
            this.last = b;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }
    }
}

