/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractChart;
import org.richfaces.renderkit.ChartRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

@ResourceDependencies(value={@ResourceDependency(name="jsf.js", library="javax.faces", target=""), @ResourceDependency(name="jquery.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-queue.reslib", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-base-component.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-event.js", library="org.richfaces", target=""), @ResourceDependency(name="chart.js", library="org.richfaces", target=""), @ResourceDependency(name="chart.ecss", library="org.richfaces", target=""), @ResourceDependency(name="jquery.flot.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.categories.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.pie.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.time.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.axislabels.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.symbol.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.orderBars.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.tooltip.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.selection.js", library="flot", target=""), @ResourceDependency(name="jquery.flot.resize.js", library="flot", target="")})
public class ChartRenderer
extends ChartRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH14 = RenderKitUtils.attributes().generic("onplotclick", "onplotclick", new String[]{"plotclick"}).generic("onplothover", "onplothover", new String[]{"plothover"}).generic("onmouseout", "onmouseout", new String[]{"mouseout"});

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractChart component = (AbstractChart)uiComponent;
        String clientId = component.getClientId(facesContext);
        LinkedHashMap events = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(events, (FacesContext)facesContext, (UIComponent)component, (RenderKitUtils.Attributes)ATTRIBUTES_FOR_SCRIPT_HASH14, (RenderKitUtils.ScriptHashVariableWrapper)RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        responseWriter.startElement("div", (UIComponent)component);
        String value = ChartRenderer.convertToString(component.getStyleClass()) + " chart-container";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.startElement("div", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"chart-title", null);
        String text = component.getTitle();
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("div");
        responseWriter.startElement("div", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"chart", null);
        value = ChartRenderer.convertToString(clientId) + "Chart";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.endElement("div");
        responseWriter.startElement("script", (UIComponent)component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        text = "//\n\t                    \n\t                      new RichFaces.ui.Chart(\"" + ChartRenderer.convertToString(clientId) + "\", RichFaces.jQuery.extend({\n\t\t                                    handlers: RichFaces.jQuery.extend(" + ChartRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{events})) + "),\n\t\t                                    particularSeriesHandlers: " + ChartRenderer.convertToString(this.getParticularSeriesHandler(facesContext, (UIComponent)component)) + ",\n\t\t                                    data: " + ChartRenderer.convertToString(this.getChartData(facesContext, (UIComponent)component)) + ",\n\t                                    },\n\t                                    " + ChartRenderer.convertToString(this.getOpts(facesContext, (UIComponent)component)) + "\n\t                                   ));\n\t            //";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
        responseWriter.endElement("div");
    }
}

