/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractDragSource;
import org.richfaces.component.AbstractDropTarget;
import org.richfaces.event.DropEvent;
import org.richfaces.javascript.DnDScript;
import org.richfaces.javascript.DropScript;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.DnDRenderBase;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.util.Sets;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.core.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.widget.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.mouse.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.draggable.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.droppable.js"), @ResourceDependency(library="org.richfaces", name="dnd-droppable.js")})
public class DropTargetRenderer
extends DnDRenderBase {
    private static final Set<String> ALL_SET = Collections.singleton("@all");
    private static final Set<String> NONE_SET = Collections.singleton("@none");

    protected void doDecode(FacesContext facesContext, UIComponent component) {
        Map requestParamMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParamMap.get(component.getClientId(facesContext)) == null) {
            return;
        }
        String dragSourceId = (String)requestParamMap.get("dragSource");
        if (Strings.isNullOrEmpty((String)dragSourceId)) {
            return;
        }
        DragSourceContextCallBack dragSourceContextCallBack = new DragSourceContextCallBack();
        boolean invocationResult = facesContext.getViewRoot().invokeOnComponent(facesContext, dragSourceId, (ContextCallback)dragSourceContextCallBack);
        if (!invocationResult) {
            return;
        }
        AbstractDropTarget dropTarget = (AbstractDropTarget)component;
        new DropEvent((UIComponent)dropTarget, dropTarget.getDropValue(), (UIComponent)dragSourceContextCallBack.getDragSource(), dragSourceContextCallBack.getDragValue()).queue();
    }

    @Override
    public DnDScript createScript(String name) {
        return new DropScript(name);
    }

    @Override
    public Map<String, Object> getOptions(FacesContext facesContext, UIComponent component) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (component instanceof AbstractDropTarget) {
            JSReference dragSourceId = new JSReference("dragSourceId");
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{JSReference.EVENT, dragSourceId});
            AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((FacesContext)facesContext, (UIComponent)component);
            ajaxFunction.getOptions().setParameter("dragSource", (Object)dragSourceId);
            ajaxFunction.getOptions().setParameter(component.getClientId(facesContext), (Object)component.getClientId(facesContext));
            ajaxFunction.setSource((Object)new JSReference("event", (Object)"target"));
            ajaxFunction.getOptions().setAjaxComponent((Object)component.getClientId(facesContext));
            function.addToBody((Object)ajaxFunction);
            AbstractDropTarget dropTarget = (AbstractDropTarget)component;
            Set<String> acceptedTypes = Sets.asSet((Object)dropTarget.getAcceptedTypes());
            if (acceptedTypes != null) {
                if (acceptedTypes.contains("@none")) {
                    acceptedTypes = NONE_SET;
                } else if (acceptedTypes.contains("@all")) {
                    acceptedTypes = ALL_SET;
                }
            }
            options.put("acceptedTypes", acceptedTypes);
            options.put("ajaxFunction", function);
            options.put("parentId", this.getParentClientId(facesContext, component));
        }
        return options;
    }

    @Override
    public String getScriptName() {
        return "new RichFaces.ui.Droppable";
    }

    private final class DragSourceContextCallBack
    implements ContextCallback {
        private AbstractDragSource dragSource;
        private Object dragValue;

        private DragSourceContextCallBack() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (target instanceof AbstractDragSource) {
                this.dragSource = (AbstractDragSource)target;
                this.dragValue = this.dragSource.getDragValue();
            }
        }

        public AbstractDragSource getDragSource() {
            return this.dragSource;
        }

        public Object getDragValue() {
            return this.dragValue;
        }
    }
}

