/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;

public class NoteImporter
extends AbstractFileImporter {
    private static final Log log = LogFactory.getLog(NoteImporter.class);
    private static final String NOTE_TYPE = "Note";
    private static final String NOTE_SCHEMA = "note";
    private static final String NOTE_FIELD = "note";
    private static final String MT_FIELD = "mime_type";
    private static final long serialVersionUID = 1L;

    @Override
    public String getDefaultDocType() {
        return NOTE_TYPE;
    }

    @Override
    public boolean isOverwriteByTitle() {
        return true;
    }

    @Override
    public boolean updateDocumentIfPossible(DocumentModel doc, Blob content) {
        if (!doc.hasSchema("note")) {
            log.warn((Object)("Schema 'note' is not available for document " + doc));
            return false;
        }
        return super.updateDocumentIfPossible(doc, content);
    }

    @Override
    public void updateDocument(DocumentModel doc, Blob content) throws ClientException {
        String string;
        try {
            string = this.getString(content);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        doc.setProperty("note", "note", (Object)string);
        doc.setProperty("note", MT_FIELD, (Object)content.getMimeType());
    }

    protected String getString(Blob blob) throws IOException {
        String s = NoteImporter.guessEncoding(blob);
        if (s == null) {
            s = blob.getString();
        }
        return s;
    }

    protected static String guessEncoding(Blob blob) throws IOException {
        String charset2;
        if (blob.getEncoding() != null) {
            return null;
        }
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            return null;
        }
        if (!mimeType.startsWith("text/") && !mimeType.startsWith("application/xhtml")) {
            return null;
        }
        byte[] bytes = blob.getByteArray();
        ArrayList<String> charsets = new ArrayList<String>(Arrays.asList("utf-8", "iso-8859-1"));
        String CSEQ = "charset=";
        int i = mimeType.indexOf(CSEQ);
        if (i > 0) {
            String onlyMimeType = mimeType.substring(0, i).replace(";", "").trim();
            blob.setMimeType(onlyMimeType);
            charset2 = mimeType.substring(i + CSEQ.length());
            i = charset2.indexOf(";");
            if (i > 0) {
                charset2 = charset2.substring(0, i);
            }
            charset2 = charset2.trim().replace("\"", "");
            charsets.add(0, charset2);
        } else {
            CharsetMatch charsetMatch = new CharsetDetector().setText(bytes).detect();
            if (charsetMatch != null) {
                charset2 = charsetMatch.getName();
                charsets.add(0, charset2);
            }
        }
        for (String charset2 : charsets) {
            try {
                Charset cs = Charset.forName(charset2);
                CharsetDecoder d = cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer cb = d.decode(ByteBuffer.wrap(bytes));
                if (cb.length() != 0 && cb.charAt(0) == '\ufeff') {
                    cb = cb.subSequence(1, cb.length());
                }
                return cb.toString();
            }
            catch (IllegalArgumentException e) {
            }
            catch (CharacterCodingException e) {
            }
        }
        return null;
    }
}

