/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.util.MessageFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoResponseStateManagerImpl;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileMimetypeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileSizeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.UIOutputFile;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class UIInputFile
extends UIInput
implements NamingContainer {
    public static final String COMPONENT_TYPE = UIInputFile.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    protected static final String CHOICE_FACET_NAME = "choice";
    protected static final String UPLOAD_FACET_NAME = "upload";
    protected static final String DEFAULT_DOWNLOAD_FACET_NAME = "default_download";
    protected static final String DOWNLOAD_FACET_NAME = "download";
    protected static final String EDIT_FILENAME_FACET_NAME = "edit_filename";
    protected static final Log log = LogFactory.getLog(UIInputFile.class);

    public UIInputFile() {
        FacesContext faces = FacesContext.getCurrentInstance();
        Application app = faces.getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)this, DEFAULT_DOWNLOAD_FACET_NAME, app.createComponent(UIOutputFile.COMPONENT_TYPE));
        ComponentUtils.initiateSubComponent((UIComponent)this, EDIT_FILENAME_FACET_NAME, app.createComponent("javax.faces.HtmlInputText"));
        ComponentUtils.initiateSubComponent((UIComponent)this, UPLOAD_FACET_NAME, app.createComponent(faces, "javax.faces.HtmlInputFile", "javax.faces.NXFile"));
    }

    public String getRendererType() {
        return null;
    }

    public Object getValue() {
        Object localValue = this.getLocalValue();
        if (localValue != null) {
            return localValue;
        }
        Blob blob = null;
        Object originalValue = super.getValue();
        String mimeType = null;
        if (originalValue instanceof Blob) {
            blob = (Blob)originalValue;
            mimeType = blob.getMimeType();
        }
        List<InputFileChoice> choices = this.getAvailableChoices(blob, false);
        InputFileChoice choice = choices.get(0);
        return new InputFileInfo((Object)choice, blob, this.getFilename(), mimeType);
    }

    public String getFilename() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filename));
    }

    public void setFilename(String filename) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filename), (Object)filename);
    }

    public Boolean getEditFilename() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editFilename), (Object)Boolean.FALSE);
    }

    public void setEditFilename(Boolean editFilename) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editFilename), (Object)editFilename);
    }

    public InputFileInfo getFileInfoValue() {
        InputFileInfo res = this.getFileInfoSubmittedValue();
        if (res == null) {
            res = this.getPreviousFileInfoValue();
        }
        return res;
    }

    public InputFileInfo getFileInfoLocalValue() {
        return (InputFileInfo)this.getLocalValue();
    }

    public InputFileInfo getFileInfoSubmittedValue() {
        return (InputFileInfo)this.getSubmittedValue();
    }

    public InputFileInfo getPreviousFileInfoValue() {
        InputFileInfo res = this.getFileInfoLocalValue();
        if (res == null) {
            res = (InputFileInfo)this.getValue();
        }
        return res;
    }

    public String getOnchange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onchange));
    }

    public void setOnchange(String onchange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onchange), (Object)onchange);
    }

    public String getOnclick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onclick));
    }

    public void setOnclick(String onclick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onclick), (Object)onclick);
    }

    public String getOnselect() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onselect));
    }

    public void setOnselect(String onselect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onselect), (Object)onselect);
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.setValid(true);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        String choice = (String)requestMap.get(radioClientId);
        InputFileInfo submitted = new InputFileInfo(choice, null, null, null);
        if (InputFileChoice.tempKeep.name().equals(choice) || InputFileChoice.keep.name().equals(choice)) {
            InputFileInfo previous = this.getPreviousFileInfoValue();
            if (previous != null) {
                submitted.setBlob(previous.getConvertedBlob());
                submitted.setFilename(previous.getConvertedFilename());
                submitted.setMimeType(previous.getMimeType());
            }
        } else if (InputFileChoice.upload.name().equals(choice)) {
            this.decodeBlob(context, submitted);
            if (context.getRenderResponse()) {
                submitted.setChoice(InputFileChoice.tempKeep.name());
            }
        } else if (InputFileChoice.delete.name().equals(choice) || InputFileChoice.none.name().equals(choice)) {
            submitted.setBlob(null);
            submitted.setFilename(null);
            submitted.setMimeType(null);
        }
        this.setSubmittedValue(submitted);
    }

    public void validate(FacesContext context) {
        InputFileChoice choice;
        if (context == null) {
            throw new IllegalArgumentException();
        }
        InputFileInfo submitted = this.getFileInfoSubmittedValue();
        if (submitted == null) {
            return;
        }
        InputFileInfo toValidate = submitted.clone();
        try {
            choice = toValidate.getConvertedChoice();
        }
        catch (ConverterException ce) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
            this.setValid(false);
            return;
        }
        if (choice == null) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.choiceRequired");
            this.setValid(false);
            return;
        }
        toValidate.setChoice((Object)choice);
        InputFileInfo previous = this.getPreviousFileInfoValue();
        InputFileChoice previousChoice = previous.getConvertedChoice();
        boolean temp = InputFileChoice.tempKeep == previousChoice || InputFileChoice.upload == previousChoice;
        List<InputFileChoice> choices = this.getAvailableChoices(previous.getBlob(), temp);
        if (!choices.contains((Object)choice)) {
            ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.invalidChoice");
            this.setValid(false);
            return;
        }
        switch (choice) {
            case tempKeep: {
                if (this.isLocalValueSet()) {
                    toValidate.setBlob(previous.getConvertedBlob());
                    toValidate.setFilename(previous.getConvertedFilename());
                }
                this.validateBlob(context, toValidate);
                if (!this.getEditFilename().booleanValue()) break;
                this.validateFilename(context, toValidate);
                break;
            }
            case keep: {
                toValidate.setBlob(previous.getConvertedBlob());
                toValidate.setFilename(previous.getConvertedFilename());
                this.validateBlob(context, toValidate);
                if (!this.getEditFilename().booleanValue()) break;
                this.validateFilename(context, toValidate);
                break;
            }
            case upload: {
                this.validateBlob(context, toValidate);
                if (!this.isValid()) break;
                toValidate.setChoice((Object)InputFileChoice.tempKeep);
                break;
            }
            case delete: {
                toValidate.setBlob(null);
                toValidate.setFilename(null);
                break;
            }
            case none: {
                toValidate.setBlob(null);
                toValidate.setFilename(null);
            }
        }
        if (!this.isValid()) {
            return;
        }
        super.validateValue(context, (Object)toValidate);
        if (this.isValid()) {
            this.setValue(toValidate);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, toValidate)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, (Object)previous, (Object)toValidate));
            }
        }
    }

    protected void handleValidatorException(FacesContext context, ValidatorException ve) {
        this.setValid(false);
        Collection messages = ve.getFacesMessages();
        if (messages != null) {
            for (FacesMessage m : messages) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, m.getSummary());
            }
        } else {
            FacesMessage message = ve.getFacesMessage();
            if (message != null) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, message.getSummary());
            }
        }
    }

    public void validateFilename(FacesContext context, InputFileInfo submitted) {
        UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
        if (filenameFacet instanceof EditableValueHolder) {
            String filename;
            EditableValueHolder filenameComp = (EditableValueHolder)filenameFacet;
            submitted.setFilename(filenameComp.getLocalValue());
            try {
                filename = submitted.getConvertedFilename();
            }
            catch (ConverterException ce) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, ce.getMessage());
                this.setValid(false);
                return;
            }
            submitted.setFilename(filename);
        }
    }

    protected void decodeBlob(FacesContext context, InputFileInfo submitted) {
        UIComponent uploadFacet = this.getFacet(UPLOAD_FACET_NAME);
        if (uploadFacet instanceof HtmlInputFile) {
            HtmlInputFile uploadComp = (HtmlInputFile)uploadFacet;
            Object submittedFile = uploadComp.getSubmittedValue();
            if (submittedFile instanceof Blob) {
                Blob sblob = (Blob)submittedFile;
                submitted.setBlob(sblob);
                if (sblob != null) {
                    submitted.setFilename(sblob.getFilename());
                    submitted.setMimeType(sblob.getMimeType());
                }
            } else if (submittedFile == null) {
                submitted.setBlob(null);
                submitted.setFilename(null);
                submitted.setMimeType(null);
                submitted.setChoice(InputFileChoice.none.name());
            }
        }
    }

    public void validateBlob(FacesContext context, InputFileInfo submitted) {
        Blob blob = submitted.getConvertedBlob();
        if (blob != null && blob.getLength() == 0L) {
            submitted.setBlob(null);
            submitted.setFilename(null);
            submitted.setChoice(InputFileChoice.none.name());
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage(context, (UIComponent)this, message);
            this.setValid(false);
            return;
        }
    }

    public void updateFilename(FacesContext context, String newFilename) {
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            ve.setValue(context.getELContext(), (Object)newFilename);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            try {
                InputFileInfo local = this.getFileInfoLocalValue();
                InputFileChoice choice = local.getConvertedChoice();
                if (InputFileChoice.keep == choice && this.getEditFilename().booleanValue() || InputFileChoice.upload == choice || InputFileChoice.delete == choice || InputFileChoice.tempKeep == choice) {
                    // empty if block
                }
                if (InputFileChoice.upload == choice || InputFileChoice.delete == choice || InputFileChoice.tempKeep == choice) {
                    if (InputFileChoice.delete == choice) {
                        ValueExpression vef = this.getValueExpression("filename");
                        if (vef != null) {
                            vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                        }
                        ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                        this.setValue(null);
                        this.setLocalValueSet(false);
                    } else {
                        ve.setValue(context.getELContext(), (Object)local.getConvertedBlob());
                        this.setValue(null);
                        this.setLocalValueSet(false);
                        ValueExpression vef = this.getValueExpression("filename");
                        if (vef != null) {
                            vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                        }
                    }
                } else if (InputFileChoice.keep == choice) {
                    ValueExpression vef;
                    this.setValue(null);
                    this.setLocalValueSet(false);
                    if (this.getEditFilename().booleanValue() && (vef = this.getValueExpression("filename")) != null) {
                        vef.setValue(context.getELContext(), (Object)local.getConvertedFilename());
                    }
                }
                return;
            }
            catch (ELException e) {
                String messageStr = e.getMessage();
                for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)});
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = MessageFactory.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageFactory.getLabel((FacesContext)context, (UIComponent)this)});
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    protected List<InputFileChoice> getAvailableChoices(Object value, boolean temp) {
        ArrayList<InputFileChoice> choices = new ArrayList<InputFileChoice>();
        boolean hasFile = value != null;
        boolean isRequired = this.isRequired();
        if (!hasFile && isRequired) {
            choices.add(InputFileChoice.upload);
        } else if (!hasFile && !isRequired) {
            choices.add(InputFileChoice.none);
            choices.add(InputFileChoice.upload);
        } else if (hasFile && isRequired) {
            if (temp) {
                choices.add(InputFileChoice.tempKeep);
            } else {
                choices.add(InputFileChoice.keep);
            }
            choices.add(InputFileChoice.upload);
        } else if (hasFile && !isRequired) {
            if (temp) {
                choices.add(InputFileChoice.tempKeep);
            } else {
                choices.add(InputFileChoice.keep);
            }
            choices.add(InputFileChoice.upload);
            choices.add(InputFileChoice.delete);
        }
        return choices;
    }

    public Blob getCurrentBlob() {
        Blob blob = null;
        InputFileInfo ifi = this.getFileInfoValue();
        if (ifi != null) {
            blob = ifi.getConvertedBlob();
        }
        return blob;
    }

    public String getCurrentFilename() {
        String filename = null;
        InputFileInfo ifi = this.getFileInfoValue();
        if (ifi != null) {
            filename = ifi.getConvertedFilename();
        }
        return filename;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.notifyPreviousErrors(context);
        ResponseWriter writer = context.getResponseWriter();
        Blob blob = this.getCurrentBlob();
        String filename = this.getCurrentFilename();
        InputFileInfo fileInfo = this.getFileInfoValue();
        InputFileChoice currentChoice = fileInfo.getConvertedChoice();
        boolean temp = InputFileChoice.tempKeep == currentChoice;
        List<InputFileChoice> choices = this.getAvailableChoices(blob, temp);
        String radioClientId = this.getClientId(context) + ':' + CHOICE_FACET_NAME;
        writer.startElement("table", (UIComponent)this);
        writer.writeAttribute("class", (Object)"dataInput", null);
        writer.startElement("tbody", (UIComponent)this);
        writer.writeAttribute("class", this.getAttributes().get("styleClass"), null);
        for (InputFileChoice radioChoice : choices) {
            String onselect;
            String onclick;
            String onchange;
            String id = radioClientId + radioChoice.name();
            writer.startElement("tr", (UIComponent)this);
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"radioColumn", null);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "radio");
            props.put("name", radioClientId);
            props.put("id", id);
            props.put("value", radioChoice.name());
            if (radioChoice == currentChoice) {
                props.put("checked", "checked");
            }
            if ((onchange = this.getOnchange()) != null) {
                props.put("onchange", onchange);
            }
            if ((onclick = this.getOnclick()) != null) {
                props.put("onclick", onclick);
            }
            if ((onselect = this.getOnselect()) != null) {
                props.put("onselect", onselect);
            }
            StringBuffer htmlBuffer = new StringBuffer();
            htmlBuffer.append("<input");
            for (Map.Entry prop : props.entrySet()) {
                htmlBuffer.append(String.format(" %s=\"%s\"", prop.getKey(), prop.getValue()));
            }
            htmlBuffer.append(" />");
            writer.write(htmlBuffer.toString());
            writer.endElement("td");
            writer.startElement("td", (UIComponent)this);
            writer.writeAttribute("class", (Object)"fieldColumn", null);
            String html = "<label for=\"%s\" style=\"float:left\">%s</label>";
            String label = (String)ComponentUtils.getAttributeValue((UIComponent)this, (Object)((Object)radioChoice) + "Label", null);
            if (label == null) {
                label = ComponentUtils.translate(context, "label.inputFile." + (Object)((Object)radioChoice) + "Choice");
            }
            writer.write(String.format(html, id, label));
            writer.write("&#x0020;");
            if (InputFileChoice.keep == radioChoice || InputFileChoice.tempKeep == radioChoice) {
                UIComponent downloadFacet = this.getFacet(DOWNLOAD_FACET_NAME);
                if (downloadFacet != null) {
                    ComponentUtils.encodeComponent(context, downloadFacet);
                } else {
                    downloadFacet = this.getFacet(DEFAULT_DOWNLOAD_FACET_NAME);
                    if (downloadFacet != null) {
                        UIOutputFile downloadComp = (UIOutputFile)downloadFacet;
                        downloadComp.setQueryParent(true);
                        ComponentUtils.copyValues((UIComponent)this, (UIComponent)downloadComp, new String[]{"downloadLabel", "iconRendered"});
                        ComponentUtils.copyLinkValues((UIComponent)this, (UIComponent)downloadComp);
                        ComponentUtils.encodeComponent(context, (UIComponent)downloadComp);
                    }
                }
                if (this.getEditFilename().booleanValue()) {
                    writer.write("<br />");
                    UIComponent filenameFacet = this.getFacet(EDIT_FILENAME_FACET_NAME);
                    if (filenameFacet instanceof HtmlInputText) {
                        HtmlInputText filenameComp = (HtmlInputText)filenameFacet;
                        filenameComp.setValue((Object)filename);
                        filenameComp.setLocalValueSet(false);
                        String onClick = "document.getElementById('%s').checked='checked'";
                        filenameComp.setOnclick(String.format(onClick, id));
                        writer.write("&#x0020;");
                        html = "<label for=\"%s\">%s</label>";
                        label = (String)ComponentUtils.getAttributeValue((UIComponent)this, "editFilenameLabel", null);
                        if (label == null) {
                            label = ComponentUtils.translate(context, "label.inputFile.editFilename");
                        }
                        writer.write(String.format(html, filenameComp.getId(), label));
                        writer.write("&#x0020;");
                        ComponentUtils.encodeComponent(context, (UIComponent)filenameComp);
                    }
                }
            } else if (InputFileChoice.upload == radioChoice) {
                UIComponent uploadFacet;
                long sizeMax = 0L;
                String sizeConstraint = null;
                ArrayList<String> authorizedExtensions = new ArrayList<String>();
                ArrayList<String> unauthorizedExtensions = new ArrayList<String>();
                boolean hidden = false;
                for (Validator val : this.getValidators()) {
                    if (val instanceof InputFileSizeValidator) {
                        InputFileSizeValidator sizeVal = (InputFileSizeValidator)val;
                        long currentSizeMax = sizeVal.getMaxSizeBytes();
                        if (currentSizeMax <= sizeMax) continue;
                        sizeMax = currentSizeMax;
                        sizeConstraint = sizeVal.getMaxSize();
                        continue;
                    }
                    if (!(val instanceof InputFileMimetypeValidator)) continue;
                    InputFileMimetypeValidator extVal = (InputFileMimetypeValidator)val;
                    hidden = extVal.isHidden();
                    if (extVal.isAuthorized()) {
                        authorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
                        continue;
                    }
                    unauthorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
                }
                ArrayList<String> constraints = new ArrayList<String>();
                if (sizeConstraint != null) {
                    constraints.add(ComponentUtils.translate(context, "label.inputFile.maxSize", sizeConstraint));
                }
                if (!(hidden || authorizedExtensions.isEmpty() && unauthorizedExtensions.isEmpty())) {
                    if (!authorizedExtensions.isEmpty()) {
                        constraints.add(ComponentUtils.translate(context, "label.inputFile.authorizedExtensions", StringUtils.join((Object[])authorizedExtensions.toArray(), (String)", ")));
                    }
                    if (!unauthorizedExtensions.isEmpty()) {
                        constraints.add(ComponentUtils.translate(context, "label.inputFile.unauthorizedExtensions", StringUtils.join((Object[])unauthorizedExtensions.toArray(), (String)", ")));
                    }
                }
                if (constraints.size() > 0) {
                    writer.write("(");
                    writer.write(StringUtils.join((Object[])constraints.toArray(), (String)", "));
                    writer.write(")");
                    writer.write("&#x0020;");
                }
                if ((uploadFacet = this.getFacet(UPLOAD_FACET_NAME)) instanceof HtmlInputFile) {
                    HtmlInputFile uploadComp = (HtmlInputFile)uploadFacet;
                    String onClick = "document.getElementById('%s').checked='checked'";
                    uploadComp.setOnclick(String.format(onClick, id));
                    ComponentUtils.encodeComponent(context, (UIComponent)uploadComp);
                }
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        writer.flush();
    }

    private void notifyPreviousErrors(FacesContext context) {
        Object hasError = context.getAttributes().get("NX_MULTIPART_SIZE_ERROR");
        String componentId = (String)context.getAttributes().get(NuxeoResponseStateManagerImpl.MULTIPART_SIZE_ERROR_COMPONENT_ID);
        if (hasError != null && ((Boolean)hasError).booleanValue()) {
            if (StringUtils.isBlank((String)componentId)) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.maxRequestSize", new Object[]{Framework.getProperty((String)"nuxeo.jsf.maxRequestSize")});
            } else if (componentId.equals(this.getFacet(UPLOAD_FACET_NAME).getClientId())) {
                ComponentUtils.addErrorMessage(context, (UIComponent)this, "error.inputFile.maxSize", new Object[]{Framework.getProperty((String)"nuxeo.jsf.maxFileSize")});
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.getSubmittedValue()};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.setSubmittedValue(values[1]);
    }

    protected static enum PropertyKeys {
        filename,
        editFilename,
        onchange,
        onclick,
        onselect,
        submitted;

    }
}

