/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class DirectoryCacheRestlet
extends BaseNuxeoRestlet {
    private static final Log log = LogFactory.getLog(DirectoryCacheRestlet.class);
    public static final String DIRECTORY_NAME_QUERY_PARAM = "directory";

    public void handle(Request req, Response res) {
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        try {
            DirectoryService service = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            List<Directory> directories = new LinkedList();
            Form form = req.getResourceRef().getQueryAsForm();
            if (form.getNames().contains(DIRECTORY_NAME_QUERY_PARAM)) {
                String[] directoryNames;
                for (String directoryName : directoryNames = form.getValues(DIRECTORY_NAME_QUERY_PARAM).split(",")) {
                    Directory directory = service.getDirectory(directoryName);
                    if (directory == null) {
                        log.error((Object)("no such directory: " + directoryName));
                        continue;
                    }
                    directories.add(directory);
                }
            } else {
                directories = service.getDirectories();
            }
            Element invalidatedCachesElement = result.addElement("invalidatedCaches");
            for (Directory directory : directories) {
                directory.getCache().invalidateAll();
                invalidatedCachesElement.addElement(DIRECTORY_NAME_QUERY_PARAM).addText(directory.getName());
            }
        }
        catch (Exception e) {
            DirectoryCacheRestlet.handleError(res, e);
            return;
        }
        StringRepresentation rep = new StringRepresentation((CharSequence)result.asXML(), MediaType.APPLICATION_XML);
        rep.setCharacterSet(CharacterSet.UTF_8);
        res.setEntity((Representation)rep);
    }
}

