/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.contribs.RedisBlockingQueue;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.util.SafeEncoder;

public class RedisWorkQueuing
implements WorkQueuing {
    private static final Log log = LogFactory.getLog(RedisWorkQueuing.class);
    protected static final String UTF_8 = "UTF-8";
    protected static final String KEY_DATA = "data";
    protected static final String KEY_STATE = "state";
    protected static final String KEY_SUSPENDED_PREFIX = "prev:";
    protected static final String KEY_SCHEDULED_PREFIX = "queue:";
    protected static final String KEY_RUNNING_PREFIX = "run:";
    protected static final String KEY_COMPLETED_PREFIX = "done:";
    protected static final byte STATE_SCHEDULED_B = 81;
    protected static final byte STATE_CANCELED_B = 88;
    protected static final byte STATE_RUNNING_B = 82;
    protected static final byte STATE_COMPLETED_B = 67;
    protected static final byte[] STATE_SCHEDULED = new byte[]{81};
    protected static final byte[] STATE_CANCELED = new byte[]{88};
    protected static final byte[] STATE_RUNNING = new byte[]{82};
    protected static final byte[] STATE_COMPLETED = new byte[]{67};
    protected final WorkManagerImpl mgr;
    protected Map<String, BlockingQueue<Runnable>> allScheduled = new HashMap<String, BlockingQueue<Runnable>>();
    protected RedisExecutor redisExecutor;
    protected RedisAdmin redisAdmin;
    protected String redisNamespace;
    protected String delCompletedSha;
    private static final int BATCH_SIZE = 5000;

    public RedisWorkQueuing(WorkManagerImpl mgr, WorkQueueDescriptorRegistry workQueueDescriptors) {
        this.mgr = mgr;
    }

    public void init() {
        this.redisExecutor = (RedisExecutor)Framework.getLocalService(RedisExecutor.class);
        this.redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.redisNamespace = this.redisAdmin.namespace("work");
        try {
            for (String queueId : this.getSuspendedQueueIds()) {
                int n = this.scheduleSuspendedWork(queueId);
                log.info((Object)("Re-scheduling " + n + " work instances suspended from queue: " + queueId));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.delCompletedSha = this.redisAdmin.load("org.nuxeo.ecm.core.redis", "del-completed");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockingQueue<Runnable> initScheduleQueue(String queueId) {
        if (this.allScheduled.containsKey(queueId)) {
            throw new IllegalStateException(queueId + " is already configured");
        }
        BlockingQueue<Runnable> scheduled = this.newBlockingQueue(queueId);
        this.allScheduled.put(queueId, scheduled);
        return scheduled;
    }

    public BlockingQueue<Runnable> getScheduledQueue(String queueId) {
        if (!this.allScheduled.containsKey(queueId)) {
            throw new IllegalStateException(queueId + " was not configured yet");
        }
        return this.allScheduled.get(queueId);
    }

    public void workRunning(String queueId, Work work) {
        try {
            this.workSetRunning(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void workCompleted(String queueId, Work work) {
        try {
            this.workSetCompleted(queueId, work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected BlockingQueue<Runnable> newBlockingQueue(String queueId) {
        return new RedisBlockingQueue(queueId, this);
    }

    public List<Work> listWork(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.listScheduled(queueId);
            }
            case RUNNING: {
                return this.listRunning(queueId);
            }
            case COMPLETED: {
                return this.listCompleted(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    public List<String> listWorkIds(String queueId, Work.State state) {
        if (state == null) {
            return this.listNonCompletedIds(queueId);
        }
        switch (state) {
            case SCHEDULED: {
                return this.listScheduledIds(queueId);
            }
            case RUNNING: {
                return this.listRunningIds(queueId);
            }
            case COMPLETED: {
                return this.listCompletedIds(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    protected List<Work> listScheduled(String queueId) {
        try {
            return this.listWorkList(this.scheduledKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Work> listRunning(String queueId) {
        try {
            return this.listWorkSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Work> listCompleted(String queueId) {
        try {
            return this.listWorkSet(this.completedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listScheduledIds(String queueId) {
        try {
            return this.listWorkIdsList(this.scheduledKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listRunningIds(String queueId) {
        try {
            return this.listWorkIdsSet(this.runningKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> listNonCompletedIds(String queueId) {
        List<String> list = this.listScheduledIds(queueId);
        list.addAll(this.listRunningIds(queueId));
        return list;
    }

    protected List<String> listCompletedIds(String queueId) {
        try {
            return this.listWorkIdsSet(this.completedKey(queueId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getQueueSize(String queueId, Work.State state) {
        switch (state) {
            case SCHEDULED: {
                return this.getScheduledSize(queueId);
            }
            case RUNNING: {
                return this.getRunningSize(queueId);
            }
            case COMPLETED: {
                return this.getCompletedSize(queueId);
            }
        }
        throw new IllegalArgumentException(String.valueOf(state));
    }

    protected int getScheduledSize(String queueId) {
        try {
            return this.getScheduledQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getRunningSize(String queueId) {
        try {
            return this.getRunningQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getCompletedSize(String queueId) {
        try {
            return this.getCompletedQueueSize(queueId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Work find(String workId, Work.State state) {
        if (this.isWorkInState(workId, state)) {
            return this.getWork(this.bytes(workId));
        }
        return null;
    }

    public boolean isWorkInState(String workId, Work.State state) {
        Work.State s = this.getWorkState(workId);
        if (state == null) {
            return s == Work.State.SCHEDULED || s == Work.State.RUNNING;
        }
        return s == state;
    }

    public Work removeScheduled(String queueId, String workId) {
        try {
            return this.removeScheduledWork(queueId, workId);
        }
        catch (IOException cause) {
            throw new RuntimeException("Cannot remove scheduled work " + workId + " from " + queueId, cause);
        }
    }

    public Work.State getWorkState(String workId) {
        try {
            return this.getWorkStateInfo(workId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int setSuspending(String queueId) {
        try {
            int n = this.suspendScheduledWork(queueId);
            log.info((Object)("Suspending " + n + " work instances from queue: " + queueId));
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearCompletedWork(String queueId, long completionTime) {
        try {
            if (completionTime <= 0L) {
                this.removeAllCompletedWork(queueId);
            } else {
                this.removeCompletedWork(queueId, completionTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String string(byte[] bytes) {
        try {
            return new String(bytes, UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[] bytes(String string) {
        try {
            return string.getBytes(UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[] keyBytes(String prefix, String queueId) {
        return this.keyBytes(prefix + queueId);
    }

    protected byte[] keyBytes(String prefix) {
        return this.bytes(this.redisNamespace + prefix);
    }

    protected byte[] suspendedKey(String queueId) {
        return this.keyBytes(KEY_SUSPENDED_PREFIX, queueId);
    }

    protected byte[] scheduledKey(String queueId) {
        return this.keyBytes(KEY_SCHEDULED_PREFIX, queueId);
    }

    protected byte[] runningKey(String queueId) {
        return this.keyBytes(KEY_RUNNING_PREFIX, queueId);
    }

    protected byte[] completedKey(String queueId) {
        return this.keyBytes(KEY_COMPLETED_PREFIX, queueId);
    }

    protected String completedKeyString(String queueId) {
        return this.redisNamespace + KEY_COMPLETED_PREFIX + queueId;
    }

    protected byte[] stateKey() {
        return this.keyBytes(KEY_STATE);
    }

    protected String stateKeyString() {
        return this.redisNamespace + KEY_STATE;
    }

    protected byte[] dataKey() {
        return this.keyBytes(KEY_DATA);
    }

    protected String dataKeyString() {
        return this.redisNamespace + KEY_DATA;
    }

    protected byte[] serializeWork(Work work) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baout);
        out.writeObject(work);
        out.flush();
        out.close();
        return baout.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Work deserializeWork(byte[] workBytes) {
        if (workBytes == null) {
            return null;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(workBytes);
        try (ObjectInputStream in = new ObjectInputStream(bain);){
            Work work = (Work)in.readObject();
            return work;
        }
        catch (RuntimeException cause) {
            throw cause;
        }
        catch (Exception cause) {
            throw new RuntimeException("Cannot deserialize work", cause);
        }
    }

    protected int getScheduledQueueSize(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.llen(RedisWorkQueuing.this.scheduledKey(queueId));
            }
        }).intValue();
    }

    protected int getRunningQueueSize(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.scard(RedisWorkQueuing.this.runningKey(queueId));
            }
        }).intValue();
    }

    protected int getCompletedQueueSize(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.scard(RedisWorkQueuing.this.completedKey(queueId));
            }
        }).intValue();
    }

    public void addScheduledWork(final String queueId, Work work) throws IOException {
        log.debug((Object)("Add scheduled " + work));
        final byte[] workIdBytes = this.bytes(work.getId());
        final byte[] workBytes = this.serializeWork(work);
        this.redisExecutor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.hset(RedisWorkQueuing.this.dataKey(), workIdBytes, workBytes);
                jedis.hset(RedisWorkQueuing.this.stateKey(), workIdBytes, STATE_SCHEDULED);
                jedis.lpush(RedisWorkQueuing.this.scheduledKey(queueId), (byte[][])new byte[][]{workIdBytes});
                return null;
            }
        });
    }

    protected Set<String> getSuspendedQueueIds() throws IOException {
        return this.getQueueIds(KEY_SUSPENDED_PREFIX);
    }

    protected Set<String> getScheduledQueueIds() {
        try {
            return this.getQueueIds(KEY_SCHEDULED_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<String> getRunningQueueIds() {
        try {
            return this.getQueueIds(KEY_RUNNING_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getCompletedQueueIds() {
        try {
            return this.getQueueIds(KEY_COMPLETED_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Set<String> getQueueIds(final String queuePrefix) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Set<String>>(){

            @Override
            public Set<String> call(Jedis jedis) throws IOException {
                int offset = RedisWorkQueuing.this.keyBytes(queuePrefix).length;
                Set keys = jedis.keys(RedisWorkQueuing.this.keyBytes(queuePrefix, "*"));
                HashSet<String> queueIds = new HashSet<String>(keys.size());
                for (byte[] bytes : keys) {
                    String queueId = new String(bytes, offset, bytes.length - offset, RedisWorkQueuing.UTF_8);
                    queueIds.add(queueId);
                }
                return queueIds;
            }
        });
    }

    public int scheduleSuspendedWork(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Integer>(){

            @Override
            public Integer call(Jedis jedis) throws IOException {
                int n = 0;
                byte[] workIdBytes;
                while ((workIdBytes = jedis.rpoplpush(RedisWorkQueuing.this.suspendedKey(queueId), RedisWorkQueuing.this.scheduledKey(queueId))) != null) {
                    ++n;
                }
                return n;
            }
        });
    }

    public int suspendScheduledWork(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Integer>(){

            @Override
            public Integer call(Jedis jedis) throws IOException {
                int n = 0;
                byte[] workIdBytes;
                while ((workIdBytes = jedis.rpoplpush(RedisWorkQueuing.this.scheduledKey(queueId), RedisWorkQueuing.this.suspendedKey(queueId))) != null) {
                    ++n;
                }
                return n;
            }
        });
    }

    protected void workSetRunning(final String queueId, Work work) throws IOException {
        final byte[] workIdBytes = this.bytes(work.getId());
        this.redisExecutor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) throws IOException {
                jedis.sadd(RedisWorkQueuing.this.runningKey(queueId), (byte[][])new byte[][]{workIdBytes});
                jedis.hset(RedisWorkQueuing.this.stateKey(), workIdBytes, STATE_RUNNING);
                return null;
            }
        });
    }

    protected void workSetCompleted(final String queueId, final Work work) throws IOException {
        final byte[] workIdBytes = this.bytes(work.getId());
        final byte[] workBytes = this.serializeWork(work);
        this.redisExecutor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) throws IOException {
                jedis.hset(RedisWorkQueuing.this.dataKey(), workIdBytes, workBytes);
                jedis.srem(RedisWorkQueuing.this.runningKey(queueId), (byte[][])new byte[][]{workIdBytes});
                jedis.sadd(RedisWorkQueuing.this.completedKey(queueId), (byte[][])new byte[][]{workIdBytes});
                byte[] completedBytes = RedisWorkQueuing.this.bytes('C' + String.valueOf(work.getCompletionTime()));
                jedis.hset(RedisWorkQueuing.this.stateKey(), workIdBytes, completedBytes);
                return null;
            }
        });
    }

    protected Work.State getWorkStateInfo(final String workId) throws IOException {
        final byte[] workIdBytes = this.bytes(workId);
        return this.redisExecutor.execute(new RedisCallable<Work.State>(){

            @Override
            public Work.State call(Jedis jedis) throws IOException {
                byte[] bytes = jedis.hget(RedisWorkQueuing.this.stateKey(), workIdBytes);
                if (bytes == null || bytes.length == 0) {
                    return null;
                }
                switch (bytes[0]) {
                    case 81: {
                        return Work.State.SCHEDULED;
                    }
                    case 88: {
                        return Work.State.CANCELED;
                    }
                    case 82: {
                        return Work.State.RUNNING;
                    }
                    case 67: {
                        return Work.State.COMPLETED;
                    }
                }
                log.error((Object)("Unknown work state: " + new String(bytes, RedisWorkQueuing.UTF_8) + ", work: " + workId));
                return null;
            }
        });
    }

    protected List<String> listWorkIdsList(final byte[] queueBytes) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<List<String>>(){

            @Override
            public List<String> call(Jedis jedis) throws IOException {
                List keys = jedis.lrange(queueBytes, 0L, -1L);
                ArrayList<String> list = new ArrayList<String>(keys.size());
                for (byte[] workIdBytes : keys) {
                    list.add(RedisWorkQueuing.this.string(workIdBytes));
                }
                return list;
            }
        });
    }

    protected List<String> listWorkIdsSet(final byte[] queueBytes) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<List<String>>(){

            @Override
            public List<String> call(Jedis jedis) throws IOException {
                Set keys = jedis.smembers(queueBytes);
                ArrayList<String> list = new ArrayList<String>(keys.size());
                for (byte[] workIdBytes : keys) {
                    list.add(RedisWorkQueuing.this.string(workIdBytes));
                }
                return list;
            }
        });
    }

    protected List<Work> listWorkList(final byte[] queueBytes) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<List<Work>>(){

            @Override
            public List<Work> call(Jedis jedis) throws IOException {
                List keys = jedis.lrange(queueBytes, 0L, -1L);
                ArrayList<Work> list = new ArrayList<Work>(keys.size());
                for (byte[] workIdBytes : keys) {
                    byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                    Work work = RedisWorkQueuing.this.deserializeWork(workBytes);
                    list.add(work);
                }
                return list;
            }
        });
    }

    protected List<Work> listWorkSet(final byte[] queueBytes) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<List<Work>>(){

            @Override
            public List<Work> call(Jedis jedis) {
                Set keys = jedis.smembers(queueBytes);
                ArrayList<Work> list = new ArrayList<Work>(keys.size());
                for (byte[] workIdBytes : keys) {
                    byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                    Work work = RedisWorkQueuing.this.deserializeWork(workBytes);
                    list.add(work);
                }
                return list;
            }
        });
    }

    protected Work getWork(byte[] workIdBytes) {
        try {
            return this.getWorkData(workIdBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Work getWorkData(final byte[] workIdBytes) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Work>(){

            @Override
            public Work call(Jedis jedis) throws IOException {
                byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                return RedisWorkQueuing.this.deserializeWork(workBytes);
            }
        });
    }

    protected Work removeScheduledWork(final String queueId) throws IOException {
        return this.redisExecutor.execute(new RedisCallable<Work>(){

            @Override
            public Work call(Jedis jedis) throws IOException {
                byte[] workIdBytes = jedis.rpop(RedisWorkQueuing.this.scheduledKey(queueId));
                if (workIdBytes == null) {
                    return null;
                }
                byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                return RedisWorkQueuing.this.deserializeWork(workBytes);
            }
        });
    }

    protected Work removeScheduledWork(final String queueId, String workId) throws IOException {
        final byte[] workIdBytes = this.bytes(workId);
        return this.redisExecutor.execute(new RedisCallable<Work>(){

            @Override
            public Work call(Jedis jedis) throws IOException {
                Long n = jedis.lrem(RedisWorkQueuing.this.scheduledKey(queueId), 0L, workIdBytes);
                if (n == null || n.intValue() == 0) {
                    return null;
                }
                byte[] completedBytes = RedisWorkQueuing.this.bytes(String.valueOf(System.currentTimeMillis()));
                jedis.hset(RedisWorkQueuing.this.stateKey(), workIdBytes, completedBytes);
                byte[] workBytes = jedis.hget(RedisWorkQueuing.this.dataKey(), workIdBytes);
                return RedisWorkQueuing.this.deserializeWork(workBytes);
            }
        });
    }

    protected void removeAllCompletedWork(String queueId) throws IOException {
        this.removeCompletedWork(queueId, 0L);
    }

    protected void removeCompletedWork(final String queueId, final long completionTime) throws IOException {
        this.redisExecutor.execute(new RedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) throws IOException {
                String completedKey = RedisWorkQueuing.this.completedKeyString(queueId);
                String stateKey = RedisWorkQueuing.this.stateKeyString();
                String dataKey = RedisWorkQueuing.this.dataKeyString();
                SScanner sscanner = new SScanner();
                ScanParams scanParams = new ScanParams().count(5000);
                String cursor = "0";
                do {
                    ScanResult<String> scanResult = sscanner.sscan(jedis, completedKey, cursor, scanParams);
                    cursor = scanResult.getStringCursor();
                    List workIds = scanResult.getResult();
                    if (workIds.isEmpty()) continue;
                    List<String> keys = Arrays.asList(completedKey, stateKey, dataKey);
                    ArrayList<String> args = new ArrayList<String>(1 + workIds.size());
                    args.add(String.valueOf(completionTime));
                    args.addAll(workIds);
                    jedis.evalsha(RedisWorkQueuing.this.delCompletedSha, keys, args);
                } while (!"0".equals(cursor));
                return null;
            }
        });
    }

    public static class SScanner {
        protected List<String> smembers;

        protected ScanResult<String> sscan(Jedis jedis, String key, String cursor, ScanParams params) {
            ScanResult scanResult;
            block6: {
                try {
                    scanResult = jedis.sscan(key, cursor, params);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof NoSuchMethodException)) {
                        throw e;
                    }
                    if (this.smembers == null) {
                        Set set = jedis.smembers(key);
                        this.smembers = new ArrayList<String>(set);
                    }
                    Collection bparams = params.getParams();
                    int count = 1000;
                    Iterator it = bparams.iterator();
                    while (it.hasNext()) {
                        byte[] param = (byte[])it.next();
                        if (param.equals(Protocol.Keyword.MATCH.raw)) {
                            throw new UnsupportedOperationException("MATCH not supported");
                        }
                        if (!param.equals(Protocol.Keyword.COUNT.raw)) continue;
                        count = Integer.parseInt(SafeEncoder.encode((byte[])((byte[])it.next())));
                    }
                    int pos = Integer.parseInt(cursor);
                    int end = Math.min(pos + count, this.smembers.size());
                    int nextPos = end == this.smembers.size() ? 0 : end;
                    scanResult = new ScanResult(String.valueOf(nextPos), this.smembers.subList(pos, end));
                    if (nextPos != 0) break block6;
                    this.smembers = null;
                }
            }
            return scanResult;
        }
    }
}

