/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectDB2;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectDerby;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectH2;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectHSQLDB;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectMySQL;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectPostgreSQL;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectSQLServer;
import org.nuxeo.runtime.api.Framework;

public abstract class Dialect {
    public static final boolean DEBUG_UUIDS = false;
    public static final boolean DEBUG_REAL_UUIDS = false;
    private final AtomicLong temporaryIdCounter = new AtomicLong(0L);
    public static final String NULLS_LAST_ON_DESC_PROP = "nuxeo.vcs.use-nulls-last-on-desc";
    protected String descending;
    public static final String DIALECT_CLASS = "nuxeo.vcs.dialect";
    public static final Map<String, Class<? extends Dialect>> DIALECTS = new HashMap<String, Class<? extends Dialect>>();
    protected final BinaryManager binaryManager;
    protected final boolean storesUpperCaseIdentifiers;
    protected boolean fulltextDisabled;
    protected boolean fulltextSearchDisabled;
    protected final boolean aclOptimizationsEnabled;
    protected boolean clusteringEnabled;
    protected boolean softDeleteEnabled;
    protected boolean proxiesEnabled;
    protected final int readAclMaxSize;
    public static final String ARRAY_SEP = "|";
    protected static final char[] HEX_DIGITS;

    public static JDBCInfo jdbcInfo(String string, int jdbcType) {
        return new JDBCInfo(string, jdbcType);
    }

    public static JDBCInfo jdbcInfo(String string, int length, int jdbcType) {
        return new JDBCInfo(String.format(string, length), jdbcType);
    }

    public static JDBCInfo jdbcInfo(String string, int jdbcType, String jdbcBaseTypeString, int jdbcBaseType) {
        return new JDBCInfo(string, jdbcType, jdbcBaseTypeString, jdbcBaseType);
    }

    public static JDBCInfo jdbcInfo(String string, int length, int jdbcType, String jdbcBaseTypeString, int jdbcBaseType) {
        return new JDBCInfo(String.format(string, length), jdbcType, String.format(jdbcBaseTypeString, length), jdbcBaseType);
    }

    public static Dialect createDialect(Connection connection, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        Dialect dialect;
        Constructor<? extends Dialect> ctor;
        Class<Dialect> dialectClass;
        String dialectClassName;
        String databaseName;
        DatabaseMetaData metadata;
        try {
            metadata = connection.getMetaData();
            databaseName = metadata.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        if (databaseName.contains("/")) {
            databaseName = databaseName.substring(0, databaseName.indexOf(47));
        }
        if ((dialectClassName = Framework.getProperty((String)DIALECT_CLASS)) == null) {
            dialectClassName = Framework.getProperty((String)("nuxeo.vcs.dialect." + databaseName.replace(" ", "")));
        }
        if (dialectClassName == null) {
            dialectClass = DIALECTS.get(databaseName);
            if (dialectClass == null) {
                throw new StorageException("Unsupported database: " + databaseName);
            }
        } else {
            Class<?> klass;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                klass = cl.loadClass(dialectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new StorageException(e);
            }
            if (!Dialect.class.isAssignableFrom(klass)) {
                throw new StorageException("Not a Dialect: " + dialectClassName);
            }
            dialectClass = klass;
        }
        try {
            ctor = dialectClass.getConstructor(DatabaseMetaData.class, BinaryManager.class, RepositoryDescriptor.class);
        }
        catch (Exception e) {
            throw new StorageException("Bad constructor signature for: " + dialectClassName, e);
        }
        try {
            dialect = ctor.newInstance(metadata, binaryManager, repositoryDescriptor);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof StorageException) {
                throw (StorageException)((Object)t);
            }
            throw new StorageException(t.getMessage(), t);
        }
        catch (Exception e) {
            throw new StorageException("Cannot construct dialect: " + dialectClassName, e);
        }
        return dialect;
    }

    public Dialect(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        try {
            this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new StorageException("An error has occured.", e);
        }
        this.binaryManager = binaryManager;
        if (repositoryDescriptor == null) {
            this.fulltextDisabled = true;
            this.fulltextSearchDisabled = true;
            this.aclOptimizationsEnabled = false;
            this.readAclMaxSize = 0;
            this.clusteringEnabled = false;
            this.softDeleteEnabled = false;
            this.proxiesEnabled = true;
        } else {
            this.fulltextDisabled = repositoryDescriptor.getFulltextDisabled();
            this.fulltextSearchDisabled = repositoryDescriptor.getFulltextSearchDisabled();
            this.aclOptimizationsEnabled = repositoryDescriptor.getAclOptimizationsEnabled();
            this.readAclMaxSize = repositoryDescriptor.getReadAclMaxSize();
            this.clusteringEnabled = repositoryDescriptor.getClusteringEnabled();
            this.softDeleteEnabled = repositoryDescriptor.getSoftDeleteEnabled();
            this.proxiesEnabled = repositoryDescriptor.getProxiesEnabled();
        }
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public String getConnectionSchema(Connection connection) throws SQLException {
        return null;
    }

    public abstract JDBCInfo getJDBCTypeAndString(ColumnType var1);

    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        return false;
    }

    public Serializable getGeneratedId(Connection connection) throws SQLException {
        return UUID.randomUUID().toString();
    }

    public void setId(PreparedStatement ps, int index, Serializable value) throws SQLException {
        ps.setObject(index, value);
    }

    public void setIdLong(PreparedStatement ps, int index, Serializable value) throws SQLException {
        long l;
        if (value instanceof String) {
            try {
                l = Long.parseLong((String)((Object)value));
            }
            catch (NumberFormatException e) {
                throw new SQLException("Invalid long id: " + value);
            }
        } else if (value instanceof Long) {
            l = (Long)value;
        } else {
            throw new SQLException("Unsupported class for long id, class: " + value.getClass() + " value: " + value);
        }
        ps.setLong(index, l);
    }

    public abstract void setToPreparedStatement(PreparedStatement var1, int var2, Serializable var3, Column var4) throws SQLException;

    protected void setToPreparedStatementString(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        String v;
        ColumnType type = column.getType();
        if (type == ColumnType.BLOBID) {
            v = ((Binary)value).getDigest();
        } else if (type == ColumnType.SYSNAMEARRAY) {
            String[] strings = (String[])value;
            if (strings == null) {
                v = null;
            } else {
                StringBuilder buf = new StringBuilder(ARRAY_SEP);
                for (String string : strings) {
                    buf.append(string);
                    buf.append(ARRAY_SEP);
                }
                v = buf.toString();
            }
        } else {
            v = (String)((Object)value);
        }
        ps.setString(index, v);
    }

    public void setToPreparedStatementTimestamp(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        Calendar cal = (Calendar)value;
        Timestamp ts = cal == null ? null : new Timestamp(cal.getTimeInMillis());
        ps.setTimestamp(index, ts, cal);
    }

    public Timestamp getTimestampFromCalendar(Calendar value) {
        return new Timestamp(value.getTimeInMillis());
    }

    public Timestamp[] getTimestampFromCalendar(Serializable[] value) {
        if (value == null) {
            return null;
        }
        Timestamp[] ts = new Timestamp[value.length];
        for (int i = 0; i < value.length; ++i) {
            ts[i] = this.getTimestampFromCalendar((Calendar)value[i]);
        }
        return ts;
    }

    public Calendar getCalendarFromTimestamp(Timestamp value) {
        if (value == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(value.getTime());
        return cal;
    }

    public Calendar[] getCalendarFromTimestamp(Timestamp[] value) {
        if (value == null) {
            return null;
        }
        Calendar[] cal = new GregorianCalendar[value.length];
        for (int i = 0; i < value.length; ++i) {
            cal[i] = this.getCalendarFromTimestamp(value[i]);
        }
        return cal;
    }

    public abstract Serializable getFromResultSet(ResultSet var1, int var2, Column var3) throws SQLException;

    protected Serializable getFromResultSetString(ResultSet rs, int index, Column column) throws SQLException {
        String string = rs.getString(index);
        if (string == null) {
            return null;
        }
        ColumnType type = column.getType();
        if (type == ColumnType.BLOBID) {
            return this.getBinaryManager().getBinary(string);
        }
        if (type == ColumnType.SYSNAMEARRAY) {
            if (string.startsWith(ARRAY_SEP)) {
                string = string.substring(ARRAY_SEP.length());
            }
            return string.split(Pattern.quote(ARRAY_SEP));
        }
        return string;
    }

    protected Serializable getFromResultSetTimestamp(ResultSet rs, int index, Column column) throws SQLException {
        Timestamp ts = rs.getTimestamp(index);
        if (ts == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeInMillis(ts.getTime());
        return cal;
    }

    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    protected int getMaxNameSize() {
        return 999;
    }

    protected int getMaxIndexNameSize() {
        return this.getMaxNameSize();
    }

    protected String makeName(String name, int maxNameSize) {
        if (name.length() > maxNameSize) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString(), e);
            }
            byte[] bytes = name.getBytes();
            digest.update(bytes, 0, bytes.length);
            name = name.substring(0, maxNameSize - 1 - 8);
            name = name + '_' + Dialect.toHexString(digest.digest()).substring(0, 8);
        }
        name = this.storesUpperCaseIdentifiers() ? name.toUpperCase() : name.toLowerCase();
        name = name.replace(':', '_');
        return name;
    }

    protected String makeName(String prefix, String string, String suffix, int maxNameSize) {
        String name = prefix + string + suffix;
        if (name.length() > maxNameSize) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString(), e);
            }
            byte[] bytes = (prefix + string).getBytes();
            digest.update(bytes, 0, bytes.length);
            name = prefix.substring(0, 4);
            name = name + '_' + Dialect.toHexString(digest.digest()).substring(0, 8);
            name = name + suffix;
        }
        name = this.storesUpperCaseIdentifiers() ? name.toUpperCase() : name.toLowerCase();
        name = name.replace(':', '_');
        return name;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    public String getTableName(String name) {
        return this.makeName(name, this.getMaxNameSize());
    }

    public String getColumnName(String name) {
        return this.makeName(name, this.getMaxNameSize());
    }

    public String getPrimaryKeyConstraintName(String tableName) {
        return this.makeName(tableName, "", "_PK", this.getMaxNameSize());
    }

    public String getForeignKeyConstraintName(String tableName, String foreignColumnName, String foreignTableName) {
        return this.makeName(tableName + '_', foreignColumnName + '_' + foreignTableName, "_FK", this.getMaxNameSize());
    }

    public String getIndexName(String tableName, List<String> columnNames) {
        return this.makeName(this.qualifyIndexName() ? tableName + '_' : "", StringUtils.join(columnNames, (char)'_'), "_IDX", this.getMaxIndexNameSize());
    }

    public String getCreateIndexSql(String indexName, Table.IndexType indexType, Table table, List<Column> columns, Model model) {
        ArrayList<String> qcols = new ArrayList<String>(columns.size());
        ArrayList<String> pcols = new ArrayList<String>(columns.size());
        for (Column col : columns) {
            qcols.add(col.getQuotedName());
            pcols.add(col.getPhysicalName());
        }
        String quotedIndexName = this.openQuote() + this.getIndexName(table.getKey(), pcols) + this.closeQuote();
        if (indexType == Table.IndexType.FULLTEXT) {
            return this.getCreateFulltextIndexSql(indexName, quotedIndexName, table, columns, model);
        }
        return String.format("CREATE INDEX %s ON %s (%s)", quotedIndexName, table.getQuotedName(), StringUtils.join(qcols, (String)", "));
    }

    public abstract int getFulltextIndexedColumns();

    public boolean supportsMultipleFulltextIndexes() {
        return true;
    }

    public abstract boolean getMaterializeFulltextSyntheticColumn();

    public abstract String getCreateFulltextIndexSql(String var1, String var2, Table var3, List<Column> var4, Model var5);

    public abstract String getDialectFulltextQuery(String var1);

    public abstract FulltextMatchInfo getFulltextScoredMatchInfo(String var1, String var2, int var3, Column var4, Model var5, Database var6);

    public String getLikeEscaping() {
        return null;
    }

    public String getMatchMixinType(Column mixinsColumn, String mixin, boolean positive, String[] returnParam) {
        returnParam[0] = "%|" + mixin + ARRAY_SEP + "%";
        return String.format("%s %s ?", mixinsColumn.getFullQuotedName(), positive ? "LIKE" : "NOT LIKE");
    }

    public boolean supportsPaging() {
        return false;
    }

    public String addPagingClause(String sql, long limit, long offset) {
        throw new UnsupportedOperationException("paging is not supported");
    }

    public int getFulltextType() {
        return 2005;
    }

    public String getFreeVariableSetterForType(ColumnType type) {
        return "?";
    }

    public String getNoColumnsInsertString() {
        return "VALUES ( )";
    }

    public String getNullColumnString() {
        return "";
    }

    public String getTableTypeString(Table table) {
        return "";
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return String.format(" ADD CONSTRAINT %s PRIMARY KEY ", constraintName);
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKeys, String referencedTable, String[] primaryKeys, boolean referencesPrimaryKey) {
        String sql = String.format(" ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s", constraintName, StringUtils.join((Object[])foreignKeys, (String)", "), referencedTable);
        if (!referencesPrimaryKey) {
            sql = sql + " (" + StringUtils.join((Object[])primaryKeys, (String)", ") + ')';
        }
        return sql;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getCascadeDropConstraintsString() {
        return "";
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    public abstract boolean supportsUpdateFrom();

    public abstract boolean doesUpdateFromRepeatSelf();

    public boolean needsOrderByKeysAfterDistinct() {
        return true;
    }

    public boolean needsAliasForDerivedTable() {
        return false;
    }

    public boolean needsOriginalColumnInGroupBy() {
        return false;
    }

    public boolean needsOracleJoins() {
        return false;
    }

    public boolean needsPrepareUserReadAcls() {
        return this.supportsReadAcl();
    }

    public boolean needsNullsLastOnDescSort() {
        return false;
    }

    public String getClobCast(boolean inOrderBy) {
        return null;
    }

    public String getDateCast() {
        return "CAST(%s AS DATE)";
    }

    public String castIdToVarchar(String expr) {
        return expr;
    }

    public DialectIdType getIdType() {
        return DialectIdType.VARCHAR;
    }

    public abstract String getSecurityCheckSql(String var1);

    public boolean supportsAncestorsTable() {
        return false;
    }

    public boolean supportsFastDescendants() {
        return false;
    }

    public abstract String getInTreeSql(String var1, String var2);

    public boolean supportsArrays() {
        return false;
    }

    public boolean supportsArraysReturnInsteadOfRows() {
        return false;
    }

    public Serializable[] getArrayResult(Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSysNameArray() {
        return false;
    }

    public boolean supportsArrayColumns() {
        return false;
    }

    public ArraySubQuery getArraySubQuery(Column arrayColumn, String subQueryAlias) throws QueryMaker.QueryMakerException {
        throw new QueryMaker.QueryMakerException("Not supported");
    }

    public String getArrayElementString(String arrayColumnName, int arrayElementIndex) throws QueryMaker.QueryMakerException {
        throw new QueryMaker.QueryMakerException("Not supported");
    }

    public String getArrayInSql(Column arrayColumn, String cast, boolean positive, List<Serializable> params) throws QueryMaker.QueryMakerException {
        throw new QueryMaker.QueryMakerException("Not supported");
    }

    public String getArrayLikeSql(Column arrayColumn, String refName, boolean positive, Table dataHierTable) throws QueryMaker.QueryMakerException {
        throw new QueryMaker.QueryMakerException("Not supported");
    }

    public String getArrayIlikeSql(Column arrayColumn, String refName, boolean positive, Table dataHierTable) throws QueryMaker.QueryMakerException {
        throw new QueryMaker.QueryMakerException("Not supported");
    }

    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        throw new SQLException("Not supported");
    }

    public abstract String getSQLStatementsFilename();

    public abstract String getTestSQLStatementsFilename();

    public abstract Map<String, Serializable> getSQLStatementsProperties(Model var1, Database var2);

    public boolean isClusteringSupported() {
        return false;
    }

    public boolean isClusteringDeleteNeeded() {
        return false;
    }

    public String getClusterInsertInvalidations() {
        return null;
    }

    public String getClusterGetInvalidations() {
        return null;
    }

    public boolean supportsIlike() {
        return false;
    }

    public boolean supportsReadAcl() {
        return false;
    }

    public boolean supportsWith() {
        return false;
    }

    public boolean hasNullEmptyString() {
        return false;
    }

    public int getMaximumArgsForIn() {
        return 400;
    }

    public String getUpdateReadAclsSql() {
        return null;
    }

    public String getRebuildReadAclsSql() {
        return null;
    }

    public String getReadAclsCheckSql(String userIdCol) {
        return null;
    }

    public String getPrepareUserReadAclsSql() {
        return null;
    }

    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        return true;
    }

    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        return Collections.emptyList();
    }

    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
    }

    public boolean isConnectionClosedException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SocketException;
    }

    public boolean isConcurrentUpdateException(Throwable t) {
        return false;
    }

    public void performAdditionalStatements(Connection connection) throws SQLException {
    }

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public String getBlobLengthFunction() {
        return "OCTET_LENGTH";
    }

    public void performPostOpenStatements(Connection connection) throws SQLException {
    }

    public List<String> getPostCreateIdentityColumnSql(Column column) {
        return Collections.emptyList();
    }

    public boolean isIdentityAlreadyPrimary() {
        return false;
    }

    public boolean hasIdentityGeneratedKey() {
        return true;
    }

    public String getIdentityGeneratedKeySql(Column column) {
        return null;
    }

    public String getAncestorsIdsSql() {
        return null;
    }

    public String getDescending() {
        if (this.descending == null) {
            this.descending = this.needsNullsLastOnDescSort() && Boolean.parseBoolean(Framework.getProperty((String)NULLS_LAST_ON_DESC_PROP, (String)"true")) ? " DESC NULLS LAST" : " DESC";
        }
        return this.descending;
    }

    public List<String> getIgnoredColumns(Table table) {
        return Collections.emptyList();
    }

    public String getCustomColumnDefinition(Table table) {
        return null;
    }

    public List<String> getCustomPostCreateSqls(Table table) {
        return Collections.emptyList();
    }

    public String getSoftDeleteSql() {
        throw new UnsupportedOperationException("Soft deletes not supported");
    }

    public String getSoftDeleteCleanupSql() {
        throw new UnsupportedOperationException("Soft deletes not supported");
    }

    public String getBinaryFulltextSql(List<String> columns) {
        return "SELECT " + StringUtils.join(columns, (String)", ") + " FROM fulltext WHERE id=?";
    }

    static {
        DIALECTS.put("H2", DialectH2.class);
        DIALECTS.put("MySQL", DialectMySQL.class);
        DIALECTS.put("Oracle", DialectOracle.class);
        DIALECTS.put("PostgreSQL", DialectPostgreSQL.class);
        DIALECTS.put("Microsoft SQL Server", DialectSQLServer.class);
        DIALECTS.put("HSQL Database Engine", DialectHSQLDB.class);
        DIALECTS.put("Apache Derby", DialectDerby.class);
        DIALECTS.put("DB2", DialectDB2.class);
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    public static abstract class ArraySubQuery {
        protected Column arrayColumn;
        protected String subQueryAlias;

        public ArraySubQuery(Column arrayColumn, String subqueryAlias) {
            this.arrayColumn = arrayColumn;
            this.subQueryAlias = subqueryAlias;
        }

        public abstract Column getSubQueryIdColumn();

        public abstract Column getSubQueryValueColumn();

        public abstract String toSql();
    }

    public static class FulltextMatchInfo {
        public List<Join> joins;
        public String whereExpr;
        public String whereExprParam;
        public String scoreExpr;
        public String scoreExprParam;
        public String scoreAlias;
        public Column scoreCol;
    }

    public static enum DialectIdType {
        VARCHAR,
        UUID,
        SEQUENCE;

    }

    public static final class JDBCInfo {
        public final String string;
        public final int jdbcType;
        public final String jdbcBaseTypeString;
        public final int jdbcBaseType;

        public JDBCInfo(String string, int jdbcType) {
            this(string, jdbcType, null, 0);
        }

        public JDBCInfo(String string, int jdbcType, String jdbcBaseTypeString, int jdbcBaseType) {
            this.string = string;
            this.jdbcType = jdbcType;
            this.jdbcBaseTypeString = jdbcBaseTypeString;
            this.jdbcBaseType = jdbcBaseType;
        }
    }
}

