/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectDB2
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectDB2.class);
    protected final String fulltextParameters;
    private static final String DEFAULT_USERS_SEPARATOR = "|";
    protected String usersSeparator;

    public DialectDB2(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        String string = repositoryDescriptor == null ? null : (this.fulltextParameters = repositoryDescriptor.fulltextAnalyzer == null ? "" : repositoryDescriptor.fulltextAnalyzer);
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        this.fulltextDisabled = true;
        if (repositoryDescriptor != null) {
            repositoryDescriptor.setFulltextDisabled(true);
        }
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return " CASCADE";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectDB2.jdbcInfo("VARCHAR(255)", 12);
                }
                if (type.isClob() || type.length > 2000) {
                    return DialectDB2.jdbcInfo("CLOB", 2005);
                }
                return DialectDB2.jdbcInfo("VARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectDB2.jdbcInfo("SMALLINT", -7);
            }
            case LONG: {
                return DialectDB2.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectDB2.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return DialectDB2.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectDB2.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectDB2.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectDB2.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return DialectDB2.jdbcInfo("SMALLINT", -6);
            }
            case INTEGER: {
                return DialectDB2.jdbcInfo("INTEGER", 4);
            }
            case AUTOINC: {
                return DialectDB2.jdbcInfo("INTEGER", 4);
            }
            case FTINDEXED: {
                return DialectDB2.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return DialectDB2.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectDB2.jdbcInfo("VARCHAR(25)", 12);
            }
            case CLUSTERFRAGS: {
                return DialectDB2.jdbcInfo("VARCHAR(4000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        return expected == -7 && actual == 5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setInt(index, (Boolean)value != false ? 1 : 0);
                return;
            }
            case -6: 
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 128;
    }

    @Override
    public boolean supportsReadAcl() {
        return false;
    }

    @Override
    public boolean isClusteringSupported() {
        return false;
    }

    @Override
    public boolean supportsPaging() {
        return false;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return null;
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/db2.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/db2.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR(36)"));
        properties.put("argIdType", (Serializable)((Object)"VARCHAR(36)"));
        return properties;
    }

    @Override
    public String getValidationQuery() {
        return "VALUES 1";
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsUpdateFrom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }
}

