/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.ExtensionDescriptor;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;

public class MimetypeRegistryService
extends DefaultComponent
implements MimetypeRegistry {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService");
    public static final long MAX_SIZE_FOR_SCAN = 0xA00000L;
    private static final Log log = LogFactory.getLog(MimetypeRegistryService.class);
    protected Map<String, MimetypeEntry> mimetypeByNormalisedRegistry;
    protected Map<String, MimetypeEntry> mimetypeByExtensionRegistry;
    protected Map<String, ExtensionDescriptor> extensionRegistry;
    private RuntimeContext bundle;

    public MimetypeRegistryService() {
        this.initializeRegistries();
    }

    protected void initializeRegistries() {
        this.mimetypeByNormalisedRegistry = new HashMap<String, MimetypeEntry>();
        this.mimetypeByExtensionRegistry = new HashMap<String, MimetypeEntry>();
        this.extensionRegistry = new HashMap<String, ExtensionDescriptor>();
    }

    public void activate(ComponentContext context) {
        this.bundle = context.getRuntimeContext();
        this.initializeRegistries();
    }

    public void deactivate(ComponentContext context) {
        this.mimetypeByNormalisedRegistry = null;
        this.mimetypeByExtensionRegistry = null;
        this.extensionRegistry = null;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof MimetypeDescriptor) {
                MimetypeDescriptor mimetypeDescriptor = (MimetypeDescriptor)contrib;
                this.registerMimetype(mimetypeDescriptor.getMimetype());
                continue;
            }
            if (!(contrib instanceof ExtensionDescriptor)) continue;
            this.registerFileExtension((ExtensionDescriptor)contrib);
        }
    }

    public void registerMimetype(MimetypeEntry mimetype) {
        log.debug((Object)("Registering mimetype: " + mimetype.getNormalized()));
        this.mimetypeByNormalisedRegistry.put(mimetype.getNormalized(), mimetype);
        for (String extension : mimetype.getExtensions()) {
            this.mimetypeByExtensionRegistry.put(extension, mimetype);
        }
    }

    public void registerFileExtension(ExtensionDescriptor extensionDescriptor) {
        log.debug((Object)("Registering file extension: " + extensionDescriptor.getName()));
        this.extensionRegistry.put(extensionDescriptor.getName(), extensionDescriptor);
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof MimetypeDescriptor) {
                MimetypeDescriptor mimetypeDescriptor = (MimetypeDescriptor)contrib;
                this.unregisterMimetype(mimetypeDescriptor.getNormalized());
                continue;
            }
            if (!(contrib instanceof ExtensionDescriptor)) continue;
            ExtensionDescriptor extensionDescriptor = (ExtensionDescriptor)contrib;
            this.unregisterFileExtension(extensionDescriptor);
        }
    }

    public void unregisterMimetype(String mimetypeName) {
        log.debug((Object)("Unregistering mimetype: " + mimetypeName));
        MimetypeEntry mimetype = this.mimetypeByNormalisedRegistry.get(mimetypeName);
        if (mimetype == null) {
            return;
        }
        List extensions = mimetype.getExtensions();
        this.mimetypeByNormalisedRegistry.remove(mimetypeName);
        for (String extension : extensions) {
            if (!mimetype.getNormalized().equals(this.mimetypeByExtensionRegistry.get(extension))) continue;
            this.mimetypeByExtensionRegistry.remove(extension);
        }
    }

    public void unregisterFileExtension(ExtensionDescriptor extensionDescriptor) {
        log.debug((Object)("Unregistering file extension: " + extensionDescriptor.getName()));
        this.extensionRegistry.remove(extensionDescriptor.getName());
    }

    public RuntimeContext getContext() {
        return this.bundle;
    }

    public List<String> getExtensionsFromMimetypeName(String mimetypeName) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (String key : this.mimetypeByNormalisedRegistry.keySet()) {
            MimetypeEntry mimetypeEntry = this.mimetypeByNormalisedRegistry.get(key);
            if (!mimetypeEntry.getMimetypes().contains(mimetypeName)) continue;
            extensions.addAll(mimetypeEntry.getExtensions());
        }
        return extensions;
    }

    public MimetypeEntry getMimetypeEntryByName(String name) {
        return this.mimetypeByNormalisedRegistry.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimetypeFromFile(File file) throws MimetypeNotFoundException, MimetypeDetectionException {
        if (file.length() > 0xA00000L) {
            String exceptionMessage = "Not able to determine mime type from filename and file is too big for binary scan.";
            if (file.getAbsolutePath() == null) {
                throw new MimetypeNotFoundException(exceptionMessage);
            }
            try {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            catch (MimetypeNotFoundException e) {
                throw new MimetypeNotFoundException(exceptionMessage, (Throwable)e);
            }
        }
        try {
            String mimeType;
            MagicMatch match = Magic.getMagicMatch((File)file, (boolean)true, (boolean)false);
            if (match.getSubMatches().isEmpty()) {
                mimeType = match.getMimeType();
            } else {
                Collection possibilities = match.getSubMatches();
                Iterator iter = possibilities.iterator();
                MagicMatch m = (MagicMatch)iter.next();
                mimeType = m.getMimeType();
                possibilities.clear();
                match.setSubMatches(possibilities);
            }
            if ("text/plain".equals(mimeType)) {
                byte[] bytes = new byte[16];
                int n = 0;
                try (FileInputStream is = new FileInputStream(file);){
                    n = is.read(bytes);
                }
                for (int i = 0; i < n; ++i) {
                    if (bytes[i] != 0) continue;
                    mimeType = "application/octet-stream";
                    break;
                }
            }
            if ("???".equals(mimeType)) {
                mimeType = MediaType.OCTET_STREAM.toString();
            }
            return mimeType;
        }
        catch (MagicMatchNotFoundException e) {
            if (file.getAbsolutePath() != null) {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            throw new MimetypeNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new MimetypeDetectionException(e.getMessage(), (Throwable)e);
        }
    }

    public String getMimetypeFromExtension(String extension) throws MimetypeNotFoundException {
        String lowerCaseExtension = extension.toLowerCase();
        ExtensionDescriptor extensionDescriptor = this.extensionRegistry.get(lowerCaseExtension);
        if (extensionDescriptor == null) {
            MimetypeEntry mimetype = this.mimetypeByExtensionRegistry.get(lowerCaseExtension);
            if (mimetype == null) {
                throw new MimetypeNotFoundException("no registered mimetype has extension: " + lowerCaseExtension);
            }
            return mimetype.getNormalized();
        }
        if (extensionDescriptor.isAmbiguous()) {
            throw new MimetypeNotFoundException(String.format("mimetype for %s is ambiguous, binary sniffing needed", lowerCaseExtension));
        }
        return extensionDescriptor.getMimetype();
    }

    public String getMimetypeFromFilename(String filename) throws MimetypeNotFoundException {
        if (filename == null) {
            throw new MimetypeNotFoundException("filename is null");
        }
        String[] parts = filename.split("\\.");
        if (parts.length < 2) {
            throw new MimetypeNotFoundException(filename + "has no extension");
        }
        return this.getMimetypeFromExtension(parts[parts.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getMimetypeFromStream(InputStream stream) throws MimetypeNotFoundException, MimetypeDetectionException {
        String string;
        File file = null;
        file = File.createTempFile("NXMimetypeBean", ".bin");
        try {
            FileUtils.copyToFile((InputStream)stream, (File)file);
            string = this.getMimetypeFromFile(file);
            file.delete();
        }
        catch (Throwable throwable) {
            try {
                file.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw new MimetypeDetectionException(e.getMessage(), (Throwable)e);
            }
        }
        return string;
    }

    @Deprecated
    public String getMimetypeFromStreamWithDefault(InputStream is, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromStream(is);
        }
        catch (MimetypeNotFoundException e) {
            return defaultMimetype;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMimetypeFromBlob(Blob blob) throws MimetypeNotFoundException, MimetypeDetectionException {
        String string;
        File file = null;
        if (!blob.isPersistent()) {
            blob = blob.persist();
        }
        file = File.createTempFile("NXMimetypeBean", ".bin");
        try {
            try (InputStream is = blob.getStream();){
                FileUtils.copyToFile((InputStream)is, (File)file);
            }
            string = this.getMimetypeFromFile(file);
            file.delete();
        }
        catch (Throwable throwable) {
            try {
                file.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw new MimetypeDetectionException(e.getMessage(), (Throwable)e);
            }
        }
        return string;
    }

    public MimetypeEntry getMimetypeEntryByMimeType(String mimetype) {
        MimetypeEntry mtype = this.mimetypeByNormalisedRegistry.get("application/octet-stream");
        if (mimetype != null) {
            for (String key : this.mimetypeByNormalisedRegistry.keySet()) {
                MimetypeEntry entry = this.mimetypeByNormalisedRegistry.get(key);
                if (!mimetype.equals(entry.getNormalized()) && !entry.getMimetypes().contains(mimetype)) continue;
                mtype = entry;
                break;
            }
        }
        return mtype;
    }

    public String getMimetypeFromBlobWithDefault(Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromBlob(blob);
        }
        catch (MimetypeNotFoundException e) {
            return defaultMimetype;
        }
    }

    public String getMimetypeFromFilenameAndBlobWithDefault(String filename, Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromFilename(filename);
        }
        catch (MimetypeNotFoundException e) {
            try {
                return this.getMimetypeFromBlob(blob);
            }
            catch (MimetypeNotFoundException mtnfe) {
                return defaultMimetype;
            }
        }
    }

    public Blob updateMimetype(Blob blob, String filename) throws MimetypeDetectionException {
        if (!blob.isPersistent()) {
            try {
                blob = blob.persist();
            }
            catch (IOException e) {
                throw new MimetypeDetectionException(e.getMessage(), (Throwable)e);
            }
        }
        if (filename == null) {
            filename = blob.getFilename();
        } else if (blob.getFilename() == null) {
            blob.setFilename(filename);
        }
        String mimetype = this.getMimetypeFromFilenameAndBlobWithDefault(filename, blob, "application/octet-stream");
        blob.setMimeType(mimetype);
        return blob;
    }

    public Blob updateMimetype(Blob blob) throws MimetypeDetectionException {
        return this.updateMimetype(blob, null);
    }
}

