/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.Parser;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;
import org.eclipse.equinox.p2.cudf.solver.SimplePlanner;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;

public class P2CUDFDependencyResolver
implements DependencyResolver {
    protected static Log log = LogFactory.getLog(P2CUDFDependencyResolver.class);
    protected PackageManager pm;
    protected CUDFHelper cudfHelper;

    protected P2CUDFDependencyResolver() {
    }

    public P2CUDFDependencyResolver(PackageManager pm) {
        this.pm = pm;
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform) throws DependencyException {
        return this.resolve(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, CUDFHelper.defaultAllowSNAPSHOT);
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT) throws DependencyException {
        return this.resolve(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, allowSNAPSHOT, true);
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT, boolean doKeep) throws DependencyException {
        this.cudfHelper = new CUDFHelper(this.pm);
        this.cudfHelper.setTargetPlatform(targetPlatform);
        this.cudfHelper.setAllowSNAPSHOT(allowSNAPSHOT);
        this.cudfHelper.setKeep(doKeep);
        String cudf = this.cudfHelper.getCUDFFile(this.str2PkgDep(pkgInstall), this.str2PkgDep(pkgRemove), this.str2PkgDep(pkgUpgrade));
        log.debug((Object)("CUDF request:\n" + cudf));
        ProfileChangeRequest req = new Parser().parse(IOUtils.toInputStream((String)cudf));
        SolverConfiguration configuration = new SolverConfiguration("-removed,-notuptodate,-unsat_recommends,-new,-changed,-versionchanged");
        SimplePlanner planner = new SimplePlanner();
        planner.getSolutionFor(req, configuration);
        planner.stopSolver();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection solution = planner.getBestSolutionFoundSoFar();
        if (log.isTraceEnabled()) {
            log.trace((Object)planner.getExplanation());
        }
        if (!planner.isSolutionOptimal()) {
            log.warn((Object)"The solution found might not be optimal");
        }
        DependencyResolution resolution = this.cudfHelper.buildResolution(solution, planner.getSolutionDetails());
        if (!doKeep) {
            ArrayList<String> subInstall = new ArrayList<String>();
            ArrayList<String> subRemove = new ArrayList<String>();
            for (Map.Entry<String, Version> e : resolution.localPackagesToInstall.entrySet()) {
                subInstall.add(e.getKey() + '-' + e.getValue().toString());
            }
            for (Map.Entry<String, Version> e : resolution.localUnchangedPackages.entrySet()) {
                subInstall.add(e.getKey() + '-' + e.getValue().toString());
            }
            for (Map.Entry<String, Version> e : resolution.newPackagesToDownload.entrySet()) {
                subInstall.add(e.getKey() + '-' + e.getValue().toString());
            }
            for (DownloadablePackage pkg : this.pm.listInstalledPackages()) {
                String pkgId = pkg.getId();
                if (subInstall.contains(pkgId)) continue;
                subRemove.add(pkgId);
            }
            resolution = this.resolve(subInstall, subRemove, null, targetPlatform, allowSNAPSHOT, true);
        }
        return resolution;
    }

    private PackageDependency[] str2PkgDep(List<String> pkgList) {
        ArrayList<PackageDependency> list = new ArrayList<PackageDependency>();
        if (pkgList == null || pkgList.size() == 0) {
            return list.toArray(new PackageDependency[0]);
        }
        Map<String, DownloadablePackage> packagesByID = this.pm.getAllPackagesByID();
        for (String pkgStr : pkgList) {
            if (packagesByID.containsKey(pkgStr)) {
                DownloadablePackage pkg = packagesByID.get(pkgStr);
                list.add(new PackageDependency(pkg.getName(), pkg.getVersion(), pkg.getVersion()));
                continue;
            }
            list.add(new PackageDependency(pkgStr));
        }
        return list.toArray(new PackageDependency[list.size()]);
    }

    @Override
    public DependencyResolution resolve(String pkgIdOrName, String targetPlatform) throws DependencyException {
        ArrayList<String> pkgInstall = new ArrayList<String>();
        pkgInstall.add(pkgIdOrName);
        if (this.pm.isInstalled(pkgIdOrName) || !this.pm.findLocalPackageInstalledVersions(pkgIdOrName).isEmpty()) {
            return this.resolve(null, null, pkgInstall, targetPlatform);
        }
        return this.resolve(pkgInstall, null, null, targetPlatform);
    }
}

