/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.SnapshotMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class SnapshotInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "snapshot_in_progress";
    public static final String CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED = "cluster.routing.allocation.snapshot.relocation_enabled";
    private volatile boolean enableRelocation = false;

    public SnapshotInProgressAllocationDecider() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public SnapshotInProgressAllocationDecider(Settings settings) {
        this(settings, new NodeSettingsService(settings));
    }

    @Inject
    public SnapshotInProgressAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.enableRelocation = settings.getAsBoolean(CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED, (Boolean)this.enableRelocation);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    private Decision canMove(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (!this.enableRelocation && shardRouting.primary()) {
            SnapshotMetaData snapshotMetaData = (SnapshotMetaData)allocation.metaData().custom("snapshots");
            if (snapshotMetaData == null) {
                return allocation.decision(Decision.YES, NAME, "no snapshots are currently running", new Object[0]);
            }
            for (SnapshotMetaData.Entry snapshot : snapshotMetaData.entries()) {
                SnapshotMetaData.ShardSnapshotStatus shardSnapshotStatus = snapshot.shards().get(shardRouting.shardId());
                if (shardSnapshotStatus == null || shardSnapshotStatus.state().completed() || shardSnapshotStatus.nodeId() == null || !shardSnapshotStatus.nodeId().equals(shardRouting.currentNodeId())) continue;
                this.logger.trace("Preventing snapshotted shard [{}] to be moved from node [{}]", shardRouting.shardId(), shardSnapshotStatus.nodeId());
                return allocation.decision(Decision.NO, NAME, "snapshot for shard [%s] is currently running on node [%s]", shardRouting.shardId(), shardSnapshotStatus.nodeId());
            }
        }
        return allocation.decision(Decision.YES, NAME, "shard not primary or relocation disabled", new Object[0]);
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean newEnableRelocation = settings.getAsBoolean(SnapshotInProgressAllocationDecider.CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED, (Boolean)SnapshotInProgressAllocationDecider.this.enableRelocation);
            if (newEnableRelocation != SnapshotInProgressAllocationDecider.this.enableRelocation) {
                SnapshotInProgressAllocationDecider.this.logger.info("updating [{}] from [{}], to [{}]", SnapshotInProgressAllocationDecider.CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED, SnapshotInProgressAllocationDecider.this.enableRelocation, newEnableRelocation);
                SnapshotInProgressAllocationDecider.this.enableRelocation = newEnableRelocation;
            }
        }
    }
}

