/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.core.Events;
import org.jboss.seam.web.ServletContexts;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;

@Name(value="popupHelper")
@Scope(value=ScopeType.CONVERSATION)
public class PopupHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PopupHelper.class);
    public static final String POPUP_CATEGORY = "POPUP";
    @In(required=true, create=true)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient DeleteActions deleteActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient LockActions lockActions;
    protected DocumentModel currentContainer;
    protected DocumentModel currentParent;
    protected DocumentModel currentPopupDocument;
    protected List<Action> unfiltredActions;

    protected void computeUnfiltredPopupActions() {
        this.unfiltredActions = this.webActions.getAllActions(POPUP_CATEGORY);
    }

    public List<Action> getUnfiltredPopupActions() {
        if (this.unfiltredActions == null) {
            this.computeUnfiltredPopupActions();
        }
        for (Action act : this.unfiltredActions) {
            String lnk = act.getLink();
            if (!lnk.startsWith("javascript:")) continue;
            lnk = lnk.replaceFirst("javascript:", "");
            act.setLink(lnk);
        }
        return this.unfiltredActions;
    }

    public List<Action> getAvailablePopupActions(String popupDocId) {
        return this.webActions.getActionsList(POPUP_CATEGORY, this.createActionContext(popupDocId));
    }

    @WebRemote
    public List<String> getAvailableActionId(String popupDocId) {
        List<Action> availableActions = this.getAvailablePopupActions(popupDocId);
        ArrayList<String> availableActionsIds = new ArrayList<String>(availableActions.size());
        for (Action act : availableActions) {
            availableActionsIds.add(act.getId());
        }
        return availableActionsIds;
    }

    @WebRemote
    public List<String> getUnavailableActionId(String popupDocId) {
        ArrayList<String> result = new ArrayList<String>();
        List<Action> allActions = this.getUnfiltredPopupActions();
        ArrayList<String> allActionsIds = new ArrayList<String>(allActions.size());
        for (Action act : allActions) {
            allActionsIds.add(act.getId());
        }
        List<Action> availableActions = this.getAvailablePopupActions(popupDocId);
        ArrayList<String> availableActionsIds = new ArrayList<String>(availableActions.size());
        for (Action action : availableActions) {
            availableActionsIds.add(action.getId());
        }
        for (String string : allActionsIds) {
            if (availableActionsIds.contains(string)) continue;
            result.add(string);
        }
        return result;
    }

    protected ActionContext createActionContext(String popupDocId) {
        ActionContext ctx = this.actionContextProvider.createActionContext();
        DocumentModel currentDocument = ctx.getCurrentDocument();
        IdRef popupDocRef = new IdRef(popupDocId);
        try {
            DocumentModel popupDoc = this.documentManager.getDocument((DocumentRef)popupDocRef);
            ctx.setCurrentDocument(popupDoc);
            ctx.putLocalVariable("container", (Object)currentDocument);
            this.currentPopupDocument = popupDoc;
            this.currentContainer = currentDocument;
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return ctx;
    }

    @WebRemote
    public String getNavigationURL(String docId, String tabId) throws ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tabId != null) {
            params.put("tabId", tabId);
        }
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)doc, null, params, (boolean)false);
    }

    @WebRemote
    public String getNavigationURLOnContainer(String tabId) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tabId != null) {
            params.put("tabId", tabId);
        }
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)this.currentContainer, null, params, (boolean)false);
    }

    @WebRemote
    public String getNavigationURLOnPopupdoc(String tabId) {
        return this.getNavigationURLOnPopupdoc2(tabId, null);
    }

    protected HttpServletRequest getRequest() {
        HttpServletRequest request = ServletContexts.instance().getRequest();
        if (request != null) {
            return request;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return (HttpServletRequest)context.getExternalContext().getRequest();
        }
        return null;
    }

    @WebRemote
    public String getNavigationURLOnPopupdoc2(String tabId, String subTabId) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (tabId != null) {
            params.put("tabId", tabId);
        }
        if (subTabId != null) {
            params.put("subTabId", subTabId);
        }
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)this.currentPopupDocument, null, params, (boolean)false, (HttpServletRequest)this.getRequest());
    }

    protected Map<String, String> getCurrentTabParameters() {
        String subTabId;
        HashMap<String, String> params = new HashMap<String, String>();
        String tabId = this.webActions.getCurrentTabId();
        if (tabId != null) {
            params.put("tabId", tabId);
        }
        if ((subTabId = this.webActions.getCurrentSubTabId()) != null) {
            params.put("subTabId", subTabId);
        }
        return params;
    }

    @WebRemote
    public String getCurrentURL() {
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)this.currentContainer, null, this.getCurrentTabParameters(), (boolean)false);
    }

    @WebRemote
    public String getCurrentURLAfterDelete() {
        if (!this.isDocumentDeleted(this.currentContainer)) {
            this.currentParent = this.currentContainer;
        }
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)this.currentParent, null, this.getCurrentTabParameters(), (boolean)false);
    }

    @WebRemote
    public String deleteDocument(String docId) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        this.currentParent = this.getFirstParentAfterDelete(doc);
        ArrayList<DocumentModel> docsToDelete = new ArrayList<DocumentModel>(1);
        docsToDelete.add(doc);
        return this.deleteActions.deleteSelection(docsToDelete);
    }

    @WebRemote
    public String editTitle(String docId, String newTitle) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        doc.setProperty("dublincore", "title", (Object)newTitle);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        return "OK";
    }

    public boolean getIsCurrentContainerDirectParent() throws ClientException {
        if (this.documentManager != null && this.currentContainer != null && this.currentPopupDocument != null) {
            DocumentModel parent = this.documentManager.getParentDocument(this.currentPopupDocument.getRef());
            return this.currentContainer.equals(parent);
        }
        return false;
    }

    public boolean isDocumentHasBlobAttached(DocumentModel documentModel) throws ClientException {
        if (documentModel.hasSchema("file")) {
            Blob blob = (Blob)documentModel.getProperty("file", "content");
            return blob != null;
        }
        return false;
    }

    public boolean isDocumentHasBlobs(DocumentModel documentModel) throws ClientException {
        BlobHolder bh = (BlobHolder)documentModel.getAdapter(BlobHolder.class);
        if (bh != null) {
            List docBlobs = bh.getBlobs();
            return docBlobs != null && !docBlobs.isEmpty();
        }
        return false;
    }

    @WebRemote
    public String downloadDocument(String docId, String blobPropertyName, String filenamePropertyName) throws ClientException {
        DocumentModel documentModel = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        String filename = (String)((Object)documentModel.getPropertyValue(filenamePropertyName));
        return DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)documentModel, (String)blobPropertyName, (String)filename);
    }

    @WebRemote
    public String lockDocument(String docId) throws ClientException {
        DocumentModel documentModel = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        return this.lockActions.lockDocument(documentModel);
    }

    @WebRemote
    public String unlockDocument(String docId) throws ClientException {
        DocumentModel documentModel = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        return this.lockActions.unlockDocument(documentModel);
    }

    @WebRemote
    public String sendEmail(String docId) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        return DocumentModelFunctions.documentUrl(null, (DocumentModel)doc, (String)"send_notification_email", null, (boolean)false);
    }

    private DocumentModel getFirstParentAfterDelete(DocumentModel doc) throws ClientException {
        List parents = this.documentManager.getParentDocuments(doc.getRef());
        parents.remove(doc);
        Collections.reverse(parents);
        for (DocumentModel currentParent : parents) {
            try {
                this.documentManager.getDocument(currentParent.getRef());
                return currentParent;
            }
            catch (ClientException e) {
            }
        }
        return null;
    }

    private boolean isDocumentDeleted(DocumentModel doc) {
        try {
            doc = this.documentManager.getDocument(doc.getRef());
        }
        catch (ClientException e) {
            return true;
        }
        try {
            if ("deleted".equals(doc.getCurrentLifeCycleState())) {
                return true;
            }
        }
        catch (ClientException ex) {
            log.error((Object)ex);
        }
        return false;
    }
}

