/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class DirectoryCache {
    protected final String name;
    protected Cache entryCache;
    protected String entryCacheName = null;
    protected Cache entryCacheWithoutReferences;
    protected String entryCacheWithoutReferencesName = null;
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter hitsCounter;
    protected final Counter invalidationsCounter;
    protected final Counter maxCounter;
    protected final Counter sizeCounter;
    private static final Log log = LogFactory.getLog(DirectoryCache.class);

    protected DirectoryCache(String name) {
        this.name = name;
        this.hitsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "hits"}));
        this.invalidationsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "invalidations"}));
        this.sizeCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "size"}));
        this.maxCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "max"}));
    }

    protected boolean isCacheEnabled() {
        return this.entryCacheName != null && this.entryCacheWithoutReferencesName != null;
    }

    public DocumentModel getEntry(String entryId, EntrySource source) throws DirectoryException {
        return this.getEntry(entryId, source, true);
    }

    public DocumentModel getEntry(String entryId, EntrySource source, boolean fetchReferences) throws DirectoryException {
        if (!this.isCacheEnabled()) {
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        if (this.isCacheEnabled() && (this.getEntryCache() == null || this.getEntryCacheWithoutReferences() == null)) {
            log.warn((Object)"Your directory configuration for cache is wrong, directory cache will not be used.");
            if (this.getEntryCache() == null) {
                log.warn((Object)String.format("The cache for entry '%s' has not been found, please check the cache name or make sure you have deployed it", this.entryCacheName));
            }
            if (this.getEntryCacheWithoutReferences() == null) {
                log.warn((Object)String.format("The cache for entry without references '%s' has not been found, please check the cache name or make sure you have deployed it", this.entryCacheWithoutReferencesName));
            }
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        try {
            DocumentModel dm = null;
            if (fetchReferences) {
                dm = (DocumentModel)this.getEntryCache().get(entryId);
                if (dm == null) {
                    dm = source.getEntryFromSource(entryId, fetchReferences);
                    if (dm != null) {
                        this.getEntryCache().put(entryId, (Serializable)dm);
                        this.sizeCounter.inc();
                    }
                } else {
                    this.hitsCounter.inc();
                }
            } else {
                dm = (DocumentModel)this.getEntryCacheWithoutReferences().get(entryId);
                if (dm == null) {
                    dm = source.getEntryFromSource(entryId, fetchReferences);
                    if (dm != null) {
                        this.getEntryCacheWithoutReferences().put(entryId, (Serializable)dm);
                    }
                } else {
                    this.hitsCounter.inc();
                }
            }
            try {
                if (dm == null) {
                    return null;
                }
                DocumentModel clone = dm.clone();
                if (BaseSession.isReadOnlyEntry(dm)) {
                    BaseSession.setReadOnlyEntry(clone);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return dm;
            }
        }
        catch (IOException e) {
            throw new DirectoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(List<String> entryIds) {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                try {
                    for (String entryId : entryIds) {
                        this.getEntryCache().invalidate(entryId);
                        this.getEntryCacheWithoutReferences().invalidate(entryId);
                        this.sizeCounter.dec();
                        this.invalidationsCounter.inc();
                    }
                }
                catch (IOException e) {
                    throw new DirectoryException(e);
                }
            }
        }
    }

    public void invalidate(String ... entryIds) {
        this.invalidate(Arrays.asList(entryIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                try {
                    long count = this.sizeCounter.getCount();
                    this.sizeCounter.dec(count);
                    this.invalidationsCounter.inc(count);
                    this.getEntryCache().invalidateAll();
                    this.getEntryCacheWithoutReferences().invalidateAll();
                }
                catch (IOException e) {
                    throw new DirectoryException(e);
                }
            }
        }
    }

    public void setEntryCacheName(String entryCacheName) {
        this.entryCacheName = entryCacheName;
    }

    public void setEntryCacheWithoutReferencesName(String entryCacheWithoutReferencesName) {
        this.entryCacheWithoutReferencesName = entryCacheWithoutReferencesName;
    }

    public Cache getEntryCache() {
        if (this.entryCache == null) {
            this.entryCache = ((CacheService)Framework.getService(CacheService.class)).getCache(this.entryCacheName);
        }
        return this.entryCache;
    }

    public Cache getEntryCacheWithoutReferences() {
        if (this.entryCacheWithoutReferences == null) {
            this.entryCacheWithoutReferences = ((CacheService)Framework.getService(CacheService.class)).getCache(this.entryCacheWithoutReferencesName);
        }
        return this.entryCacheWithoutReferences;
    }
}

