/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class ElasticSearchIndexingImpl
implements ElasticSearchIndexing {
    private static final Log log = LogFactory.getLog(ElasticSearchIndexingImpl.class);
    private final ElasticSearchAdminImpl esa;
    private final Timer deleteTimer;
    private final Timer indexTimer;
    private final Timer bulkIndexTimer;
    private JsonESDocumentWriter jsonESDocumentWriter;

    public ElasticSearchIndexingImpl(ElasticSearchAdminImpl esa) {
        this.esa = esa;
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.indexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        this.deleteTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "delete"}));
        this.bulkIndexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "bulkIndex"}));
        this.jsonESDocumentWriter = new JsonESDocumentWriter();
    }

    public ElasticSearchIndexingImpl(ElasticSearchAdminImpl esa, JsonESDocumentWriter jsonESDocumentWriter) {
        this(esa);
        this.jsonESDocumentWriter = jsonESDocumentWriter;
    }

    @Override
    public void runIndexingWorker(List<IndexingCommand> cmds) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void runReindexingWorker(String repositoryName, String nxql) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNonRecursive(List<IndexingCommand> cmds) throws ClientException {
        int nbCommands = cmds.size();
        if (nbCommands == 1) {
            this.indexNonRecursive(cmds.get(0));
            return;
        }
        this.processBulkDeleteCommands(cmds);
        Timer.Context stopWatch = this.bulkIndexTimer.time();
        try {
            this.processBulkIndexCommands(cmds);
        }
        finally {
            stopWatch.stop();
        }
        this.esa.totalCommandProcessed.addAndGet(nbCommands);
        this.refreshIfNeeded(cmds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBulkDeleteCommands(List<IndexingCommand> cmds) {
        for (IndexingCommand cmd : cmds) {
            if (cmd.getType() != IndexingCommand.Type.DELETE) continue;
            Timer.Context stopWatch = this.deleteTimer.time();
            try {
                this.processDeleteCommand(cmd);
            }
            finally {
                stopWatch.stop();
            }
        }
    }

    void processBulkIndexCommands(List<IndexingCommand> cmds) throws ClientException {
        BulkRequestBuilder bulkRequest = this.esa.getClient().prepareBulk();
        for (IndexingCommand cmd : cmds) {
            if (cmd.getType() == IndexingCommand.Type.DELETE) continue;
            try {
                IndexRequestBuilder idxRequest = this.buildEsIndexingRequest(cmd);
                if (idxRequest == null) continue;
                bulkRequest.add(idxRequest);
            }
            catch (IllegalArgumentException | ClientException e) {
                if (e.getCause() instanceof NoSuchDocumentException) {
                    log.info((Object)("Skip indexing command to bulk, doc does not exists anymore: " + cmd));
                    continue;
                }
                log.error((Object)("Skip indexing command to bulk, fail to create request: " + cmd), e);
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            BulkResponse response;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index %d docs in bulk request: curl -XPOST 'http://localhost:9200/_bulk' -d '%s'", bulkRequest.numberOfActions(), ((BulkRequest)bulkRequest.request()).requests().toString()));
            }
            if ((response = (BulkResponse)bulkRequest.execute().actionGet()).hasFailures()) {
                log.error((Object)response.buildFailureMessage());
            }
        }
    }

    protected void refreshIfNeeded(List<IndexingCommand> cmds) {
        for (IndexingCommand cmd : cmds) {
            if (!this.refreshIfNeeded(cmd)) continue;
            return;
        }
    }

    private boolean refreshIfNeeded(IndexingCommand cmd) {
        if (cmd.isSync()) {
            this.esa.refresh();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNonRecursive(IndexingCommand cmd) throws ClientException {
        Timer.Context stopWatch = null;
        try {
            if (cmd.getType() == IndexingCommand.Type.DELETE) {
                stopWatch = this.deleteTimer.time();
                this.processDeleteCommand(cmd);
            } else {
                stopWatch = this.indexTimer.time();
                this.processIndexCommand(cmd);
            }
            this.refreshIfNeeded(cmd);
        }
        finally {
            if (stopWatch != null) {
                stopWatch.stop();
            }
            this.esa.totalCommandProcessed.incrementAndGet();
        }
    }

    void processIndexCommand(IndexingCommand cmd) {
        IndexRequestBuilder request;
        try {
            request = this.buildEsIndexingRequest(cmd);
        }
        catch (IllegalStateException | ClientException e) {
            if (e.getCause() instanceof NoSuchDocumentException) {
                request = null;
            }
            log.error((Object)("Fail to create request for indexing command: " + cmd), e);
            return;
        }
        if (request == null) {
            log.info((Object)("Cancel indexing command because target document does not exists anymore: " + cmd));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Index request: curl -XPUT 'http://localhost:9200/%s/%s/%s' -d '%s'", this.esa.getIndexNameForRepository(cmd.getRepositoryName()), "doc", cmd.getTargetDocumentId(), ((IndexRequest)request.request()).toString()));
        }
        request.execute().actionGet();
    }

    void processDeleteCommand(IndexingCommand cmd) {
        if (cmd.isRecurse()) {
            this.processDeleteCommandRecursive(cmd);
        } else {
            this.processDeleteCommandNonRecursive(cmd);
        }
    }

    void processDeleteCommandNonRecursive(IndexingCommand cmd) {
        String indexName = this.esa.getIndexNameForRepository(cmd.getRepositoryName());
        DeleteRequestBuilder request = this.esa.getClient().prepareDelete(indexName, "doc", cmd.getTargetDocumentId());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete request: curl -XDELETE 'http://localhost:9200/%s/%s/%s'", indexName, "doc", cmd.getTargetDocumentId()));
        }
        request.execute().actionGet();
    }

    void processDeleteCommandRecursive(IndexingCommand cmd) {
        String indexName = this.esa.getIndexNameForRepository(cmd.getRepositoryName());
        String docPath = this.getPathOfDocFromEs(cmd.getRepositoryName(), cmd.getTargetDocumentId());
        if (docPath == null) {
            if (!Framework.isTestModeSet()) {
                log.warn((Object)("Trying to delete a non existing doc: " + cmd.toString()));
            }
            return;
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((FilterBuilder)FilterBuilders.termFilter((String)"ecm:path.children", (String)docPath));
        DeleteByQueryRequestBuilder deleteRequest = this.esa.getClient().prepareDeleteByQuery(new String[]{indexName}).setTypes(new String[]{"doc"}).setQuery((QueryBuilder)query);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete byQuery request: curl -XDELETE 'http://localhost:9200/%s/%s/_query' -d '%s'", indexName, "doc", query.toString()));
        }
        DeleteByQueryResponse responses = (DeleteByQueryResponse)deleteRequest.execute().actionGet();
        for (IndexDeleteByQueryResponse response : responses) {
            if (response.getFailedShards() <= 0) continue;
            log.error((Object)String.format("Delete byQuery fails on shard: %d out of %d", response.getFailedShards(), response.getTotalShards()));
        }
    }

    String getPathOfDocFromEs(String repository, String docId) {
        GetResponse ret;
        String indexName = this.esa.getIndexNameForRepository(repository);
        GetRequestBuilder getRequest = this.esa.getClient().prepareGet(indexName, "doc", docId).setFields(new String[]{"ecm:path"});
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get path of doc: curl -XGET 'http://localhost:9200/%s/%s/%s?fields=%s'", indexName, "doc", docId, "ecm:path"));
        }
        if (!(ret = (GetResponse)getRequest.execute().actionGet()).isExists() || ret.getField("ecm:path") == null) {
            return null;
        }
        return ret.getField("ecm:path").getValue().toString();
    }

    IndexRequestBuilder buildEsIndexingRequest(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        if (doc == null) {
            return null;
        }
        try {
            JsonFactory factory = new JsonFactory();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            JsonGenerator jsonGen = factory.createJsonGenerator(builder.stream());
            this.jsonESDocumentWriter.writeESDocument(jsonGen, doc, cmd.getSchemas(), null);
            return this.esa.getClient().prepareIndex(this.esa.getIndexNameForRepository(cmd.getRepositoryName()), "doc", cmd.getTargetDocumentId()).setSource(builder);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Unable to create index request for Document " + cmd.getTargetDocumentId(), (Throwable)e);
        }
    }
}

