/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.CommonTermsQueryBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.PrefixFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.EsHint;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public final class NxqlQueryConverter {
    private static final Log log = LogFactory.getLog(NxqlQueryConverter.class);
    private static final String SELECT_ALL = "SELECT * FROM Document";
    private static final String SELECT_ALL_WHERE = "SELECT * FROM Document WHERE ";
    private static final String SIMPLE_QUERY_PREFIX = "es: ";

    private NxqlQueryConverter() {
    }

    public static QueryBuilder toESQueryBuilder(String nxql) {
        return NxqlQueryConverter.toESQueryBuilder(nxql, null);
    }

    public static QueryBuilder toESQueryBuilder(String nxql, CoreSession session) {
        final LinkedList<ExpressionBuilder> builders = new LinkedList<ExpressionBuilder>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        if (session != null) {
            nxqlQuery = NxqlQueryConverter.addSecurityPolicy(session, nxqlQuery);
        }
        ExpressionBuilder ret = new ExpressionBuilder(null);
        builders.add(ret);
        final ArrayList fromList = new ArrayList();
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){
            private static final long serialVersionUID = 1L;

            public void visitFromClause(FromClause node) {
                FromList elements = node.elements;
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                for (int i = 0; i < elements.size(); ++i) {
                    String type = (String)elements.get(i);
                    if ("Document".equalsIgnoreCase(type)) {
                        fromList.clear();
                        return;
                    }
                    Set types = schemaManager.getDocumentTypeNamesExtending(type);
                    if (types == null) continue;
                    fromList.addAll(types);
                }
            }

            public void visitMultiExpression(MultiExpression node) {
                Iterator it = node.values.iterator();
                while (it.hasNext()) {
                    ((Operand)it.next()).accept((IVisitor)this);
                    if (!it.hasNext()) continue;
                    node.operator.accept((IVisitor)this);
                }
            }

            public void visitSelectClause(SelectClause node) {
            }

            public void visitExpression(Expression node) {
                Operator op = node.operator;
                if (op == Operator.AND || op == Operator.OR || op == Operator.NOT) {
                    builders.add(new ExpressionBuilder(op.toString()));
                    super.visitExpression(node);
                    ExpressionBuilder expr = (ExpressionBuilder)builders.removeLast();
                    if (!builders.isEmpty()) {
                        ((ExpressionBuilder)builders.getLast()).merge(expr);
                    }
                } else {
                    String value;
                    String name;
                    Reference ref;
                    block7: {
                        ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
                        name = ref != null ? ref.name : node.lvalue.toString();
                        value = null;
                        try {
                            value = ((Literal)node.rvalue).asString();
                        }
                        catch (Throwable e) {
                            if (node.rvalue == null) break block7;
                            value = node.rvalue.toString();
                        }
                    }
                    Object[] values = null;
                    if (node.rvalue instanceof LiteralList) {
                        LiteralList items = (LiteralList)node.rvalue;
                        values = new Object[items.size()];
                        int i = 0;
                        for (Literal item : items) {
                            values[i++] = item.asString();
                        }
                    }
                    EsHint hint = ref != null ? ref.esHint : null;
                    ((ExpressionBuilder)builders.getLast()).add(NxqlQueryConverter.makeQueryFromSimpleExpression(op.toString(), name, value, values, hint));
                }
            }
        });
        QueryBuilder queryBuilder = ret.get();
        if (!fromList.isEmpty()) {
            return QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)NxqlQueryConverter.makeQueryFromSimpleExpression((String)"IN", (String)"ecm:primaryType", null, (Object[])fromList.toArray(), null).filter);
        }
        return queryBuilder;
    }

    protected static SQLQuery getSqlQuery(String nxql) {
        SQLQuery nxqlQuery;
        String query = NxqlQueryConverter.completeQueryWithSelect(nxql);
        try {
            nxqlQuery = SQLQueryParser.parse((Reader)new StringReader(query));
        }
        catch (QueryParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(e.getMessage() + " for query:\n" + query));
            }
            throw e;
        }
        return nxqlQuery;
    }

    protected static SQLQuery addSecurityPolicy(CoreSession session, SQLQuery query) {
        Collection transformers = NXCore.getSecurityService().getPoliciesQueryTransformers(session.getRepositoryName());
        for (SQLQuery.Transformer trans : transformers) {
            query = trans.transform(session.getPrincipal(), query);
        }
        return query;
    }

    protected static String completeQueryWithSelect(String nxql) {
        String query;
        String string = query = nxql == null ? "" : nxql.trim();
        if (query.isEmpty()) {
            query = SELECT_ALL;
        } else if (!query.toLowerCase().startsWith("select ")) {
            query = SELECT_ALL_WHERE + nxql;
        }
        return query;
    }

    public static QueryAndFilter makeQueryFromSimpleExpression(String op, String nxqlName, Object value, Object[] values, EsHint hint) {
        QueryBuilder query = null;
        ExistsFilterBuilder filter = null;
        String name = NxqlQueryConverter.getFieldName(nxqlName, hint);
        if (hint != null && hint.operator != null) {
            query = NxqlQueryConverter.makeHintQuery(name, value, hint);
        } else if (nxqlName.startsWith("ecm:fulltext") && ("=".equals(op) || "!=".equals(op) || "<>".equals(op) || "LIKE".equals(op) || "NOT LIKE".equals(op))) {
            query = NxqlQueryConverter.makeFulltextQuery(nxqlName, (String)value, hint);
            if ("!=".equals(op) || "<>".equals(op) || "NOT LIKE".equals(op)) {
                filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)query));
                query = null;
            }
        } else {
            switch (op) {
                case "=": {
                    filter = FilterBuilders.termFilter((String)name, (Object)value);
                    break;
                }
                case "<>": 
                case "!=": {
                    filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value));
                    break;
                }
                case ">": {
                    filter = FilterBuilders.rangeFilter((String)name).gt(value);
                    break;
                }
                case "<": {
                    filter = FilterBuilders.rangeFilter((String)name).lt(value);
                    break;
                }
                case ">=": {
                    filter = FilterBuilders.rangeFilter((String)name).gte(value);
                    break;
                }
                case "<=": {
                    filter = FilterBuilders.rangeFilter((String)name).lte(value);
                    break;
                }
                case "BETWEEN": 
                case "NOT BETWEEN": {
                    filter = FilterBuilders.rangeFilter((String)name).from(values[0]).to(values[1]);
                    if (!op.startsWith("NOT")) break;
                    filter = FilterBuilders.notFilter((FilterBuilder)filter);
                    break;
                }
                case "IN": 
                case "NOT IN": {
                    filter = FilterBuilders.inFilter((String)name, (Object[])values);
                    if (!op.startsWith("NOT")) break;
                    filter = FilterBuilders.notFilter((FilterBuilder)filter);
                    break;
                }
                case "IS NULL": {
                    filter = FilterBuilders.missingFilter((String)name).nullValue(true);
                    break;
                }
                case "IS NOT NULL": {
                    filter = FilterBuilders.existsFilter((String)name);
                    break;
                }
                case "LIKE": 
                case "ILIKE": 
                case "NOT LIKE": 
                case "NOT ILIKE": {
                    query = NxqlQueryConverter.makeLikeQuery(op, name, (String)value, hint);
                    if (!op.startsWith("NOT")) break;
                    filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)query));
                    query = null;
                    break;
                }
                case "STARTSWITH": {
                    filter = NxqlQueryConverter.makeStartsWithQuery(name, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operator: '" + op + "' is unknown");
                }
            }
        }
        return new QueryAndFilter(query, (FilterBuilder)filter);
    }

    private static QueryBuilder makeHintQuery(String name, Object value, EsHint hint) {
        RegexpQueryBuilder ret;
        switch (hint.operator) {
            case "match": {
                MatchQueryBuilder matchQuery = QueryBuilders.matchQuery((String)name, (Object)value);
                if (hint.analyzer != null) {
                    matchQuery.analyzer(hint.analyzer);
                }
                ret = matchQuery;
                break;
            }
            case "match_phrase": {
                MatchQueryBuilder matchQuery = QueryBuilders.matchPhraseQuery((String)name, (Object)value);
                if (hint.analyzer != null) {
                    matchQuery.analyzer(hint.analyzer);
                }
                ret = matchQuery;
                break;
            }
            case "match_phrase_prefix": {
                MatchQueryBuilder matchQuery = QueryBuilders.matchPhrasePrefixQuery((String)name, (Object)value);
                if (hint.analyzer != null) {
                    matchQuery.analyzer(hint.analyzer);
                }
                ret = matchQuery;
                break;
            }
            case "multi_match": {
                MultiMatchQueryBuilder multiMatchQuery = QueryBuilders.multiMatchQuery((Object)value, (String[])hint.getIndex());
                if (hint.analyzer != null) {
                    multiMatchQuery.analyzer(hint.analyzer);
                }
                ret = multiMatchQuery;
                break;
            }
            case "regex": {
                ret = QueryBuilders.regexpQuery((String)name, (String)((String)value));
                break;
            }
            case "fuzzy": {
                ret = QueryBuilders.fuzzyQuery((String)name, (String)((String)value));
                break;
            }
            case "wildcard": {
                ret = QueryBuilders.wildcardQuery((String)name, (String)((String)value));
                break;
            }
            case "common": {
                CommonTermsQueryBuilder commonQuery = QueryBuilders.commonTerms((String)name, (Object)value);
                if (hint.analyzer != null) {
                    commonQuery.analyzer(hint.analyzer);
                }
                ret = commonQuery;
                break;
            }
            case "query_string": {
                QueryStringQueryBuilder queryString = QueryBuilders.queryString((String)((String)value));
                if (hint.index != null) {
                    for (String index : hint.getIndex()) {
                        queryString.field(index);
                    }
                } else {
                    queryString.defaultField(name);
                }
                if (hint.analyzer != null) {
                    queryString.analyzer(hint.analyzer);
                }
                ret = queryString;
                break;
            }
            case "simple_query_string": {
                SimpleQueryStringBuilder querySimpleString = QueryBuilders.simpleQueryString((String)((String)value));
                if (hint.index != null) {
                    for (String index : hint.getIndex()) {
                        querySimpleString.field(index);
                    }
                } else {
                    querySimpleString.field(name);
                }
                if (hint.analyzer != null) {
                    querySimpleString.analyzer(hint.analyzer);
                }
                ret = querySimpleString;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operator: '" + hint.operator + "' is unknown");
            }
        }
        return ret;
    }

    private static FilterBuilder makeStartsWithQuery(String name, Object value) {
        PrefixFilterBuilder filter;
        if (!name.equals("ecm:path")) {
            filter = FilterBuilders.prefixFilter((String)name, (String)((String)value));
        } else if ("/".equals(value)) {
            filter = FilterBuilders.existsFilter((String)(name + ".children"));
        } else {
            String v = String.valueOf(value);
            if (v.endsWith("/")) {
                v = v.replaceAll("/$", "");
            }
            filter = FilterBuilders.termFilter((String)(name + ".children"), (String)v);
        }
        return filter;
    }

    private static QueryBuilder makeLikeQuery(String op, String name, String value, EsHint hint) {
        String wildcard;
        String fieldName = name;
        if (op.contains("ILIKE")) {
            value = value.toLowerCase();
            fieldName = name + ".lowercase";
        }
        if (hint != null && hint.index != null) {
            fieldName = hint.index;
        }
        if (StringUtils.countMatches((String)(wildcard = NxqlQueryConverter.likeToWildcard(value)), (String)"*") == 1 && wildcard.endsWith("*") && !wildcard.contains("?") && !wildcard.contains("\\")) {
            MatchQueryBuilder query = QueryBuilders.matchPhrasePrefixQuery((String)fieldName, (Object)wildcard.replace("*", ""));
            if (hint != null && hint.analyzer != null) {
                query.analyzer(hint.analyzer);
            }
            return query;
        }
        return QueryBuilders.wildcardQuery((String)fieldName, (String)wildcard);
    }

    protected static String likeToWildcard(String like) {
        StringBuilder wildcard = new StringBuilder();
        char[] chars = like.toCharArray();
        boolean escape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escapeNext = false;
            switch (c) {
                case '?': {
                    wildcard.append("\\?");
                    break;
                }
                case '%': 
                case '*': {
                    if (escape) {
                        wildcard.append(c);
                        break;
                    }
                    wildcard.append("*");
                    break;
                }
                case '_': {
                    if (escape) {
                        wildcard.append(c);
                        break;
                    }
                    wildcard.append("?");
                    break;
                }
                case '\\': {
                    if (escape) {
                        wildcard.append("\\\\");
                        break;
                    }
                    escapeNext = true;
                    break;
                }
                default: {
                    wildcard.append(c);
                }
            }
            escape = escapeNext;
        }
        if (escape) {
            // empty if block
        }
        return wildcard.toString();
    }

    private static QueryBuilder makeFulltextQuery(String nxqlName, String value, EsHint hint) {
        SimpleQueryStringBuilder.Operator defaultOperator;
        String name = nxqlName.replace("ecm:fulltext", "");
        name = name.startsWith(".") ? name.substring(1) + ".fulltext" : "_all";
        String queryString = value;
        if (queryString.startsWith(SIMPLE_QUERY_PREFIX)) {
            queryString = queryString.substring(SIMPLE_QUERY_PREFIX.length());
            defaultOperator = SimpleQueryStringBuilder.Operator.OR;
        } else {
            queryString = NxqlQueryConverter.translateFulltextQuery(queryString);
            defaultOperator = SimpleQueryStringBuilder.Operator.AND;
        }
        String analyzer = hint != null && hint.analyzer != null ? hint.analyzer : "fulltext";
        SimpleQueryStringBuilder query = QueryBuilders.simpleQueryString((String)queryString).defaultOperator(defaultOperator).analyzer(analyzer);
        if (hint != null && hint.index != null) {
            for (String index : hint.getIndex()) {
                query.field(index);
            }
        } else {
            query.field(name);
        }
        return query;
    }

    private static String getFieldName(String name, EsHint hint) {
        if (hint != null && hint.index != null) {
            return hint.index;
        }
        if ("ecm:isCheckedInVersion".equals(name)) {
            name = "ecm:isVersion";
        }
        name = name.replace("/*", "");
        name = name.replace("/", ".");
        return name;
    }

    public static List<SortInfo> getSortInfo(String nxql) {
        final ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){
            private static final long serialVersionUID = 1L;

            public void visitOrderByExpr(OrderByExpr node) {
                String name = node.reference.name;
                if ("ecm:fulltextScore".equals(name)) {
                    name = "_score";
                }
                sortInfos.add(new SortInfo(name, !node.isDescending));
            }
        });
        return sortInfos;
    }

    public static Map<String, Type> getSelectClauseFields(String nxql) {
        final LinkedHashMap<String, Type> fieldsAndTypes = new LinkedHashMap<String, Type>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){
            private static final long serialVersionUID = 1L;

            public void visitSelectClause(SelectClause selectClause) {
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                for (int i = 0; i < selectClause.getSelectList().size(); ++i) {
                    String name;
                    Operand op = selectClause.get(i);
                    if (!(op instanceof Reference)) continue;
                    Field field = schemaManager.getField(name = ((Reference)op).name);
                    fieldsAndTypes.put(name, field == null ? null : field.getType());
                }
            }
        });
        return fieldsAndTypes;
    }

    public static String translateFulltextQuery(String query) {
        return query.replace(" OR ", " | ").replace(" or ", " | ");
    }

    public static class ExpressionBuilder {
        public final String operator;
        public QueryBuilder query;

        public ExpressionBuilder(String op) {
            this.operator = op;
            this.query = null;
        }

        public void add(QueryAndFilter qf) {
            if (qf != null) {
                this.add(qf.query, qf.filter);
            }
        }

        public void add(QueryBuilder q) {
            this.add(q, null);
        }

        public void add(QueryBuilder q, FilterBuilder f) {
            if (q == null && f == null) {
                return;
            }
            QueryBuilder inputQuery = q;
            if (inputQuery == null) {
                inputQuery = QueryBuilders.constantScoreQuery((FilterBuilder)f);
            }
            if (this.operator == null) {
                this.query = inputQuery;
            } else {
                if (this.query == null) {
                    this.query = QueryBuilders.boolQuery();
                }
                BoolQueryBuilder boolQuery = (BoolQueryBuilder)this.query;
                if ("AND".equals(this.operator)) {
                    boolQuery.must(inputQuery);
                } else if ("OR".equals(this.operator)) {
                    boolQuery.should(inputQuery);
                } else if ("NOT".equals(this.operator)) {
                    boolQuery.mustNot(inputQuery);
                }
            }
        }

        public void merge(ExpressionBuilder expr) {
            if (expr.operator != null && expr.operator.equals(this.operator) && this.query == null) {
                this.query = expr.query;
            } else {
                this.add(new QueryAndFilter(expr.query, null));
            }
        }

        public QueryBuilder get() {
            if (this.query == null) {
                return QueryBuilders.matchAllQuery();
            }
            return this.query;
        }

        public String toString() {
            return this.query.toString();
        }
    }

    public static class QueryAndFilter {
        public final QueryBuilder query;
        public final FilterBuilder filter;

        public QueryAndFilter(QueryBuilder query, FilterBuilder filter) {
            this.query = query;
            this.filter = filter;
        }
    }
}

