/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.objects.NativeArray;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.MarshalingHelper;
import org.nuxeo.automation.scripting.internals.ScriptOperationContext;
import org.nuxeo.automation.scripting.internals.operation.ScriptingOperationInterface;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.DocumentWrapper;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

public class ScriptingOperationImpl {
    protected final ScriptOperationContext ctx;
    protected final Map<String, Object> args;
    protected final String source;

    public ScriptingOperationImpl(String source, ScriptOperationContext ctx, Map<String, Object> args) throws ScriptException {
        this.ctx = ctx;
        this.args = args;
        this.source = source;
    }

    public Object run(Object input) throws Exception {
        try {
            AutomationScriptingService scriptingService = (AutomationScriptingService)Framework.getService(AutomationScriptingService.class);
            scriptingService.setOperationContext(this.ctx);
            ScriptingOperationInterface itf = scriptingService.getInterface(ScriptingOperationInterface.class, this.source, this.ctx.getCoreSession());
            input = this.wrapArgsAndInput(input, this.args);
            Object object = this.unwrapResult(itf.run(input, this.args));
            return object;
        }
        catch (ScriptException e) {
            throw new OperationException((Throwable)e);
        }
        finally {
            if (this.ctx.get("isChainExecution") != null && !((Boolean)this.ctx.get("isChainExecution")).booleanValue()) {
                this.ctx.deferredDispose();
            }
        }
    }

    protected Object wrapArgsAndInput(Object input, Map<String, Object> args) {
        for (String entryId : args.keySet()) {
            Object entry = args.get(entryId);
            if (entry instanceof DocumentModel) {
                args.put(entryId, new DocumentWrapper(this.ctx.getCoreSession(), (DocumentModel)entry));
            }
            if (!(entry instanceof DocumentModelList)) continue;
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)entry) {
                docs.add(new DocumentWrapper(this.ctx.getCoreSession(), doc));
            }
            args.put(entryId, docs);
        }
        if (input instanceof DocumentModel) {
            return new DocumentWrapper(this.ctx.getCoreSession(), (DocumentModel)input);
        }
        if (input instanceof DocumentModelList) {
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)input) {
                docs.add(new DocumentWrapper(this.ctx.getCoreSession(), doc));
            }
            return docs;
        }
        return input;
    }

    protected Object unwrapResult(Object res) {
        for (String entryId : this.ctx.keySet()) {
            Object entry = this.ctx.get(entryId);
            if (entry instanceof DocumentWrapper) {
                this.ctx.put(entryId, ((DocumentWrapper)entry).getDoc());
                continue;
            }
            if (!(this.ctx.get(entryId) instanceof List)) continue;
            Object[] docs = new DocumentModelListImpl();
            List l = (List)entry;
            for (Object item : l) {
                if (!(this.ctx.get(entryId) instanceof DocumentWrapper)) continue;
                docs.add((Object)((DocumentWrapper)item).getDoc());
            }
            if (docs.size() != l.size() || docs.size() <= 0) continue;
            this.ctx.put(entryId, ((DocumentWrapper)entry).getDoc());
        }
        if (res == null) {
            return null;
        }
        if (res instanceof ScriptObjectMirror) {
            Object unwrapped = MarshalingHelper.unwrap((ScriptObjectMirror)res);
            if (unwrapped instanceof List) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                List l = (List)unwrapped;
                for (Object item : l) {
                    if (!(item instanceof DocumentWrapper)) continue;
                    docs.add((Object)((DocumentWrapper)item).getDoc());
                }
                if (docs.size() == l.size() && docs.size() > 0) {
                    return docs;
                }
            } else if (unwrapped instanceof DocumentWrapper) {
                return ((DocumentWrapper)unwrapped).getDoc();
            }
            return unwrapped;
        }
        if (res instanceof NativeArray) {
            Object[] resList = ((NativeArray)res).asObjectArray();
            DocumentModelListImpl documentModelList = new DocumentModelListImpl();
            BlobList blobList = new BlobList();
            for (Object entry : resList) {
                if (entry instanceof DocumentModel) {
                    documentModelList.add((Object)((DocumentModel)entry));
                    continue;
                }
                if (entry instanceof Blob) {
                    blobList.add((Object)((Blob)entry));
                    continue;
                }
                if (!(entry instanceof DocumentWrapper)) continue;
                documentModelList.add((Object)((DocumentWrapper)entry).getDoc());
            }
            return documentModelList.isEmpty() ? blobList : documentModelList;
        }
        if (res instanceof DocumentWrapper) {
            return ((DocumentWrapper)res).getDoc();
        }
        if (res instanceof List) {
            DocumentModelListImpl docs = new DocumentModelListImpl();
            List l = (List)res;
            for (Object item : l) {
                if (!(item instanceof DocumentWrapper)) continue;
                docs.add((Object)((DocumentWrapper)item).getDoc());
            }
            if (docs.size() == l.size() && docs.size() > 0) {
                return docs;
            }
        }
        return res;
    }
}

