/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import com.cforcoding.jmd.MarkDownParserAndSanitizer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class Md2HtmlConverter
implements Converter {
    private static final String BODY_CONTENT_ONLY = "bodyContentOnly";
    private ConverterDescriptor descriptor;

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Boolean bodyContentOnly = Boolean.FALSE;
        if (parameters != null) {
            bodyContentOnly = (Boolean)parameters.get(BODY_CONTENT_ONLY);
        }
        if (bodyContentOnly == null) {
            bodyContentOnly = Boolean.FALSE;
        }
        try {
            Blob inputBlob = blobHolder.getBlob();
            String mdString = inputBlob.getString();
            MarkDownParserAndSanitizer md = new MarkDownParserAndSanitizer();
            StringBuilder html = new StringBuilder();
            if (!bodyContentOnly.booleanValue()) {
                html.append("<html><head></head><body>");
            }
            html.append(md.transform(mdString));
            if (!bodyContentOnly.booleanValue()) {
                html.append("</body></html>");
            }
            Blob outputBlob = Blobs.createBlob((String)html.toString(), (String)this.descriptor.getDestinationMimeType());
            String filename = inputBlob.getFilename();
            if (filename != null) {
                int dotPosition = filename.lastIndexOf(46);
                if (dotPosition > -1) {
                    filename = filename.substring(0, dotPosition) + ".html";
                }
                outputBlob.setFilename(filename);
            }
            return new SimpleCachableBlobHolder(outputBlob);
        }
        catch (IOException e) {
            throw new ConversionException("Could not get Markdown string from BlobHolder", (Throwable)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

