/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.task;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class ChangePermissionUnrestricted
extends UnrestrictedSessionRunner {
    private final DocumentRef ref;
    private final NuxeoPrincipal principal;
    private final String aclName;
    private final String[] validators;

    public ChangePermissionUnrestricted(CoreSession session, DocumentModel document, String[] validators, NuxeoPrincipal principal, String aclName, ACL acl) {
        super(session);
        this.ref = document.getRef();
        this.validators = validators;
        this.principal = principal;
        this.aclName = aclName;
    }

    public void run() {
        ACP acp = this.session.getACP(this.ref);
        ACL acl = acp.getOrCreateACL(this.aclName);
        acl.clear();
        for (String validator : this.validators) {
            acl.add(new ACE(validator, "Read"));
            acl.add(new ACE(validator, "Write"));
        }
        acl.add(new ACE(this.principal.getName(), "Read"));
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        for (String group : userManager.getAdministratorsGroups()) {
            acl.add(new ACE(group, "Everything"));
        }
        acl.add(ACE.BLOCK);
        this.session.setACP(this.ref, acp, true);
        this.session.save();
    }
}

