/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

public interface DownloadService {
    public static final String EVENT_NAME = "download";
    public static final String NXFILE = "nxfile";
    public static final String NXDOWNLOADINFO = "nxdownloadinfo";
    public static final String NXBIGBLOB = "nxbigblob";
    public static final String NXBIGZIPFILE = "nxbigzipfile";
    public static final String BLOBHOLDER_PREFIX = "blobholder:";
    public static final String BLOBHOLDER_0 = "blobholder:0";

    public String getDownloadUrl(DocumentModel var1, String var2, String var3);

    public String getDownloadUrl(String var1, String var2, String var3, String var4);

    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7) throws IOException;

    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8) throws IOException;

    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8, Boolean var9) throws IOException;

    public void downloadBlob(HttpServletRequest var1, HttpServletResponse var2, DocumentModel var3, String var4, Blob var5, String var6, String var7, Map<String, Serializable> var8, Boolean var9, Consumer<ByteRange> var10) throws IOException;

    public void transferBlobWithByteRange(Blob var1, ByteRange var2, Supplier<OutputStream> var3);

    public void logDownload(DocumentModel var1, String var2, String var3, String var4, Map<String, Serializable> var5);

    public Blob resolveBlob(DocumentModel var1, String var2);

    public boolean checkPermission(DocumentModel var1, String var2, Blob var3, String var4, Map<String, Serializable> var5);

    public static class ByteRange {
        private final long start;
        private final long end;

        public ByteRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

