/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelReader;

public class DocumentsListReader
extends DocumentModelReader {
    private Iterator<DocumentModel> iterator;

    public DocumentsListReader(CoreSession session, List<DocumentModel> docsList) {
        super(session);
        this.iterator = docsList.iterator();
    }

    public static DocumentsListReader createDocumentsListReader(CoreSession session, Collection<DocumentRef> docRefsList) {
        ArrayList<DocumentModel> list = new ArrayList<DocumentModel>();
        for (DocumentRef docRef : docRefsList) {
            DocumentModel doc = session.getDocument(docRef);
            list.add(doc);
        }
        return new DocumentsListReader(session, list);
    }

    @Override
    public void close() {
        super.close();
        this.iterator = null;
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.iterator.hasNext()) {
            DocumentModel docModel = this.iterator.next();
            return new ExportedDocumentImpl(docModel, this.inlineBlobs);
        }
        return null;
    }
}

