/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;

public class XMLDocumentTreeWriter
extends XMLDocumentWriter {
    private static final Log log = LogFactory.getLog(XMLDocumentTreeWriter.class);
    private XMLWriter writer;

    public XMLDocumentTreeWriter(File file) throws IOException {
        super(file);
    }

    public XMLDocumentTreeWriter(OutputStream out) {
        super(out);
    }

    protected XMLWriter initWriter() {
        if (this.writer == null) {
            try {
                OutputFormat format = AbstractDocumentWriter.createCompactFormat();
                format.setSuppressDeclaration(true);
                this.writer = new XMLWriter(this.out, format);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.writer;
    }

    @Override
    public DocumentTranslationMap write(ExportedDocument doc) throws IOException {
        this.initWriter();
        this.writer.write(doc.getDocument());
        DocumentLocation oldLoc = doc.getSourceLocation();
        String oldServerName = oldLoc.getServerName();
        DocumentRef oldDocRef = oldLoc.getDocRef();
        DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(oldServerName, oldServerName);
        map.put(oldDocRef, oldDocRef);
        return map;
    }

    @Override
    public DocumentTranslationMap write(ExportedDocument[] docs) throws IOException {
        this.initWriter();
        this.out.write("<documents>".getBytes());
        this.out.flush();
        DocumentTranslationMap map = super.write(docs);
        this.writer.flush();
        this.out.write("</documents>".getBytes());
        return map;
    }

    @Override
    public DocumentTranslationMap write(Collection<ExportedDocument> docs) throws IOException {
        this.initWriter();
        this.out.write("<documents>".getBytes());
        this.out.flush();
        DocumentTranslationMap map = super.write(docs);
        this.writer.flush();
        this.out.write("</documents>".getBytes());
        return map;
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }
}

