/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.transformers;

import java.io.IOException;
import java.util.List;
import org.dom4j.Element;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.ExportedDocument;

public class FieldMapper
implements DocumentTransformer {
    protected final String srcSchemaName;
    protected final String dstSchemaName;
    protected final String srcField;
    protected final String dstField;

    public FieldMapper(String srcSchemaName, String srcField, String dstSchemaName, String dstField) {
        this.srcSchemaName = srcSchemaName;
        this.dstSchemaName = dstSchemaName == null && dstField != null ? srcSchemaName : dstSchemaName;
        this.srcField = srcField;
        this.dstField = dstField;
    }

    protected String getUnprefixedName(String name) {
        int idx = name.indexOf(":");
        if (idx > 0) {
            return name.substring(idx + 1);
        }
        return name;
    }

    protected String getPrefix(String name) {
        int idx = name.indexOf(":");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return null;
    }

    @Override
    public boolean transform(ExportedDocument xdoc) throws IOException {
        Element root = xdoc.getDocument().getRootElement();
        List schemas = root.elements("schema");
        Element src = null;
        if (schemas != null) {
            for (Object s : schemas) {
                Element schema = (Element)s;
                String name = schema.attribute("name").getText();
                if (!this.srcSchemaName.equalsIgnoreCase(name)) continue;
                src = schema.element(this.getUnprefixedName(this.srcField));
                src.detach();
            }
            Element dstSchema = null;
            if (this.dstField != null && src != null) {
                Element dst;
                for (Object s : schemas) {
                    Element schema = (Element)s;
                    String name = schema.attribute("name").getText();
                    if (!this.dstSchemaName.equalsIgnoreCase(name)) continue;
                    dstSchema = schema;
                    break;
                }
                if (dstSchema == null) {
                    dstSchema = root.addElement("schema");
                    dstSchema.addAttribute("name", this.dstSchemaName);
                }
                if ((dst = dstSchema.element(this.getUnprefixedName(this.dstField))) == null) {
                    String prefix = this.getPrefix(this.dstField);
                    dst = prefix == null || dstSchema.getNamespaceForPrefix(prefix) == null ? dstSchema.addElement(this.getUnprefixedName(this.dstField)) : dstSchema.addElement(this.dstField);
                }
                for (Object sub : src.elements()) {
                    Element e = (Element)sub;
                    e.detach();
                    dst.add(e);
                }
                String txt = src.getText();
                if (txt != null) {
                    dst.addText(txt);
                }
            }
        }
        return true;
    }
}

