/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.transformers;

import java.io.IOException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.ExportedDocument;

public class SchemaRenamer
implements DocumentTransformer {
    protected final String srcSchema;
    protected final String dstSchema;
    protected final String dstPrefix;

    public SchemaRenamer(String srcSchema, String dstSchema, String dstPrefix) {
        this.srcSchema = srcSchema;
        this.dstSchema = dstSchema;
        this.dstPrefix = dstPrefix;
    }

    @Override
    public boolean transform(ExportedDocument xdoc) throws IOException {
        Element root = xdoc.getDocument().getRootElement();
        List schemas = root.elements("schema");
        Object src = null;
        if (schemas != null) {
            for (Object s : schemas) {
                Element schema = (Element)s;
                String name = schema.attribute("name").getText();
                if (!this.srcSchema.equalsIgnoreCase(name)) continue;
                Namespace ns = new Namespace(this.dstPrefix, "http://www.nuxeo.org/ecm/schemas/" + this.dstSchema);
                schema.add(ns);
                schema.setAttributeValue("name", this.dstSchema);
                List fields = schema.elements();
                for (Element field : fields) {
                    field.setQName(new QName(field.getName(), ns));
                }
            }
        }
        return true;
    }
}

