/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.utils.DateParser;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ACPJsonWriter
extends ExtensibleEntityJsonWriter<ACP> {
    public static final String ENTITY_TYPE = "acls";

    public ACPJsonWriter() {
        super(ENTITY_TYPE, ACP.class);
    }

    @Override
    protected void writeEntityBody(ACP acp, JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart("acl");
        for (ACL acl : acp.getACLs()) {
            jg.writeStartObject();
            jg.writeStringField("name", acl.getName());
            jg.writeArrayFieldStart("ace");
            for (ACE ace : acl.getACEs()) {
                jg.writeStartObject();
                jg.writeStringField("id", ace.getId());
                jg.writeStringField("username", ace.getUsername());
                jg.writeStringField("permission", ace.getPermission());
                jg.writeBooleanField("granted", ace.isGranted());
                jg.writeStringField("creator", ace.getCreator());
                jg.writeStringField("begin", ace.getBegin() != null ? DateParser.formatW3CDateTime((Date)ace.getBegin().getTime()) : null);
                jg.writeStringField("end", ace.getEnd() != null ? DateParser.formatW3CDateTime((Date)ace.getEnd().getTime()) : null);
                jg.writeStringField("status", ace.getStatus().toString().toLowerCase());
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

