/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonReader
extends EntityJsonReader<DocumentModel> {
    public static final String LEGACY_MODE_READER = "DocumentModelLegacyModeReader";

    public DocumentModelJsonReader() {
        super("document");
    }

    @Override
    public DocumentModel read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        Reader reader = (Reader)this.ctx.getParameter(LEGACY_MODE_READER);
        if (reader != null) {
            DocumentModel doc = (DocumentModel)reader.read(clazz, genericType, mediaType, in);
            return doc;
        }
        return (DocumentModel)super.read(clazz, genericType, mediaType, in);
    }

    @Override
    protected DocumentModel readEntity(JsonNode jn) throws IOException {
        JsonNode propsNode;
        String type;
        SimpleDocumentModel simpleDoc = new SimpleDocumentModel();
        String name = this.getStringField(jn, "name");
        if (StringUtils.isNotBlank((String)name)) {
            simpleDoc.setPathInfo(null, name);
        }
        if (StringUtils.isNotBlank((String)(type = this.getStringField(jn, "type")))) {
            simpleDoc.setType(type);
        }
        if ((propsNode = jn.get("properties")) != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            List properties = (List)this.readEntity(List.class, genericType, propsNode);
            for (Property property : properties) {
                String propertyName = property.getName();
                if (!propertyName.contains(":")) {
                    propertyName = property.getField().getDeclaringType().getName() + ":" + propertyName;
                }
                simpleDoc.setPropertyValue(propertyName, property.getValue());
            }
        }
        SimpleDocumentModel doc = null;
        String uid = this.getStringField(jn, "uid");
        if (StringUtils.isNotBlank((String)uid)) {
            try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(null);){
                doc = wrapper.getSession().getDocument((DocumentRef)new IdRef(uid));
            }
            this.avoidBlobUpdate((DocumentModel)simpleDoc, (DocumentModel)doc);
            DocumentModelJsonReader.applyDirtyPropertyValues((DocumentModel)simpleDoc, (DocumentModel)doc);
        } else if (StringUtils.isNotBlank((String)type)) {
            SimpleDocumentModel createdDoc = new SimpleDocumentModel();
            if (StringUtils.isNotBlank((String)name)) {
                createdDoc.setPathInfo(null, name);
            }
            createdDoc.setType(simpleDoc.getType());
            DocumentModelJsonReader.applyAllPropertyValues((DocumentModel)simpleDoc, (DocumentModel)createdDoc);
            doc = createdDoc;
        } else {
            doc = simpleDoc;
        }
        return doc;
    }

    private void avoidBlobUpdate(DocumentModel docToClean, DocumentModel docRef) {
        for (String schema : docToClean.getSchemas()) {
            for (String field : docToClean.getDataModel(schema).getDirtyFields()) {
                this.avoidBlobUpdate(docToClean.getProperty(field), docRef);
            }
        }
    }

    private void avoidBlobUpdate(Property propToClean, DocumentModel docRef) {
        block6: {
            block5: {
                if (!(propToClean instanceof BlobProperty)) break block5;
                if (propToClean.getValue() != null) break block6;
                Serializable value = docRef.getPropertyValue(propToClean.getPath());
                propToClean.setValue((Object)value);
                break block6;
            }
            if (propToClean instanceof ComplexProperty) {
                ComplexProperty complexPropToClean = (ComplexProperty)propToClean;
                for (Field field : complexPropToClean.getType().getFields()) {
                    Property childPropToClean = complexPropToClean.get(field.getName().getLocalName());
                    this.avoidBlobUpdate(childPropToClean, docRef);
                }
            } else if (propToClean instanceof ListProperty) {
                ListProperty listPropToClean = (ListProperty)propToClean;
                for (int i = 0; i < listPropToClean.size(); ++i) {
                    Property elPropToClean = listPropToClean.get(i);
                    this.avoidBlobUpdate(elPropToClean, docRef);
                }
            }
        }
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst) {
        DocumentModelJsonReader.applyPropertyValues(src, dst, true);
    }

    public static void applyPropertyValues(DocumentModel src, DocumentModel dst, boolean dirtyOnly) {
        if (dirtyOnly) {
            DocumentModelJsonReader.applyDirtyPropertyValues(src, dst);
        } else {
            DocumentModelJsonReader.applyAllPropertyValues(src, dst);
        }
    }

    public static void applyDirtyPropertyValues(DocumentModel src, DocumentModel dst) {
        String[] schemas;
        for (String schema : schemas = src.getSchemas()) {
            DataModelImpl dataModel = (DataModelImpl)dst.getDataModel(schema);
            DataModelImpl fromDataModel = (DataModelImpl)src.getDataModel(schema);
            for (String field : fromDataModel.getDirtyFields()) {
                Serializable data = (Serializable)fromDataModel.getData(field);
                try {
                    if (!(dataModel.getDocumentPart().get(field) instanceof BlobProperty)) {
                        dataModel.setData(field, (Object)data);
                        continue;
                    }
                    dataModel.setData(field, (Object)DocumentModelJsonReader.decodeBlob(data));
                }
                catch (PropertyNotFoundException e) {}
            }
        }
    }

    public static void applyAllPropertyValues(DocumentModel src, DocumentModel dst) {
        String[] schemas;
        SchemaManager service = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType type = service.getDocumentType(src.getType());
        for (String schemaName : schemas = type.getSchemaNames()) {
            Schema schema = service.getSchema(schemaName);
            DataModelImpl dataModel = (DataModelImpl)dst.getDataModel(schemaName);
            DataModelImpl fromDataModel = (DataModelImpl)src.getDataModel(schemaName);
            for (Field field : schema.getFields()) {
                String fieldName = field.getName().getLocalName();
                Serializable data = (Serializable)fromDataModel.getData(fieldName);
                try {
                    if (!(dataModel.getDocumentPart().get(fieldName) instanceof BlobProperty)) {
                        dataModel.setData(fieldName, (Object)data);
                        continue;
                    }
                    dataModel.setData(fieldName, (Object)DocumentModelJsonReader.decodeBlob(data));
                }
                catch (PropertyNotFoundException e) {}
            }
        }
    }

    private static Serializable decodeBlob(Serializable data) {
        if (data instanceof Blob) {
            return data;
        }
        return null;
    }
}

