/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class UserVisiblePermissionsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "userVisiblePermissions";

    public UserVisiblePermissionsJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        List userVisiblePermissions = permissionProvider.getUserVisiblePermissionDescriptors(document.getType());
        jg.writeArrayFieldStart(NAME);
        for (UserVisiblePermission permission : userVisiblePermissions) {
            jg.writeString(permission.getId());
        }
        jg.writeEndArray();
    }
}

