/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.storage;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.management.api.StorageError;
import org.nuxeo.runtime.api.Framework;

public abstract class DocumentStoreSessionRunner
extends UnrestrictedSessionRunner {
    protected static String repositoryName;

    public static void setRepositoryName(String name) {
        repositoryName = name;
    }

    public DocumentStoreSessionRunner() {
        super(repositoryName);
    }

    public DocumentStoreSessionRunner(CoreSession session) {
        super(session);
        if (!repositoryName.equals(session.getRepositoryName())) {
            throw new IllegalArgumentException("Session is not attached to " + repositoryName);
        }
    }

    public void runSafe() {
        ClassLoader jarCL = Thread.currentThread().getContextClassLoader();
        ClassLoader bundleCL = Framework.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleCL);
            this.runUnrestricted();
        }
        catch (NuxeoException e) {
            throw new StorageError("Storage error :  " + this.errorMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(jarCL);
        }
    }

    protected String errorMessage() {
        return String.format("%s:%s", ((Object)((Object)this)).getClass().getCanonicalName(), ((Object)((Object)this)).toString());
    }
}

