/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class MarkdownPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        String basePath = VirtualHostHelper.getContextPathProperty();
        StringBuffer html = new StringBuffer();
        html.append("<html><head>");
        html.append("<title>" + this.getPreviewTitle(dm) + "</title>");
        html.append(String.format("<script src=\"%s/bower_components/webcomponentsjs/webcomponents-lite.js\"></script>", basePath));
        html.append(String.format("<link rel=\"import\" href=\"%s/viewers/marked-element.vulcanized.html\">", basePath));
        try {
            html.append("<marked-element>");
            html.append("<div class=\"markdown-html\"></div>");
            html.append("<script type=\"text/markdown\">");
            html.append(blob.getString());
            html.append("</script>");
            html.append("</marked-element>");
            html.append("</body>");
            Blob mainBlob = Blobs.createBlob((String)html.toString(), (String)"text/html", null, (String)"index.html");
            blobResults.add(mainBlob);
            return blobResults;
        }
        catch (IOException e) {
            throw new PreviewException(e);
        }
    }
}

