/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import java.util.NoSuchElementException;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class ESUIDSequencer
extends AbstractUIDSequencer {
    protected Client esClient = null;

    protected Client getClient() {
        if (this.esClient == null) {
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
            try {
                this.ensureESIndex(this.esClient);
            }
            catch (NoSuchElementException | NuxeoException e) {
                this.esClient = null;
                throw e;
            }
        }
        return this.esClient;
    }

    public void dispose() {
        if (this.esClient != null) {
            this.esClient.close();
        }
    }

    public long getNextLong(String sequenceName) {
        String source = "{ \"ts\" : " + System.currentTimeMillis() + "}";
        IndexResponse res = (IndexResponse)this.getClient().prepareIndex(this.getESIndexName(), "seqId", sequenceName).setSource(source).execute().actionGet();
        return res.getVersion();
    }

    public int getNext(String sequenceName) {
        return (int)this.getNextLong(sequenceName);
    }

    public void init() {
        this.getClient();
    }

    protected void ensureESIndex(Client esClient) {
        boolean indexExists = ((IndicesExistsResponse)esClient.admin().indices().prepareExists(new String[]{this.getESIndexName()}).execute().actionGet()).isExists();
        if (!indexExists) {
            throw new NuxeoException(String.format("Sequencer %s needs an elasticSearchIndex contribution with type %s", this.getName(), "seqId"));
        }
    }

    protected String getESIndexName() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getIndexNameForType("seqId");
    }
}

