/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.rendition.extension.AutomationRenderer;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractLazyCachableRenditionProvider
implements RenditionProvider {
    public static final String WORKERID_KEY = "workerid";
    public static final String CACHE_NAME = "LazyRenditionCache";
    protected static Log log = LogFactory.getLog(AbstractLazyCachableRenditionProvider.class);
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public List<Blob> render(DocumentModel doc, RenditionDefinition def) {
        String key = this.buildRenditionKey(doc, def);
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(CACHE_NAME);
        if (ts == null) {
            throw new NuxeoException("Unable to find Transient Store  LazyRenditionCache");
        }
        if (!ts.exists(key)) {
            Work work = this.getRenditionWork(key, doc, def);
            ts.putParameter(key, WORKERID_KEY, (Serializable)((Object)work.getId()));
            ArrayList<StringBlob> blobs = new ArrayList<StringBlob>();
            StringBlob emptyBlob = new StringBlob("");
            emptyBlob.setFilename("inprogress");
            emptyBlob.setMimeType("text/plain;empty=true");
            blobs.add(emptyBlob);
            ts.putBlobs(key, blobs);
            ((WorkManager)Framework.getService(WorkManager.class)).schedule(work);
        } else {
            ts.release(key);
        }
        return ts.getBlobs(key);
    }

    public String getVariant(DocumentModel doc, RenditionDefinition definition) {
        return AutomationRenderer.getVariant(doc, definition);
    }

    protected String buildRenditionKey(DocumentModel doc, RenditionDefinition def) {
        String variant;
        StringBuffer sb = new StringBuffer(doc.getId());
        sb.append("::");
        String modificationDatePropertyName = def.getSourceDocumentModificationDatePropertyName();
        Calendar modif = (Calendar)doc.getPropertyValue(modificationDatePropertyName);
        if (modif != null) {
            sb.append(modif.getTimeInMillis());
            sb.append("::");
        }
        if ((variant = this.getVariant(doc, def)) != null) {
            sb.append(variant);
            sb.append("::");
        }
        sb.append(def.getName());
        return this.getDigest(sb.toString());
    }

    protected String getDigest(String key) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return key;
        }
        byte[] buf = digest.digest(key.getBytes());
        return this.toHexString(buf);
    }

    protected String toHexString(byte[] data) {
        StringBuilder buf = new StringBuilder(2 * data.length);
        for (byte b : data) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    protected abstract Work getRenditionWork(String var1, DocumentModel var2, RenditionDefinition var3);
}

